import numpy as np
import pandas as pd
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc

OEmodel = pd.read_excel('Figure2_data.xlsx', sheet_name = 'physiologicalParameters_Hap4OE')
DMmodel = pd.read_excel('Figure2_data.xlsx', sheet_name = 'pp_Hap4delta_GAM40')
DMmodel_24 = pd.read_excel('Figure2_data.xlsx', sheet_name = 'pp_Hap4delta_GAM24')
anaerobic = pd.read_excel('Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM40')
anaerobic_24 = pd.read_excel('Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM24')

OEmeasurements = pd.read_excel('Figure2_data.xlsx', sheet_name = 'experimentalData_Hap4OE')
DMmeasurements = pd.read_excel('Figure2_data.xlsx', sheet_name = 'experimentalData_Hap4delta')
AAmeasurements = pd.read_excel('Figure2_data.xlsx', sheet_name = 'experimentalData_anaerobic')

mpl.style.use('default')

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (14, 5))
ax = fig.subplots(1,3)
ax = ax.ravel()

ax[0].set_title('Hap4 overexpression')
ax[1].set_title(r'$\Delta$Hap4')
ax[2].set_title(r'Anaerobic WT')

for i in [['qGlc', r'$qGlc$'], ['qO2', r'$qO_{2}$'], ['qEtOH', r'$qEtOH$'], ['qCO2', r'$qCO_{2}$'], ['qGlyc', r'$qGlyc$']]:
	color = next(ax[0]._get_lines.prop_cycler)['color']
	ax[0] = OEmeasurements.plot(x = 'mu', y = i[0], ax = ax[0], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, label = i[1])
	ax[1] = DMmeasurements.plot(x = 'mu', y = i[0], ax = ax[1], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[2] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CEN.PK'].plot(x = 'mu', y = i[0], ax = ax[2], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[2] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CBS8066'].plot(x = 'mu', y = i[0], ax = ax[2], ls='', c = color, marker='v', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[0] = OEmodel.plot(x = 'mu', y = i[0], ax = ax[0], c = color, lw = 2.5, label = i[1])
	ax[1] = DMmodel.plot(x = 'mu', y = i[0], ax = ax[1], c = color, lw = 2.5, legend = None)
	ax[2] = anaerobic.plot(x = 'mu', y = i[0], ax = ax[2], c = color, lw = 2.5, legend = None)
	ax[1] = DMmodel_24.plot(x = 'mu', y = i[0], ax = ax[1], c = color, lw = 1., legend = None)
	ax[2] = anaerobic_24.plot(x = 'mu', y = i[0], ax = ax[2], c = color, lw = 1., legend = None)

plt.setp(ax, xlim = [0.0,0.40], ylim = [0.0, 30.0])
ax[0].set_xlim(0.0,0.50)

h, l = ax[0].get_legend_handles_labels()
ax[0].legend(handles=zip(h[0::2], h[1::2]), labels=l[0::2], handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, title = 'Flux', fontsize = 'medium')

h, l = ax[2].get_legend_handles_labels()
ax[2].legend(handles=h[0:2], labels=['CEN.PK', 'CBS8066'], handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, title = 'Strain', fontsize = 'medium')

for i in range(len(ax)):
	ax[i].set_aspect(1./ax[i].get_data_ratio())
	ax[i].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i].set_ylabel('Specific flux ($mmol\ gDW^{-1}\ h^{-1}$)')

plt.savefig('Figure2.pdf')
#plt.show()

