import copy
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec
from scipy.stats import linregress

expData = pd.read_excel('Figure1_data.xlsx', sheet_name = 'measuredPhysiologicalParameters')
modelSim = pd.read_excel('Figure1_data.xlsx', sheet_name = 'physiologicalParameters')

plt.rcParams['font.size'] = '14'
fig = plt.figure(figsize = (12, 14))
gs = gridspec.GridSpec(4,3, wspace = 0.5, hspace = 0.5)

gs_top = gridspec.GridSpecFromSubplotSpec(4,3, gs[0:2,0:4], hspace = 0.5, wspace = 1.0) #nrows, ncols
gs_bttm = gridspec.GridSpecFromSubplotSpec(1,4, gs[2,0:4], hspace = 0.5, wspace = 0.5)
gs_prot = gridspec.GridSpecFromSubplotSpec(1,4, gs[3,0:4], hspace = 0.5, wspace = 0.5)

ax = list(range(11))
ax[0] = fig.add_subplot(gs_top[0:2,2])
ax[1] = fig.add_subplot(gs_top[2:4,2])
ax[2] = fig.add_subplot(gs_top[0:4,0:2])

# Constraint panels
ax[3] = fig.add_subplot(gs_bttm[0,0])
ax[4] = fig.add_subplot(gs_bttm[0,1])
ax[5] = fig.add_subplot(gs_bttm[0,2])
ax[6] = fig.add_subplot(gs_bttm[0,3])

ax[7] = fig.add_subplot(gs_prot[0,0])
ax[8] = fig.add_subplot(gs_prot[0,1])
ax[9] = fig.add_subplot(gs_prot[0,2])
ax[10] = fig.add_subplot(gs_prot[0,3])

mpl.style.use('default')

color=next(ax[0]._get_lines.prop_cycler)['color']

ax[0] = expData.plot(x = 'mu', y = 'RQ', label = 'Experimental data', ax = ax[0], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, legend = None)
ax[0] = modelSim.plot(x = 'mu', y = 'RQ', color = color, label = 'Model simulation', lw = 3.0, ax = ax[0], legend = None)

ax[1] = expData.plot(x = 'mu', y = 'Yxs', label = 'Experimental data', ls ='', ax = ax[1], marker='o', color = color, markeredgecolor = 'black', markersize = 9, legend = None)
ax[1] = modelSim.plot(x = 'mu', y = 'Yxs', label = 'Model simulation', color = color, lw = 3.0, ax = ax[1], legend = None)

color_scheme = []
labels = [r'q$Glc$',r'q$O_{2}$', r'q$EtOH$', r'q$CO_{2}$', r'q$Glyc$']
for i in range(0,5): 
	color = next(ax[2]._get_lines.prop_cycler)['color']
	color_scheme.append(color)

ax[2] = expData.plot(x = 'mu', y = expData.columns[1:6], label = labels, ls ='', ax = ax[2], marker= 'o', color = color_scheme, markeredgecolor = 'black', markersize = 9)
ax[2] = modelSim.plot(x = 'mu', y = modelSim.columns[1:6], label = labels, color = color_scheme, lw = 3.0, ax = ax[2])

for i in [[5, 'RelUP', 'Unspecified protein'], [3, 'RelCarbonUpt', 'Carbon uptake'], [4, 'RelMitoVol', 'Mito. capacity'], [6, 'RelNitrogenUpt', 'Nitrogen uptake']]:
	ax[i[0]].hlines(1.0, 0.0, 0.5, linestyles = 'dotted', color = 'black')
	color=next(ax[1]._get_lines.prop_cycler)['color']
	ax[i[0]] = modelSim.plot('mu', y = i[1], ax = ax[i[0]], color = color, lw = 3.0, legend = None)
	ax[i[0]].set_xlabel('')
	ax[i[0]].set_ylabel('')
	ax[i[0]].set_title(i[2], fontsize = 14)
	ax[i[0]].set_xlim(0.0,0.5)
	ax[i[0]].set_ylim(0.0,1.1)
	ax[i[0]].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i[0]].set_ylabel('Constraint Expression')

########### PROTEOME
mappings = pd.read_excel('/home/pranas/SURFdrive/MEmodels/data/PG_annotations/AnnotationSetPG.xls', sheet_name = 'S. cerevisiae')

predP = pd.read_excel('Figure1_data.xlsx', sheet_name = 'predictedProteome')
measP_chemostat = pd.read_excel('Figure1_data.xlsx', sheet_name = 'measuredProteomeChemostat')
measP_batch = pd.read_excel('Figure1_data.xlsx', sheet_name = 'measuredProteomeTreGlcBatch')
measP_chxCtrl = pd.read_excel('Figure1_data.xlsx', sheet_name = 'measuredProteomeCHXctrl')

predictedCl = pd.DataFrame(columns = ['Pathway'] + list(predP.columns[3:]))
predictedCl.Pathway = mappings.Pathway.unique()
for i in predictedCl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clusterPredicted = predP.loc[predP['Protein'].isin(clusterMapped['Protein'])]
	for j in predictedCl.columns[1:]:
		predictedCl.loc[predictedCl.Pathway == i, j] = sum(clusterPredicted[j])

measuredCl_chemostat = pd.DataFrame(columns = ['Pathway'] + list(measP_chemostat.columns[1:]))
measuredCl_chemostat.Pathway = mappings.Pathway.unique()
for i in measuredCl_chemostat.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP_chemostat.loc[measP_chemostat['Protein'].isin(clusterMapped['Protein'])]
	for j in measuredCl_chemostat.columns[1:]:
		measuredCl_chemostat.loc[measuredCl_chemostat.Pathway == i, j] = sum(clustermeasured[j])

measuredCl_batch = pd.DataFrame(columns = ['Pathway'] + list(measP_batch.columns[1:]))
measuredCl_batch.Pathway = mappings.Pathway.unique()
for i in measuredCl_batch.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP_batch.loc[measP_batch['Protein'].isin(clusterMapped['Protein'])]
	for j in measuredCl_batch.columns[1:]:
		measuredCl_batch.loc[measuredCl_batch.Pathway == i, j] = sum(clustermeasured[j])

measuredCl_chxCtrl = pd.DataFrame(columns = ['Pathway'] + list(measP_chxCtrl.columns[1:]))
measuredCl_chxCtrl.Pathway = mappings.Pathway.unique()
for i in measuredCl_chxCtrl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP_chxCtrl.loc[measP_chxCtrl['Protein'].isin(clusterMapped['Protein'])]
	for j in measuredCl_chxCtrl.columns[1:]:
		measuredCl_chxCtrl.loc[measuredCl_chxCtrl.Pathway == i, j] = sum(clustermeasured[j])

clustersToPlot = ['Amino acid biosynthesis', 'Glycolysis', 'TCA cycle', 'Oxidative phosphorylation']

for i in zip(clustersToPlot, range(7,11), [0.20, 0.20, 0.05, 0.10]):
	ax[i[1]] = measuredCl_chemostat.set_index('Pathway').T[i[0]].plot(ax = ax[i[1]], ls='', color = color_scheme[0], marker='o', markeredgecolor = 'black', markersize = 9, label = 'Chemostat')
	ax[i[1]] = measuredCl_batch.set_index('Pathway').T[i[0]].plot(ax = ax[i[1]], ls='', color = color_scheme[0], marker='v', markeredgecolor = 'black', markersize = 9, label = 'Batch')
	ax[i[1]] = measuredCl_chxCtrl.set_index('Pathway').T[i[0]].plot(ax = ax[i[1]], ls='', color = color_scheme[0], marker='s', markeredgecolor = 'black', markersize = 9, label = 'CHX control')
	ax[i[1]] = predictedCl.set_index('Pathway').T[i[0]].plot(label = 'Model simulation', color = color_scheme[0], lw = 3.0, ax = ax[i[1]])
	ax[i[1]].set_title(i[0])
	ax[i[1]].set_ylim(0.0, i[2])
	ax[i[1]].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i[1]].set_ylabel('Proteome fraction')



########### GENERAL
ax[0].set_title('Respiratory Quotient', fontsize = 14)
ax[0].set_xlabel(r'Growth rate ($h^{-1}$)')
ax[0].set_ylabel(r'RQ ($q_{CO_{2}}/q_{O_{2}}$)')
ax[0].set_ylim([0.0,15.0])

ax[1].set_title('Growth yield on glucose', fontsize = 14)
ax[1].set_ylabel(r'$Y_{X/S}$ ($gDW/g Glc$)')
ax[1].set_xlabel(r'Growth rate ($h^{-1}$)')
ax[1].set_ylim([0.0,0.6])

ax[2].set_xlabel(r'Growth rate ($h^{-1}$)')
ax[2].set_ylabel(r'Specific flux ($mmol\ gDW^{-1}\ h^{-1}$)')
ax[2].set_ylim(0.0,25.0)

h, l = ax[2].get_legend_handles_labels()
ax[2].legend(handles=h[-5:], labels=l[0:5], 
           handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, title = 'Flux', fontsize = 'large')

for i in range(len(ax)): 
	ax[i].set_xlim([0.0,0.5])
	ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('Fig1.pdf')
#plt.show()

