require(ape)
require(xlsx)
# install.packages("remotes")
# remotes::install_github("fmichonneau/phyloch")
require(phyloch)
require(phytools)

### Getting uncorrected DNA distances ###
stja_dna<-read.nexus.data("../data/STJA_ND2_subsampled.nex")

names(stja_dna)
gymno<-stja_dna[1:2]
aphe<-stja_dna[3:4]
crist<-stja_dna[5:7]
stja_puebla<-stja_dna[8]
stja_chiapas<-stja_dna[9]
stja_gua<-stja_dna[10:11]
stja_coastal<-stja_dna[12:31]
stja_interior<-stja_dna[32:51]
stja_rocky<-stja_dna[52:71]

?dist.dna

getDNAstats<-function(list1,list2){
	dist_foo<-dist.dna(as.DNAbin(c(list1,list2),model="raw",as.matrix=T))
	dist_trim<-as.matrix(dist_foo)[((length(list1)+1):length(c(list1, list2))),(1:length(list2))]
	dist_min<-min(dist_trim)
	dist_mean<-mean(dist_trim)
	dist_max<-max(dist_trim)
	return(list(min=dist_min,mean=dist_mean,max=dist_max))
}

stja_coastal_vs_interior<-getDNAstats(stja_coastal,stja_interior)
stja_rocky_vs_mex<-getDNAstats(stja_rocky,c(stja_puebla,stja_chiapas,stja_gua))
stja_coastalinterior_vs_rockymex<-getDNAstats(c(stja_coastal,stja_interior),c(stja_rocky,stja_puebla,stja_chiapas,stja_gua))
stja_vs_cyano<-getDNAstats(c(stja_coastal,stja_interior,stja_rocky,stja_puebla,stja_chiapas,stja_gua),crist)
aphe_vs_gymno<-getDNAstats(gymno,aphe)
stja_vs_aphegymno<-getDNAstats(c(stja_coastal,stja_interior,stja_rocky,stja_puebla,stja_chiapas,stja_gua),c(aphe,gymno))

aphe_vs_aphe<-getDNAstats(aphe[1],aphe[2])

### Read in pop designations and assign tips ###
pop_numbs<-read.xlsx2("../data/2_Cyanocitta_microsats_19Apr2022_FINAL.xlsx",sheetName="Pop list with ind #",stringsAsFactors=F)
pop_numbs$Option[pop_numbs$Option=="2"]<-"1"

### Read in phylogeny and make figure ###
stja_mcc<-read.beast("../data/STJA_run123_MCC.tre")
stja_raxml<-read.tree("~/Desktop/Manuscripts/StellersJays/PhyloND2/RAXML/RAxML_bipartitions.STJA_ND2_RAxML.tre")

### set up node labels ###
nodelab_vec<-rep(NA,Nnode(stja_mcc))
nodelab_vec[which(stja_mcc$posterior==1)]<-"21"

name_vec<-stja_mcc$tip.label[stja_mcc$edge[,2][stja_mcc$edge[,2]<=Ntip(stja_mcc)]]

phylo_col_vec<-c("yellow3","skyblue","purple")[as.numeric(factor(pop_numbs[na.omit(as.numeric(sapply(strsplit(name_vec,"_"),function(x) x[1]))),]$Option.1.Group))]

## Format tip labels ###
stja_mcc$tip.label<-gsub("C\\d+_","",stja_mcc$tip.label)
stja_mcc$tip.label<-gsub("Ccristata","Cyanocitta_cristata", stja_mcc$tip.label)

pdf(file="../output/ND2_phylogeny_v2.pdf",width=3.25,height=5)
#quartz(width=3.25,height=5)

par(mar=c(1.5,0.25,0,5.75))
plot(stja_mcc,show.tip.label=F,lwd=0.5)

par(xpd=F)
abline(v=seq((max(vcv.phylo(stja_mcc))-10),max(vcv.phylo(stja_mcc)),length.out=11)[-11],lty=2,lwd=0.25,col="gray80")

nodelabels(pch=as.numeric(nodelab_vec),bg="black",cex=0.45)

axis(1,at=seq((max(vcv.phylo(stja_mcc))-10),max(vcv.phylo(stja_mcc)),length.out=11),labels=10:0,mgp=c(0,0.05,0),tck=-0.015,cex.axis=0.5)
par(xpd=NA)
text(x=11.25,y=-4.3,label="mya",cex=0.5)

for(i in 1:length(phylo_col_vec)){
	rect(xleft=max(vcv.phylo(stja_mcc))+0.1,ybottom=i-0.51, xright=max(vcv.phylo(stja_mcc))+0.35,ytop=i+0.5,lwd=0,col=phylo_col_vec[i])
}

tiplabels(text=gsub("_"," ",stja_mcc$tip.label),frame="none",adj=c(0,0.5),offset=0.5,cex=0.35)

### Add DNA distance to nodes ###
nodelabels(text=paste0(round(100*(stja_rocky_vs_mex$mean),2),"%"),node=findMRCA(stja_mcc,tips=c("MX_Puebla_MBM15056","63_CO_Chaffee_MVZ187995")),frame="none",cex=0.5,adj=c(-0.15,0.5))

nodelabels(text=paste0(round(100*(stja_coastalinterior_vs_rockymex $mean),2),"%"),node=findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","63_CO_Chaffee_MVZ187995")),frame="none",cex=0.5,adj=c(-0.15,0.5))

nodelabels(text=paste0(round(100*(stja_vs_cyano $mean),2),"%"),node=findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","Cyanocitta_cristata_DQ912604_KU4390")),frame="none",cex=0.5,adj=c(-0.15,0.5))

nodelabels(text=paste0(round(100*(stja_vs_aphegymno $mean),2),"%"),node=findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","Gymnorhinus_cyanocephalus_DQ912615.1")),frame="none",cex=0.5,adj=c(-0.15,0.5))

dev.off()

### get timing of MRCA between Coastal / Interior and Rocky STJA

stja_mcc$height[findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","63_CO_Chaffee_MVZ187995"))-Ntip(stja_mcc)]
stja_mcc$'height_95%_HPD_MIN'[findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","63_CO_Chaffee_MVZ187995"))-Ntip(stja_mcc)]
stja_mcc$'height_95%_HPD_MAX'[findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","63_CO_Chaffee_MVZ187995"))-Ntip(stja_mcc)]

findMRCA(stja_mcc,tips=c("13_WA_Whatcom_MVZ182142","63_CO_Chaffee_MVZ187995"))
### get timing of MRCA between BLJA and STJA
str(stja_mcc)
stja_mcc$height[findMRCA(stja_mcc,tips=c("Cyanocitta_cristata_DQ912604_KU4390","63_CO_Chaffee_MVZ187995"))-Ntip(stja_mcc)]
stja_mcc$'height_95%_HPD_MIN'[findMRCA(stja_mcc,tips=c("Cyanocitta_cristata_DQ912604_KU4390","63_CO_Chaffee_MVZ187995"))-Ntip(stja_mcc)]
stja_mcc$'height_95%_HPD_MAX'[findMRCA(stja_mcc,tips=c("Cyanocitta_cristata_DQ912604_KU4390","63_CO_Chaffee_MVZ187995"))-Ntip(stja_mcc)]
