#install.packages("MCMCpack")
install.packages("~/Downloads/hzar_0.2-5.tar.gz", repos = NULL, type="source")

library("hzar") #May need to be installed from source https://cran.r-project.org/src/contrib/Archive/hzar/
library("rgdal")
library("rgeos")
library("xlsx")

##### Load RDATA files from previous hzar analyses #####
load('../data/StellersJay_msat_clinal_18May2018.RData')
Cstmsat<-Cst
load('../data/Cyanocitta_HZAR_ND2.RData')
CstND2 <-Cst
load('../data/Cyanocitta_morpho_PCAscores.RData')
CstPC1 <-Cst
load('../data/Cyanocitta_streaks_HZAR_analysis.RData')
CstStreaks <-Cst

rm(Cst)

### Read in population coordinates ###
pop_coords<-read.xlsx2("../utility/Cyanocitta_stelleri_population_mapping.xlsx",sheetName="Sheet1",stringsAsFactors=F)
pop_coords<-pop_coords[-c((nrow(pop_coords)-1),nrow(pop_coords)),] #remove extraneous rows
rownames(pop_coords)<-pop_coords$Row.Labels
pop_coords$Row.Labels<-NULL

### Read in Cline locations ###
cline_loc<-read.table("../utility/Cst_msat_clinal_locality.txt",stringsAsFactors=F)

##### Create list containing best model of each analysis #####
jay.plots <- list()
jay.plots[[1]] <- Cstmsat$msat$analysis$model.selected
jay.plots[[2]] <- CstND2$ND2$analysis$model.selected
jay.plots[[3]] <- CstPC1$morph$analysis$model.selected
jay.plots[[4]] <- CstStreaks$streaks$analysis$model.selected

#par(mar=c(4.25,4.25,1,1))
#dev.new(height=3.5, width=3.5, noRStudioGD = FALSE)
#hzar.plot.fzCline(jay.plots[[1]], pch = 21,fzCol="#9CF91B90")
#hzar.plot.fzCline(jay.plots[[2]], pch = 15,fzCol="#FFEC3390", add=T)
#hzar.plot.fzCline(jay.plots[[4]], pch = 17,fzCol="#87E8FF90", add=T)
#hzar.plot.fzCline(jay.plots[[3]], pch = 19,fzCol="#FDA6FE90", add=T)

### Contact zone pop numberes corresponding to geographic sampling figure ###
contact_zone<-c(41,43,49,50,51,52,53,54,55,60,61)

##### Set up plotting space #####
#par("mai")
#par("mar")
#dev.new(width = 3.25, height = 3.25, unit="in", noRStudioGD = FALSE)

tiff(file="../output/HZARplot_wmap_v6.tiff", width = 3.25, height = 2.75, unit="in",res=800)

#quartz(width=3.25,height=2.75)
par(mar=c(2,3,0.5,3)) ## margins go in this order: (B, L, T, R)

##### Make line width thinner re Carla request 14 Mar 2020 #####
par(lwd=0.5)

##### Plot msat hzar curve without axes #####
hzar.plot.fzCline(jay.plots[[1]], pch = 19,fzCol="#9F72EC80", axes=FALSE, xlab="", ylab="", 
                  col="#5E3C99",ylim=c(-0.1,1)) ## msats, purple

axis(2, ylim=c(-0.5,1),col="black",las=1,cex.axis=0.8,tck=-0.025,lwd=0.5)  ## las=1 makes horizontal tick marks
mtext("Frequency / Q score",side=2,line=2.25, cex=.8)

##### Add PC1 score hzar curve onto msat curve, with y-axis on right #####
par(new=TRUE) ## Allow plotting curve onto existing curve
hzar.plot.fzCline(jay.plots[[3]], pch = 18,fzCol="#DA552670",
                  xlab="", ylab="",axes=FALSE, col="#DA5526") ## PC1 scores; brown

axis(4, ylim=c(-30,40), col="black",col.axis="black",las=1,cex.axis=0.8,lwd=0.5,tck=-0.025)
par(xpd=NA)
text(x= par("usr")[2]+355,y=mean(par("usr")[3:4]),srt=270,label="Morphology PC1 score",cex=0.8) 

### Add Box ###
box()

##### Add x-axis #####
distance<-jay.plots[[1]]$obsData$frame$dist
axis(1, cex.axis=.55,mgp=c(0,0.1,0),tck=-0.025,lwd=0.5)
axis(1, at=cline_loc[,2],labels= contact_zone,tck=0.025,cex.axis=0.45,mgp=c(0,-1.25,0),lwd=0.5)
axis(1, at=cline_loc[,2][c(6,8,10)],labels=contact_zone[c(6,8,10)],tck=0.025,cex.axis=0.45,mgp=c(0,-1.55,0),lwd=0.5)

mtext("Distance (km)",side=1,col="black",line=1.1, cex=0.8)

#mtext("Bonner Co., ID", side=1, col="black",line=1.1, cex=0.6, at=0)
#mtext("Boulder Mtn., UT", side=1, col="black",line=1.1, cex=0.6, at=1300)

##### Plot 2 remaining hzar curves (ND2 & streaks) #####
par(new=TRUE)
hzar.plot.fzCline(jay.plots[[2]], pch = 15,fzCol="#FEBC3870", xlab="", ylab="",axes=FALSE, col="#F69100",ylim=c(-0.1,1)) ## ND2; orange

par(new=TRUE)
hzar.plot.fzCline(jay.plots[[4]], pch = 17,fzCol="#9AD8FB70",  xlab="",ylab="",axes=FALSE, col="#136FA3",ylim=c(-0.1,1)) ## streaks; blue

##### Create legend #####
legend("topright",legend=c("microsatellite Q score","ND2 haplotype freq", "blue streak freq", "morphology PC1 score"),text.col=c("#5E3C99","#F69100", "#136FA3","#DA5526"),pch=c(19,15,17,18),col=c("#5E3C99","#F69100", "#136FA3","#DA5526"),cex=0.35,pt.cex=0.65)

### Add map inset ###
### Set up subplot boundaries via trial and error (mostly) ###
par(fig=c(0,0.65,0.1,0.6),new=T) 
#box(col="red") #See where the subplot is and adjust accordingly

### Read in ADM political boundaries for United States for subplot###
na_adm0<-readOGR("../utility/na_adm0/na_adm0_crop.shp")
na_adm1<-readOGR("../utility/na_adm1/na_adm1_crop.shp")

### Read in steller's jay range map ###
steller_range<-readOGR("../utility/Cyanocitta_stelleri_shp/Cyanocitta_stelleri.shp")
steller_s<-gSimplify(steller_range,tol=0.1) #Simplify polygon so that it plots in a reasonable amount of time

par(xpd=F)
plot(steller_s,xlim=c(-116,-108),ylim=c(37,50),col=NA,border=NA)
plot(usa_adm1,add=T,border="gray80",lwd=0.5)
plot(steller_s,xlim=c(-116,-108),ylim=c(37,50),col="#FF00FF20",border=NA,add=T)

box()

points(x=as.numeric(pop_coords[cline_loc[,1],]$Dec.Long),y=as.numeric(pop_coords[cline_loc[,1],]$Dec.Lat),pch=21,cex=0.5,lwd=0.5)
points(x=as.numeric(pop_coords[cline_loc[,1],]$Dec.Long),y=as.numeric(pop_coords[cline_loc[,1],]$Dec.Lat),type="l",lwd=0.5)
text(x=c(-117.8,-110),y=c(49,37.65),label=c(41,61),cex=0.45)

##### turn off device #####
dev.off()

