require(plotrix) #this provides textbox function

### This is an updated copy of a previous version 
### The Rocky-only STRUCTURE run had to be redone when the definition of our contact zone was updated
### This script remakes the same STRUCTURE plot with the updated Rocky-only barplot

### Color pallete ###
colors<-c("purple","skyblue","yellow3","pink","gray")

### Structure output plots ###
require(xlsx)

k2<-readLines(file("../data/AllPopsK2.outfile"))
k2<-strsplit(trimws(sapply(strsplit(k2,":"),function(x) x[2]))," ")
k2<-matrix(as.numeric(unlist(k2)),ncol=2,byrow=T)
k2<-k2[,c(2,1)]

k3<-readLines(file("../data/AllPopsK3.outfile"))
k3<-strsplit(trimws(sapply(strsplit(k3,":"),function(x) x[2]))," ")
k3<-matrix(as.numeric(unlist(k3)),ncol=3,byrow=T)

k4<-readLines(file("../data/AllPopsK4.outfile"))
k4<-strsplit(trimws(sapply(strsplit(k4,":"),function(x) x[2]))," ")
k4<-matrix(as.numeric(unlist(k4)),ncol=4,byrow=T)

k5<-readLines(file("../data/AllPopsK5.outfile"))
k5<-strsplit(trimws(sapply(strsplit(k5,":"),function(x) x[2]))," ")
k5<-matrix(as.numeric(unlist(k5)),ncol=5,byrow=T)

k6<-readLines(file("../data/AllPopsK6.outfile"))
k6<-strsplit(trimws(sapply(strsplit(k6,":"),function(x) x[2]))," ")
k6<-matrix(as.numeric(unlist(k6)),ncol=6,byrow=T)

k7<-readLines(file("../data/AllPopsK7.outfile"))
k7<-strsplit(trimws(sapply(strsplit(k7,":"),function(x) x[2]))," ")
k7<-matrix(as.numeric(unlist(k7)),ncol=7,byrow=T)

k8<-readLines(file("../data/AllPopsK8.outfile"))
k8<-strsplit(trimws(sapply(strsplit(k8,":"),function(x) x[2]))," ")
k8<-matrix(as.numeric(unlist(k8)),ncol=8,byrow=T)

### Read in population counts ###
pop_ass<-read.xlsx2("../data/2_Cyanocitta_microsats_19Apr2022_FINAL.xlsx",sheetName="Pop list with ind #",stringsAsFactors=F)

pop_ass$pop_start<-as.numeric(sapply(strsplit(pop_ass$Ind..,"-"),function(x) x[1]))
pop_ass$pop_end<-as.numeric(sapply(strsplit(pop_ass$Ind..,"-"),function(x) x[2]))

par(lwd=0.0005)
k2_barplot<-barplot(t(k2),axes=F)

bp_sep<-k2_barplot[2]-k2_barplot[2]

png(file="../output/Structure_allpops_variousK.png",width=6.5,height=6,units="in",res=500)

#quartz(width=6.5,height=6)
#dev.new(width=6.5,height=6)
par(mfrow=c(6,1))
par(mar=c(1,0,1,0),oma=c(1.5,0,1.5,0))

### Full Population Plot ###
plot(1:10,1:10,xlim=c(1,1075),ylim=c(0,1),type="n",axes=F,xlab="",ylab="")

for(i in 1:nrow(k2)){
	rect(i,0,i+1,k2[i,1],col="indianred3",border=NA)
	rect(i,k2[i,1],i+1,1,col="purple",border=NA)
}

for(i in 1:nrow(pop_ass)){
	rect(xleft=pop_ass$pop_start[i],ybottom=0,xright= pop_ass$pop_end[i],ytop=1,col="transparent",border="black",lwd=0.25)
	par(xpd=NA)
	if(i%%2==1){
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5)
		}
	}else{
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5)
		}
	}
}

par(xpd=NA)

mtext(text="K = 2",side=2,cex=1,line=-1.5)

par(xpd=T)

plot(1:10,1:10,xlim=c(1,1075),ylim=c(0,1),type="n",axes=F,xlab="",ylab="")

for(i in 1:nrow(k3)){
		rect(i,0,i+1, k3[i,1],col="skyblue",border=NA)
		rect(i,k3[i,1],i+1, (k3[i,1]+k3[i,2]),col="purple",border=NA)
		rect(i,(k3[i,1]+k3[i,2]),i+1, (k3[i,1]+k3[i,2]+k3[i,3]),col="yellow3",border=NA)
}

for(i in 1:nrow(pop_ass)){
	rect(xleft=pop_ass$pop_start[i],ybottom=0,xright= pop_ass$pop_end[i],ytop=1,col="transparent",border="black",lwd=0.25)
	par(xpd=NA)
	if(i%%2==1){
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5)
		}
	}else{
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5)
		}
	}
}

par(xpd=NA)

mtext(text="K = 3",side=2,cex=1,line=-1.5)

par(xpd=T)

plot(1:10,1:10,xlim=c(1,1075),ylim=c(0,1),type="n",axes=F,xlab="",ylab="")

for(i in 1:nrow(k4)){
		rect(i,0,i+1, k4[i,1],col="purple",border=NA)
		rect(i,k4[i,1],i+1, (k4[i,1]+k4[i,2]),col="yellow3",border=NA)
		rect(i,(k4[i,1]+k4[i,2]),i+1, (k4[i,1]+k4[i,2]+k4[i,3]),col="lightgreen",border=NA)
		rect(i,(k4[i,1]+k4[i,2]+k4[i,3]),i+1, (k4[i,1]+k4[i,2]+k4[i,3]+k4[i,4]),col="skyblue",border=NA)
}

for(i in 1:nrow(pop_ass)){
	rect(xleft=pop_ass$pop_start[i],ybottom=0,xright= pop_ass$pop_end[i],ytop=1,col="transparent",border="black",lwd=0.25)
	par(xpd=NA)
	if(i%%2==1){
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5)
		}
	}else{
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5)
		}
	}
}

par(xpd=NA)

mtext(text="K = 4",side=2,cex=1,line=-1.5)

par(xpd=T)

plot(1:10,1:10,xlim=c(1,1075),ylim=c(0,1),type="n",axes=F,xlab="",ylab="")

for(i in 1:nrow(k5)){
		rect(i,0,i+1, k5[i,1],col="yellow3",border=NA)
		rect(i,k5[i,1],i+1, (k5[i,1]+k5[i,2]),col="purple",border=NA)
		rect(i,(k5[i,1]+k5[i,2]),i+1, (k5[i,1]+k5[i,2]+k5[i,3]),col="pink",border=NA)
		rect(i,(k5[i,1]+k5[i,2]+k5[i,3]),i+1, (k5[i,1]+k5[i,2]+k5[i,3]+k5[i,4]),col="skyblue",border=NA)
		rect(i,(k5[i,1]+k5[i,2]+k5[i,3]+k5[i,4]),i+1, (k5[i,1]+k5[i,2]+k5[i,3]+k5[i,4]+k5[i,5]),col="lightgreen",border=NA)
}

for(i in 1:nrow(pop_ass)){
	rect(xleft=pop_ass$pop_start[i],ybottom=0,xright= pop_ass$pop_end[i],ytop=1,col="transparent",border="black",lwd=0.25)
	par(xpd=NA)
	if(i%%2==1){
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5)
		}
	}else{
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5)
		}
	}
}

par(xpd=NA)

mtext(text="K = 5",side=2,cex=1,line=-1.5)

par(xpd=T)

plot(1:10,1:10,xlim=c(1,1075),ylim=c(0,1),type="n",axes=F,xlab="",ylab="")

for(i in 1:nrow(k6)){
		rect(i,0,i+1, k6[i,1],col="pink",border=NA)
		rect(i,k6[i,1],i+1, (k6[i,1]+k6[i,2]),col="burlywood4",border=NA)
		rect(i,(k6[i,1]+k6[i,2]),i+1, (k6[i,1]+k6[i,2]+k6[i,3]),col="yellow3",border=NA)
		rect(i,(k6[i,1]+k6[i,2]+k6[i,3]),i+1, (k6[i,1]+k6[i,2]+k6[i,3]+k6[i,4]),col="lightgreen",border=NA)
		rect(i,(k6[i,1]+k6[i,2]+k6[i,3]+k6[i,4]),i+1, (k6[i,1]+k6[i,2]+k6[i,3]+k6[i,4]+k6[i,5]),col="skyblue",border=NA)
		rect(i,(k6[i,1]+k6[i,2]+k6[i,3]+k6[i,4]+k6[i,5]),i+1, (k6[i,1]+k6[i,2]+k6[i,3]+k6[i,4]+k6[i,5]+k6[i,6]),col="purple",border=NA)
}

for(i in 1:nrow(pop_ass)){
	rect(xleft=pop_ass$pop_start[i],ybottom=0,xright= pop_ass$pop_end[i],ytop=1,col="transparent",border="black",lwd=0.25)
	par(xpd=NA)
	if(i%%2==1){
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5)
		}
	}else{
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5)
		}
	}
}

par(xpd=NA)

mtext(text="K = 6",side=2,cex=1,line=-1.5)

par(xpd=T)

plot(1:10,1:10,xlim=c(1,1075),ylim=c(0,1),type="n",axes=F,xlab="",ylab="")

for(i in 1:nrow(k7)){
		rect(i,0,i+1, k7[i,1],col="pink",border=NA)
		rect(i,k7[i,1],i+1, (k7[i,1]+k7[i,2]),col="burlywood4",border=NA)
		rect(i,(k7[i,1]+k7[i,2]),i+1, (k7[i,1]+k7[i,2]+k7[i,3]),col="lightgreen",border=NA)
		rect(i,(k7[i,1]+k7[i,2]+k7[i,3]),i+1, (k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]),col="floralwhite",border=NA)
		rect(i,(k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]),i+1, (k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]+k7[i,5]),col="yellow3",border=NA)
		rect(i,(k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]+k7[i,5]),i+1, (k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]+k7[i,5]+k7[i,6]),col="skyblue",border=NA)
		rect(i,(k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]+k7[i,5]+k7[i,6]),i+1, (k7[i,1]+k7[i,2]+k7[i,3]+k7[i,4]+k7[i,5]+k7[i,6]+k7[i,7]),col="purple",border=NA)
}

for(i in 1:nrow(pop_ass)){
	rect(xleft=pop_ass$pop_start[i],ybottom=0,xright= pop_ass$pop_end[i],ytop=1,col="transparent",border="black",lwd=0.25)
	par(xpd=NA)
	if(i%%2==1){
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.1,cex=0.5)
		}
	}else{
		if(i %in% 50:55){
			text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5,col="orange",font=2)
		}else{
		text(label=pop_ass$Pop..[i],x=pop_ass$pop_start[i]+((pop_ass$pop_end[i]-pop_ass$pop_start[i])/2),y=1+0.2,cex=0.5)
		}
	}
}

par(xpd=NA)

mtext(text="K = 7",side=2,cex=1,line=-1.5)

par(xpd=T)

dev.off()