### STJA Phenotypic Analyses ###
require(xlsx)
require(plotrix)
require(viridis)
require(nlme)
require(MASS)
require(MuMIn)
require(agricolae)
require(gplots)

### Citation information ###
sessionInfo()

citation("nlme")
citation("MASS")
citation("MuMIn")
citation()
stja_pheno<-read.xlsx2("../data/Cyanocitta_stelleri_measurements_FINAL_20190416_forR.xlsx",sheetName="Morph Data Set",stringsAsFactors=F,header=T)

stja_pheno<-stja_pheno[-1036,] #Remove empty row
rownames(stja_pheno)<-stja_pheno$CAT_NUM

stja_pheno[stja_pheno$POPULATION %in% 50:55,]$GROUP2<-"Contact"

### Set up factors ###
stja_pheno$SEX<-factor(stja_pheno$SEX,levels=c("female","male"))
stja_pheno$AGE<-factor(stja_pheno$AGE,levels=c("1st year","adult"))
stja_pheno$POPULATION<-factor(stja_pheno$POPULATION,levels=as.character(1:max(as.numeric(stja_pheno$POPULATION))))
stja_pheno<-stja_pheno[order(as.numeric(stja_pheno$POPULATION)),]

stja_pheno$GROUP2<-gsub("Pacific","Coastal",stja_pheno$GROUP2)

stja_pheno$GROUP2[stja_pheno$GROUP2 == "Rocky"]<-"Rocky Mountain"

stja_pheno$GROUP2<-factor(stja_pheno$GROUP2,levels=c("Coastal","Interior","Contact","Rocky Mountain"))

### Data transformations ###
hist(as.numeric(stja_pheno$MASS)) ## This looks normally distributed, not sure we need to transform, but will look at residuals from LGMs

stja_pheno$EYE.LINE.A<-as.numeric(stja_pheno$EYE.LINE.L) * as.numeric(stja_pheno$EYE.LINE.W) #Get area of eye line
head(stja_pheno)
stja_pheno$TARSUSTOE.L<-as.numeric(stja_pheno$TARSUS.L) + as.numeric(stja_pheno$TOE.L) #Combine toe and tarsus lengths

### PCA ###
stja_pca_char<-data.frame(apply(stja_pheno[c(15,16,19,20,21,22,25,27)],2,as.numeric)) ##Omitting Eye Line Area since it is sort of a binary character
colnames(stja_pca_char)
rownames(stja_pca_char)<-stja_pheno$CAT_NUM

stja_pca<-princomp(na.omit(stja_pca_char))
stja_pca$scores
stja_pca$loadings
#write.xlsx(file="../output/STJA_PCA_loadings_v2.xlsx",stja_pca$loadings[,1:2])

stja_pca$sdev[1]/sum(stja_pca$sdev)
stja_pca$sdev[2]/sum(stja_pca$sdev)

rownames(stja_pca$scores)

STJA_PCA_contact<-as.data.frame(stja_pca$scores)[rownames(stja_pheno)[stja_pheno$POPULATION %in% c(41,43,49,50,51,52,53,54,55,60,61)],1:2]
rownames(STJA_PCA_contact)<-rownames(stja_pheno)[stja_pheno$POPULATION %in% c(41,43,49,50,51,52,53,54,55,60,61)]

STJA_PCA_contact$POPULATION<-stja_pheno[rownames(STJA_PCA_contact),]$POPULATION

#write.xlsx(STJA_PCA_contact,file="/Users/NickMason/Desktop/Manuscripts/StellersJays/Tables/STJA_PCA_scores_v4.xlsx")
nrow(STJA_PCA_contact)

### Box plots of each character ###
stja_pheno<-cbind(stja_pheno,PC1=data.frame(stja_pca$scores)[rownames(stja_pheno),1],PC2=data.frame(stja_pca$scores)[rownames(stja_pheno),2])
head(stja_pheno)
colnames(stja_pheno)[chars2explore[i]]
chars2explore<-c(28,29,15,16,19,20,21,22,25,26,27)

for(i in 1:length(chars2explore)){
	
stja_pheno[,chars2explore[i]] <-as.numeric(stja_pheno[,chars2explore[i]])

pdf(file=paste0("../output/",colnames(stja_pheno)[chars2explore[i]],"_boxplots_v6.pdf"),width=3.25,height=4.2)	
#quartz(width=3.25,height=4.2)

layout(matrix(c(1,2,3,3,4,4),byrow=T,ncol=2))
par(xpd=T)
par(lwd=0.5)
par(mar=c(1,2,0.5,0.5))
par(oma=c(1.5,0,0,0))

### Plot A ###
# Tukey's #
omitvec<-!is.na(stja_pheno[,chars2explore[i]])

glm_sex<-glm(stja_pheno[,chars2explore[i]]~ stja_pheno$SEX)
aov_sex<-aov(glm_sex)
hsdtest_sex<-HSD.test(aov_sex,trt="stja_pheno$SEX",group=T,console=T)

bp<-boxplot(as.numeric(stja_pheno[,chars2explore[i]])~ stja_pheno$SEX,col=c("#F0F0F060","#00000060"),axes=F,main="",ylim=c(range(stja_pheno[omitvec,chars2explore[i]])[1],diff(range(stja_pheno[omitvec,chars2explore[i]]))*0.1+range(stja_pheno[omitvec,chars2explore[i]])[2]))
axis(1,labels=c("female","male"),at=c(1,2),mgp=c(0,0.25,0),tck=-0.025,lwd=0.5)
axis(2,tck=-0.025,mgp=c(0,0.25,0),lwd=0.5)
mtext(text=colnames(stja_pheno)[chars2explore[i]],side=2,cex=0.5,line=1.25)
box()
text(x=par("usr")[1]+diff(c(par("usr")[1],par("usr")[2]))*0.075,y=par("usr")[4]-diff(c(par("usr")[3],par("usr")[4]))*0.075,label="A",font=2,cex=1)
text(label=toupper(hsdtest_sex $groups[levels(stja_pheno$SEX),]$groups),y= diff(range(stja_pheno[omitvec,chars2explore[i]]))*0.075 + range(stja_pheno[omitvec,chars2explore[i]])[2],x=1:length(hsdtest_sex $groups$groups),cex=0.8)

### Plot B ###
# Tukey's #
glm_age<-glm(stja_pheno[,chars2explore[i]]~ stja_pheno$AGE)
aov_age<-aov(glm_age)
hsdtest_age<-HSD.test(aov_age,trt="stja_pheno$AGE",group=T,console=T)

boxplot(as.numeric(stja_pheno[,chars2explore[i]])~ stja_pheno$AGE,col=c("#F0F0F060","#00000060"),axes=F,main="", ylim=c(range(stja_pheno[omitvec,chars2explore[i]])[1],diff(range(stja_pheno[omitvec,chars2explore[i]]))*0.1+range(stja_pheno[omitvec,chars2explore[i]])[2]))
axis(1,labels=c("first-year","adult"),at=c(1,2),mgp=c(0,0.25,0),tck=-0.025,lwd=0.5)
axis(2,tck=-0.025,mgp=c(0,0.25,0),lwd=0.5)
mtext(text=colnames(stja_pheno)[chars2explore[i]],side=2,cex=0.5,line=1.25)
box()
text(x=par("usr")[1]+diff(c(par("usr")[1],par("usr")[2]))*0.075,y=par("usr")[4]-diff(c(par("usr")[3],par("usr")[4]))*0.075,label="B",font=2,cex=1)
text(label=toupper(hsdtest_age $groups[levels(stja_pheno$AGE),]$groups),y= diff(range(stja_pheno[omitvec,chars2explore[i]]))*0.075 + range(stja_pheno[omitvec,chars2explore[i]])[2],x=1:length(hsdtest_age $groups$groups),cex=0.8)

### Plot C ###
glm_group2<-glm(stja_pheno[,chars2explore[i]]~ stja_pheno$GROUP2)
aov_group2<-aov(glm_group2)
hsdtest_group2<-HSD.test(aov_group2,trt="stja_pheno$GROUP2",group=T,console=T)

boxplot(as.numeric(stja_pheno[,chars2explore[i]])~stja_pheno$GROUP2,col=c("#FFFF0060","skyblue","orange","purple"),axes=F,ylim=c(range(stja_pheno[omitvec,chars2explore[i]])[1],diff(range(stja_pheno[omitvec,chars2explore[i]]))*0.1+range(stja_pheno[omitvec,chars2explore[i]])[2]))
axis(1,labels=c("Coastal","Interior","Contact","Rocky Mountain"),at=c(1:4),mgp=c(0,0.25,0),tck=-0.025,lwd=0.5,cex.axis=0.8)
axis(2,tck=-0.025,mgp=c(0,0.25,0),lwd=0.5)
mtext(text=colnames(stja_pheno)[chars2explore[i]],side=2,cex=0.5,line=1.25)
box()
text(x=par("usr")[1]+diff(c(par("usr")[1],par("usr")[2]))*0.025,y=par("usr")[4]-diff(c(par("usr")[3],par("usr")[4]))*0.075,label="C",font=2,cex=1)
text(label=toupper(hsdtest_group2 $groups[levels(stja_pheno$GROUP2),]$groups),y= diff(range(stja_pheno[omitvec,chars2explore[i]]))*0.075 + range(stja_pheno[omitvec,chars2explore[i]])[2],x=1:length(hsdtest_group2 $groups$groups),cex=0.8)

### Plot D ###
boxplot(as.numeric(stja_pheno[,chars2explore[i]])~stja_pheno$POPULATION,col=c("#FFFF0060","skyblue","orange","purple")[as.numeric(stja_pheno$GROUP2)[!duplicated(stja_pheno$POPULATION)]],axes=F)
axis(1,at=1:68,label=as.character(1:68),tck=-0.025,mgp=c(0,0.25,0),lwd=0.5)
axis(2,tck=-0.025,mgp=c(0,0.25,0),lwd=0.5)
mtext(text=colnames(stja_pheno)[chars2explore[i]],side=2,cex=0.5,line=1.25)
box()
text(x=par("usr")[1]+diff(c(par("usr")[1],par("usr")[2]))*0.025,y=par("usr")[4]-diff(c(par("usr")[3],par("usr")[4]))*0.075,label="D",font=2,cex=1)

par(xpd=NA)
text(label="Population",x=mean(par("usr")[c(1,2)]),y=par("usr")[3]-diff(par("usr")[c(3,4)])*0.225)

dev.off()
}

### Run linear mixed models ###
lmm_list<-list()
for(i in 1:length(chars2explore)){
	lmm_list[[i]]<-list()
	foo.df<-na.omit(stja_pheno[c(chars2explore[i],12,13,9,10,11)])
	foo.df[,1]<-as.numeric(foo.df[,1])
	foo.df<-na.omit(foo.df)
	foo.df<-foo.df[!foo.df$GROUP2=="Contact",]
	foo.lme<-lme(as.formula(paste(colnames(foo.df)[1],"~SEX+AGE+GROUP2",sep="")),random= ~ 1|POPULATION,data= foo.df,method="REML")
	lmm_list[[i]][[1]]<-foo.lme
	lmm_list[[i]][[2]]<-r.squaredGLMM(foo.lme)
}	
names(lmm_list)<-colnames(stja_pheno)[chars2explore]

### Write out LMM output ###
### Now with R2c and R2m ###
for(i in 1:length(lmm_list)){
	beta<-paste(round(summary(lmm_list[[i]][[1]])$tTable,2)[,1],round(summary(lmm_list[[i]][[1]])$tTable,2)[,2],sep=" ± ")
	t_val<-round(summary(lmm_list[[i]][[1]])$tTable,2)[,4]
	p_val<-round(summary(lmm_list[[i]][[1]])$tTable,2)[,5]
	rm<-c(round(lmm_list[[i]][[2]][1],2),rep("",4))
	rc<-c(round(lmm_list[[i]][[2]][2],2),rep("",4))
	
	lmm_df<-data.frame(beta=beta,T=t_val,P=p_val,rm=rm,rc=rc)
	
	write.xlsx(lmm_df, file=paste("../output/Cyanocitta_LMM_",names(lmm_list)[i],"_v2.xlsx",sep=""))
}

### DFA ###
require("MASS")
stja_dfa<-na.omit(stja_pca_char)
stja_dfa<-stja_dfa[stja_pheno[rownames(stja_dfa),]$GROUP2!="Contact",]
stja_dfa$GROUP2<-factor(stja_pheno[rownames(stja_dfa),]$GROUP2)

stja_dfa_out_cvF<-lda(GROUP2~.,data=stja_dfa,CV=F)

sink("../output/STJA_morpho_ldaoutput.txt")
stja_dfa_out_cvF
sink()

stja_dfa_out<-lda(GROUP2~.,data=stja_dfa,CV=T)
CV_tab <- table(na.omit(stja_dfa$GROUP2), stja_dfa_out$class)
CV_tab<-as.data.frame(matrix(CV_tab,nrow=3))
rownames(CV_tab)<-paste("actual",levels(factor(stja_dfa$GROUP2)),sep="_")
colnames(CV_tab)<-paste("predicted", levels(factor(stja_dfa$GROUP2)),sep="_")
CV_tab
summary(stja_dfa_out)

attr(stja_dfa_out)

cat(paste(paste(names(table(stja_dfa$GROUP2)),table(stja_dfa$GROUP2),sep=" "),collapse="\n"))
sum(table(stja_dfa$GROUP2))
sum(diag(as.matrix(CV_tab))) / sum(CV_tab) #PERCENTAGE OF ACCURACTE DFA DESIGNATIONS

write.xlsx(file="../output/STJA_DFA_output_v2.xlsx",CV_tab)

### Plot DFAs ###
stjadfacol=c("skyblue","yellow3","purple")
stjadfacol<-paste0(col2hex(stjadfacol),"80")
stja_dfa_out_nocv<-lda(GROUP2~.,data=stja_dfa,CV=F)
stja_dfa_vals<-predict(stja_dfa_out_nocv)

str(stja_dfa_vals)


png(file="../output/DFAplots_v3.png",width=6,height=6,res=300,units="in")
#quartz(width=6,height=6)
plot(stja_dfa_vals$x[,1],stja_dfa_vals$x[,2],pch=21,bg=stjadfacol[as.numeric(factor(stja_pheno[rownames(stja_dfa_vals$x),]$GROUP2))],col= stjadfacol[as.numeric(stja_dfa_out$class)],lwd=2,xlab="DF1",ylab="DF2")

dfa_leg<-c(paste0("Interior (",round(CV_tab[1,1]/sum(CV_tab[1,])*100,2),"%)"),paste0("Coastal (",round(CV_tab[2,2]/sum(CV_tab[2,])*100,2),"%)"),paste0("Rocky (",round(CV_tab[3,3]/sum(CV_tab[3,])*100,2),"%)"))

legend("bottomright",legend=dfa_leg,pch=21,pt.bg=stjadfacol,pt.cex=1.25,col="transparent")

dev.off()

### Write out DFA scores for Pascal to put together ###
dfa_morpho<-stja_dfa_vals
dfa_morpho<-data.frame(actualssp=as.character(stja_dfa$GROUP2),dfa_morpho)
head(dfa_morpho)
dfa_morpho<-dfa_morpho[-c(3,4,5)]
write.xlsx(dfa_morpho,file="../output/DFAMorphoForPascal_v1.xlsx")

### Geographic figure of discrete characters ###
### Read in population coordinates ###
pop_coords<-read.xlsx2("../utility/Cyanocitta_stelleri_population_mapping.xlsx",sheetName="Sheet1",stringsAsFactors=F)
pop_coords<-pop_coords[-c((nrow(pop_coords)-1),nrow(pop_coords)),] #remove extraneous rows
rownames(pop_coords)<-pop_coords$Row.Labels
pop_coords$Row.Labels<-NULL
nrow(pop_coords)

### Set up population colors ###
pt_cols<-c("yellow3","pink","skyblue","orange","purple")
pt_cols<-paste(col2hex(pt_cols),"90",sep="")

### Read in population numbers ###
pop_numbs<-read.xlsx2("../data/2_Cyanocitta_microsats_19Apr2022_FINAL.xlsx",sheetName="Pop list with ind #",stringsAsFactors=F)
pop_numbs

rownames(pop_numbs)<-pop_numbs$Pop.name
pop_numbs$Pop.name<-NULL

### Combine data frames ###
nrow(pop_numbs)
nrow(pop_coords)

pop_data<-cbind(pop_coords[rownames(pop_numbs),],pop_numbs)

### Get proportions of eye line presence and supercilium color for pie charts ###
head(stja_pheno)

stja_pheno_pop<-split(stja_pheno,factor(stja_pheno$POPULATION,levels=as.character(1:68)))
eyeline_prop<-t(sapply(sapply(stja_pheno_pop,function(x) x$EYE.LINE.A==0),function(x) c(length(which(x)),length(which(!x)))))

eye_streaks<-sapply(stja_pheno_pop,function(x) x$STREAKS[x$STREAKS!=""])
eyewhite_prop<-t(sapply(eye_streaks,function(x) c(white=length(which(x=="white")),blue=length(which(x=="blue")))))

### Read in administrative boundaries ###
install.packages("mapplots")
require("sp")
require("rgdal")
require("maps")
require("mapplots")
require("mapdata")
require("raster")
require("rgeos")
require("gplots")

### Create SpatialPoints object ###
coords_sp<-SpatialPointsDataFrame(coords=cbind(as.numeric(pop_data$Dec.Lon),as.numeric(pop_data$Dec.Lat)),data=data.frame(pop_data[c(1,5,6)],eyeline_prop=eyeline_prop,eyewhite_prop=eyewhite_prop))

adm0<-readOGR("../utility/na_adm0/na_adm0_crop.shp")
adm0<-gSimplify(adm0,tol=0.01)

adm1<-readOGR("../utility/na_adm1/na_adm1_crop.shp")
adm1 <-gSimplify(adm1,tol=0.01)

### Read in elevational data ###
na_alt<-raster("../utility/na_alt/na_alt.grd")

### Read in updated shape file ###
steller_range<-readOGR("../utility/Cyanocitta_stelleri_shp/Cyanocitta_stelleri.shp")

woh_ratio<-nrow(na_alt)/ncol(na_alt)

png("../output/STJA_EyelineColorPresenceAbsence_v1.png",res=500,units="in",width=6.5,height=1.1*(3.25/woh_ratio))

#quartz(height=1.1*(3.25/woh_ratio),width= 6.5)

par(mfrow=c(1,2))
par(oma=c(0,0,0,0))
par(mar=c(0,0,0,0))

### SUPERCILIUM COLOR ###
image(na_alt, col=colorRampPalette(colors=c("white","black"))(1000),axes=F)
plot(adm0,add=T,border="gray50")
plot(adm1,add=T,border="gray50")
corner.label("A")

### RangeMap ###
plot(steller_range,col="#dd99ff60",border="transparent",add=T)

### Add pie plots ###
draw.pie(coords_sp@coords[,1],coords_sp@coords[,2],radius=1,eyewhite_prop,col=paste(col2hex(c("white","skyblue")),"60",sep=""))
box()

### EYESTRIPE PRESENCE ###
image(na_alt, col=colorRampPalette(colors=c("white","black"))(1000),axes=F)
plot(adm0,add=T,border="gray50")
plot(adm1,add=T,border="gray50")
corner.label("B")

### RangeMap ###
plot(steller_range,col="#dd99ff60",border="transparent",add=T)

### Add pie plots ###
draw.pie(coords_sp@coords[,1],coords_sp@coords[,2],radius=1, eyeline_prop,col=paste(col2hex(c("black","white")),"60",sep=""))
box()

dev.off()

### Individual plots for Carla ###
png("../output/STJA_EyelineColor_v1.png",res=500,units="in",width=3.25,height=1.1*(3.25/woh_ratio)/2)
#quartz(height=1.1*(3.25/woh_ratio),width= 6.5)

par(oma=c(0,0,0,0))
par(mar=c(0,0,0,0))

### SUPERCILIUM COLOR ###
image(na_alt, col=colorRampPalette(colors=c("white","black"))(1000),axes=F)
plot(adm0,add=T,border="gray50")
plot(adm1,add=T,border="gray50")
#corner.label("A")

### RangeMap ###
plot(steller_range,col="#dd99ff60",border="transparent",add=T)

### Add pie plots ###
draw.pie(coords_sp@coords[,1],coords_sp@coords[,2],radius=1,eyewhite_prop,col=paste(col2hex(c("white","skyblue")),"60",sep=""))
box()

dev.off()

png("../output/STJA_SuperCiliumPresence_v1.png",res=500,units="in",width=3.25,height=1.1*(3.25/woh_ratio)/2)
#quartz(height=1.1*(3.25/woh_ratio),width= 6.5)

par(oma=c(0,0,0,0))
par(mar=c(0,0,0,0))

### EYESTRIPE PRESENCE ###
image(na_alt, col=colorRampPalette(colors=c("white","black"))(1000),axes=F)
plot(adm0,add=T,border="gray50")
plot(adm1,add=T,border="gray50")
#corner.label("B")

### RangeMap ###
plot(steller_range,col="#dd99ff60",border="transparent",add=T)

### Add pie plots ###
draw.pie(coords_sp@coords[,1],coords_sp@coords[,2],radius=1, eyeline_prop,col=paste(col2hex(c("black","white")),"60",sep=""))
box()

dev.off()