# ### Install dependencies ###
#install.packages(c("Rcpp","RcppEigen","raster","rgeos","sp"))
require(rgeos)
require(rgdal)
require("rworldmap")
require(ggplot2)

map <- rworldmap::getMap(resolution = "high")
map <- broom::tidy(map)

# Start here after installation #
#install.packages("devtools")
library("devtools")
#install_github("dipetkov/reemsplots2")
library(reemsplots2)

### Analyze EEMS output for Stellar's Jay ###
?eems.plots #See help file

### Get background shape file ###
na_adm1<-readOGR("../utility/na_adm1/na_adm1_crop.shp")
na_trans<-spTransform(na_adm1,"+proj=merc +datum=WGS84")

na_simp<-gSimplify(na_trans,1)

### 500 demes **PREFERRED**
### Acquire the path for each chain / iteration of mcmc and combine into a list ###
chain1<-"../data/Cst-nDemes500-chain1"
chain2<-"../data/Cst-nDemes500-chain2"
chain3<-"../data/Cst-nDemes500-chain3"
eems_chains<-list(chain1,chain2,chain3)

### Change to directory where you want it to go. higher order function writes out images itself to wd
#setwd("~/Google Drive/StellersJay/EEMS")

map <- rworldmap::getMap(resolution = "high")
map <- broom::tidy(map)
us_states<-map_data("state")

### Run eems.plots
eems_plots<-make_eems_plots(mcmcpath=eems_chains,add_grid=F,add_demes=T)

quartz(width=6.5,height=3.25)
par(mfrow=c(1,2))

png(file="../output/mrates.png")
eems_plots$mrates01 + 
geom_polygon(data= us_states, aes(x=long, y=lat, group=group),color="black", fill=NA) +
xlab("Longitude") + ylab("Latitude") +
scale_x_continuous(limits = c(-130,-80)) +
scale_y_continuous(limits =c(20,52)) +
theme(
axis.text.y = element_text(colour = "black",size=10),
axis.text.x = element_text(colour = "black",size = 10),
panel.border = element_rect(colour = "black", fill=NA, size=0.5),
panel.background = element_blank()
) +
coord_quickmap(ylim=c(30,52),xlim=c(-125,-100))
dev.off()

png(file="../output/qrates.png")
eems_plots$qrates01 + 
geom_polygon(data= us_states, aes(x=long, y=lat, group=group),color="black", fill=NA) +
xlab("Longitude") + ylab("Latitude") +
scale_x_continuous(limits = c(-130,-80)) +
scale_y_continuous(limits =c(20,52)) +
theme(
axis.text.y = element_text(colour = "black",size=10),
axis.text.x = element_text(colour = "black",size = 10),
panel.border = element_rect(colour = "black", fill=NA, size=0.5),
panel.background = element_blank()
) +
coord_quickmap(ylim=c(30,52),xlim=c(-125,-100))
dev.off()