
# Plot multi-panel DFA figure for morphology, microsat and climate+landcover

clim <- read.csv('data/SDM/DFAdat/climDFA.csv')
morpho <- read.csv('data/SDM/DFAdat/DFAMorphoForPascal_v1.csv')
microsat <- read.csv('data/SDM/DFAdat/Cst_msat_DAPC_2021_3groups.csv')

morpho <- morpho[, c('actualssp', 'class', 'x.LD1', 'x.LD2')]
colnames(morpho) <- c('morphogroup', 'predicted', 'LD1', 'LD2')

microsat <- microsat[, c('morphogroup', 'predicted', 'LD1.80.2.', 'LD2.19.8.')]
colnames(microsat) <- c('morphogroup', 'predicted', 'LD1', 'LD2')

# rename microsat groups
microsat[which(microsat$morphogroup == 1), 'morphogroup'] <- 'Coastal'
microsat[which(microsat$morphogroup == 2), 'morphogroup'] <- 'Interior'
microsat[which(microsat$morphogroup == 3), 'morphogroup'] <- 'Rocky'
microsat[which(microsat$predicted == 1), 'predicted'] <- 'Coastal'
microsat[which(microsat$predicted == 2), 'predicted'] <- 'Interior'
microsat[which(microsat$predicted == 3), 'predicted'] <- 'Rocky'

head(clim)
head(morpho)
head(microsat)

table(clim$morphogroup)
table(morpho$morphogroup)
table(microsat$morphogroup)


# how many correct vs incorrect classifications?
dat <- morpho
dat <- microsat
dat <- clim
mat <- matrix(0, nrow = 3, ncol = 3)
rownames(mat) <- colnames(mat) <- c('Coastal', 'Interior', 'Rocky')
for (i in 1:nrow(dat)) {
	mat[dat[i, 1], dat[i, 2]] <- mat[dat[i, 1], dat[i, 2]] + 1
}

matPercent <- matrix(NA, nrow = 3, ncol = 3)
rownames(matPercent) <- colnames(matPercent) <- rownames(mat)
for (i in 1:nrow(mat)) {
	matPercent[i, ] <- mat[i, ] / sum(mat[i,])
}

mat
round(matPercent * 100, 2)



loadings <- list(
				morpho = c(58.12, 41.88),
				microsat = c(80.2, 19.8),
				clim = c(87.93, 12.07))
				
sapply(loadings, sum)

# get quantile contour
quantileContour <- function(xy, q) {
	kd <- ks::kde(xy, compute.cont=TRUE)
	q <- paste0((1 - q)*100, '%')
	contour_q <- with(kd, contourLines(x=eval.points[[1]], y=eval.points[[2]], z=estimate, levels=cont[q])[[1]])
	data.frame(contour_q)[, 2:3]
}


cols <- c(fullSp = 'darkslateblue', coastal = 'yellow3', interior = 'skyblue3', coastalInterior = '#31a354', rockies = 'purple', contact = 'orange')
symbs <- c(fullSp = 25, coastal = 21, interior = 22, coastalInterior = 23, rockies = 24, contact = 25)
transp <- 0.5

borderCol <- adjustcolor('black', alpha.f = 0.25)


setEPS()
cairo_ps('output/Figure4_DFA.eps', width = 12, height = 4)
# pdf('output/Figure4_DFA.pdf', width = 12, height = 4)

par(mfrow = c(1,3), mar = c(4,4,3,1))

# morphology

groupCols <- rep('', nrow(morpho))
groupCols[which(morpho$morphogroup == 'Coastal')] <- adjustcolor(cols['coastal'], alpha.f = transp)
groupCols[which(morpho$morphogroup == 'Interior')] <- adjustcolor(cols['interior'], alpha.f = transp)
groupCols[which(morpho$morphogroup == 'Rocky')] <- adjustcolor(cols['rockies'], alpha.f = transp)

groupSymbs <- numeric(length = nrow(morpho))
groupSymbs[which(morpho$morphogroup == 'Coastal')] <- symbs['coastal']
groupSymbs[which(morpho$morphogroup == 'Interior')] <- symbs['interior']
groupSymbs[which(morpho$morphogroup == 'Rocky')] <- symbs['rockies']

table(groupCols)
table(groupSymbs)
			
plot(morpho[, c('LD1', 'LD2')], bg = groupCols, pch = groupSymbs, col = borderCol, lwd = 0.5, cex = 0.75, xlab = '', ylab = '')

lines(quantileContour(morpho[which(morpho$morphogroup == 'Coastal'), c('LD1', 'LD2')], 0.95), col = cols['coastal'], lwd = 1.5)
lines(quantileContour(morpho[which(morpho$morphogroup == 'Interior'), c('LD1', 'LD2')], 0.95), col = cols['interior'], lwd = 1.5)
lines(quantileContour(morpho[which(morpho$morphogroup == 'Rocky'), c('LD1', 'LD2')], 0.95), col = cols['rockies'], lwd = 1.5)

mtext(paste0('DF 1 (', loadings$morpho[1], '%)'), side = 1, line = 2.5)
mtext(paste0('DF 2 (', loadings$morpho[2], '%)'), side = 2, line = 2.5)

mtext('morphology', side = 3, line = 1, cex = 1, font = 2)
mtext('A', side = 3, line = 1, cex = 1, font = 2, at = par('usr')[1])

# Microsat

groupCols <- rep('', nrow(microsat))
groupCols[which(microsat$morphogroup == 'Coastal')] <- adjustcolor(cols['coastal'], alpha.f = transp)
groupCols[which(microsat$morphogroup == 'Interior')] <- adjustcolor(cols['interior'], alpha.f = transp)
groupCols[which(microsat$morphogroup == 'Rocky')] <- adjustcolor(cols['rockies'], alpha.f = transp)

groupSymbs <- numeric(length = nrow(microsat))
groupSymbs[which(microsat$morphogroup == 'Coastal')] <- symbs['coastal']
groupSymbs[which(microsat$morphogroup == 'Interior')] <- symbs['interior']
groupSymbs[which(microsat$morphogroup == 'Rocky')] <- symbs['rockies']

table(groupCols)
table(groupSymbs)
			

plot(microsat[, c('LD1', 'LD2')], bg = groupCols, pch = groupSymbs, col = borderCol, lwd = 0.5, cex = 0.75, xlab = '', ylab = '')

lines(quantileContour(microsat[which(microsat$morphogroup == 'Coastal'), c('LD1', 'LD2')], 0.95), col = cols['coastal'], lwd = 1.5)
lines(quantileContour(microsat[which(microsat$morphogroup == 'Interior'), c('LD1', 'LD2')], 0.95), col = cols['interior'], lwd = 1.5)
lines(quantileContour(microsat[which(microsat$morphogroup == 'Rocky'), c('LD1', 'LD2')], 0.95), col = cols['rockies'], lwd = 1.5)

legend('bottomright', legend = c('Coastal', 'Interior', 'Rocky Mountain'), pt.bg = adjustcolor(cols[c('coastal', 'interior', 'rockies')], alpha.f = transp), pch = symbs[c('coastal', 'interior', 'rockies')], pt.lwd = 0.5, bty = 'n')


mtext(paste0('DF 1 (', loadings$microsat[1], '%)'), side = 1, line = 2.5)
mtext(paste0('DF 2 (', loadings$microsat[2], '%)'), side = 2, line = 2.5)

mtext('microsatellites', side = 3, line = 1, cex = 1, font = 2)
mtext('B', side = 3, line = 1, cex = 1, font = 2, at = par('usr')[1])

# climate + landcover

groupCols <- rep('', nrow(clim))
groupCols[which(clim$morphogroup == 'Coastal')] <- adjustcolor(cols['coastal'], alpha.f = transp)
groupCols[which(clim$morphogroup == 'Interior')] <- adjustcolor(cols['interior'], alpha.f = transp)
groupCols[which(clim$morphogroup == 'Rocky')] <- adjustcolor(cols['rockies'], alpha.f = transp)

groupSymbs <- numeric(length = nrow(clim))
groupSymbs[which(clim$morphogroup == 'Coastal')] <- symbs['coastal']
groupSymbs[which(clim$morphogroup == 'Interior')] <- symbs['interior']
groupSymbs[which(clim$morphogroup == 'Rocky')] <- symbs['rockies']

table(groupCols)
table(groupSymbs)
			

plot(clim[, c('LD1', 'LD2')], bg = groupCols, pch = groupSymbs, col = borderCol, lwd = 0.5, cex = 0.75, xlab = '', ylab = '')

lines(quantileContour(clim[which(clim$morphogroup == 'Coastal'), c('LD1', 'LD2')], 0.95), col = cols['coastal'], lwd = 1.5)
lines(quantileContour(clim[which(clim$morphogroup == 'Interior'), c('LD1', 'LD2')], 0.95), col = cols['interior'], lwd = 1.5)
lines(quantileContour(clim[which(clim$morphogroup == 'Rocky'), c('LD1', 'LD2')], 0.95), col = cols['rockies'], lwd = 1.5)

mtext(paste0('DF 1 (', loadings$clim[1], '%)'), side = 1, line = 2.5)
mtext(paste0('DF 2 (', loadings$clim[2], '%)'), side = 2, line = 2.5)

mtext('climate & landcover', side = 3, line = 1, cex = 1, font = 2)
mtext('C', side = 3, line = 1, cex = 1, font = 2, at = par('usr')[1])

dev.off()



