# generate SDM figure 9

	library(rmapshaper)
	library(rgdal)
	library(raster)
	library(tmap)
	library(viridis)
	library(rnaturalearth)
		
	# load occurrences
	allOcc <- readRDS('data/SDM/occ5.rds')
	allOcc <- allOcc[, c('decimalLongitude','decimalLatitude')]
	colnames(allOcc) <- c('Longitude','Latitude')
		
	# read in species range
	jayRange <- readOGR('utility/Cyanocitta_stelleri_shp/Cyanocitta_stelleri.shp')
	jayRange <- rgeos::gSimplify(jayRange, tol = 0.1, topologyPreserve = TRUE)
	
	# country/state boundaries
	countries <- ne_download(scale = 110, type = 'admin_0_countries')
	states <- ne_download(scale = 110, type = 'admin_1_states_provinces')
	
	# read in hillshade
	# https://www.naturalearthdata.com/downloads/50m-raster-data/50m-prisma-shaded-relief/
	hill <-raster('data/SDM/PRISMA_SR_50M/PRIMSA_SR_50M.tif')
	
	
	blueRamp <- colorRampPalette(c('gray97', 'blue'))
	colramp <- blueRamp(100)
	
	fullSpRamp <- colorRampPalette(c('gray97', 'darkslateblue'))
	coastalRamp <- colorRampPalette(c('gray97', 'yellow3'))
	interiorRamp <- colorRampPalette(c('gray97', 'skyblue3'))
	coastalInteriorRamp <- colorRampPalette(c('gray97', '#31a354'))
	rockyRamp <- colorRampPalette(c('gray97', 'purple'))

	
	# Read in all rasters

	# coastal
	coastal <- stack(c(	'data/SDM/finalSDMmodels/pacific_current_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/pacific_LGM_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/pacific_FUTURE2070_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/pacific_current_aicVarSelect_withLC.tif'))
	# interior
	interior <- stack(c('data/SDM/finalSDMmodels/interior_current_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/interior_LGM_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/interior_FUTURE2070_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/interior_current_aicVarSelect_withLC.tif'))
	# coastal+interior
	coastalInterior <- stack(c('data/SDM/finalSDMmodels/pacificInterior_current_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/pacificInterior_LGM_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/pacificInterior_FUTURE2070_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/pacificInterior_current_aicVarSelect_withLC.tif'))
	# Rockies
	rockies <- stack(c(	'data/SDM/finalSDMmodels/rockies_current_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/rockies_LGM_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/rockies_FUTURE2070_aicVarSelect.tif', 
						'data/SDM/finalSDMmodels/rockies_current_aicVarSelect_withLC.tif'))


# prep hillshade and boundaries
hill <- crop(hill, coastal[[1]])
currentHS <- mask(hill, resample(coastal[[1]], hill))
lgmHS <- mask(hill, resample(coastal[[2]], hill))
futureHS <- mask(hill, resample(coastal[[3]], hill))

countries <- ms_clip(countries, bbox = as.vector(bbox(coastal[[1]])))
states <- ms_clip(states,bbox = as.vector(bbox(coastal[[1]])))
states <- ms_innerlines(states)


# plot with morphogroups combined
## Row of 3 maps: current w/ landcover, LGM and future

tssThresholds <- readRDS('data/SDM/tssThresholds.rds')

# tiff('output/Fig9_morphogroups_SDM_combined.tiff', width = 8, height = 2.5, units = 'in', family = 'Times', res = 800)
png('output/Fig9_morphogroups_SDM_combined.png', width = 8, height = 2.5, units = 'in', family = 'Times', res = 400)
	
	par(mfrow = c(1,3), mar = c(0,0,0,0))

# LGM
	plot.new()
	plot.window(xlim = c(bbox(lgmHS)[1], bbox(lgmHS)[3]), ylim = c(bbox(lgmHS)[2], bbox(lgmHS)[4]))
	plot(lgmHS, col = gray.colors(100), legend = FALSE, maxpixels = ncell(lgmHS), axes = FALSE, ylim = extent(lgmHS)[3:4], box = FALSE, add = TRUE)
	plot(lgmHS, col = gray(0.97), alpha = 0.65, add = TRUE, legend = FALSE)
	plot(countries, add = TRUE, lwd = 0.3, border = gray(0.99), col = adjustcolor('white', alpha.f = 0.3))
	plot(states, add = TRUE, lwd = 0.3, col = 'white')
	
	image(reclassify(coastal[[2]], rcl = c(0, tssThresholds[['coastal']][1], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = coastalRamp(100), zlim = c(0,1), legend = FALSE)
image(reclassify(rockies[[2]], rcl = c(0, tssThresholds[['rockies']][1], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = rockyRamp(100), zlim = c(0,1), legend = FALSE)
	image(reclassify(interior[[2]], rcl = c(0, tssThresholds[['interior']][1], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = interiorRamp(100), zlim = c(0,1), legend = FALSE)
	rect(bbox(coastal[[1]])[1], bbox(coastal[[1]])[2], bbox(coastal[[1]])[3], bbox(coastal[[1]])[4], lwd = 0.65)
	mtext('LGM climate', side = 3, line = -2.3, cex = 0.8, font = 2)
	legend(x = -155, y=20, legend = c('Coastal', 'Interior', 'Rocky Mountain'), fill = c('yellow3', 'skyblue3', 'purple'), border = NA, bty = 'n', cex=0.8)

# clim + landcover
	plot.new()
	plot.window(xlim = c(bbox(currentHS)[1], bbox(currentHS)[3]), ylim = c(bbox(currentHS)[2], bbox(currentHS)[4]))
	plot(currentHS, col = gray.colors(100), legend = FALSE, maxpixels = ncell(currentHS), axes = FALSE, ylim = extent(currentHS)[3:4], box = FALSE, add = TRUE)
	plot(currentHS, col = gray(0.97), alpha = 0.65, add = TRUE, legend = FALSE)
	plot(countries, add = TRUE, lwd = 0.3, border = gray(0.99), col = adjustcolor('white', alpha.f = 0.3))
	plot(states, add = TRUE, lwd = 0.3, col = 'white')
	
	image(reclassify(coastal[[4]], rcl = c(0, tssThresholds[['coastal']][2], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = coastalRamp(100), zlim = c(0,1), legend = FALSE)
	image(reclassify(rockies[[4]], rcl = c(0, tssThresholds[['rockies']][2], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = rockyRamp(100), zlim = c(0,1), legend = FALSE)
	image(reclassify(interior[[4]], rcl = c(0, tssThresholds[['interior']][2], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = interiorRamp(100), zlim = c(0,1), legend = FALSE)
	rect(bbox(coastal[[1]])[1], bbox(coastal[[1]])[2], bbox(coastal[[1]])[3], bbox(coastal[[1]])[4], lwd = 0.65)
	mtext('current climate + land cover', side = 3, line = -2.3, cex = 0.8, font = 2)
	
# FUTURE
	plot.new()
	plot.window(xlim = c(bbox(futureHS)[1], bbox(futureHS)[3]), ylim = c(bbox(futureHS)[2], bbox(futureHS)[4]))
	plot(futureHS, col = gray.colors(100), legend = FALSE, maxpixels = ncell(futureHS), axes = FALSE, ylim = extent(futureHS)[3:4], box = FALSE, add = TRUE)
	plot(futureHS, col = gray(0.97), alpha = 0.65, add = TRUE, legend = FALSE)
	plot(countries, add = TRUE, lwd = 0.3, border = gray(0.99), col = adjustcolor('white', alpha.f = 0.3))
	plot(states, add = TRUE, lwd = 0.3, col = 'white')
	
	image(reclassify(coastal[[3]], rcl = c(0, tssThresholds[['coastal']][1], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = coastalRamp(100), zlim = c(0,1), legend = FALSE)
	image(reclassify(rockies[[3]], rcl = c(0, tssThresholds[['rockies']][1], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = rockyRamp(100), zlim = c(0,1), legend = FALSE)
	image(reclassify(interior[[3]], rcl = c(0, tssThresholds[['interior']][1], NA)), add = TRUE, alpha = 0.65, maxpixels = ncell(coastal[[4]]), col = interiorRamp(100), zlim = c(0,1), legend = FALSE)
	rect(bbox(coastal[[1]])[1], bbox(coastal[[1]])[2], bbox(coastal[[1]])[3], bbox(coastal[[1]])[4], lwd = 0.65)
	mtext('2060-2080 climate', side = 3, line = -2.3, cex = 0.8, font = 2)


	dev.off()

