# Get MaxTSS threshold values for morphogroups

library(maptools)
library(rgeos)
library(rgdal)
library(maxnet)
library(raster)
library(enmSdm)


# Read in all rasters

# coastal
coastal <- c('pacific_current_aicVarSelect.tif', 'pacific_current_aicVarSelect_withLC.tif')

# interior
interior <- c('interior_current_aicVarSelect.tif', 'interior_current_aicVarSelect_withLC.tif')

# coastal+interior
coastalInterior <- c('pacificInterior_current_aicVarSelect.tif', 'pacificInterior_current_aicVarSelect_withLC.tif')

# Rockies
rockies <- c('rockies_current_aicVarSelect.tif', 'rockies_current_aicVarSelect_withLC.tif')



# ----------------------------------------------
TSSthresholds <- list(
						coastal = numeric(2),
						interior = numeric(2),
						coastalInterior = numeric(2),
						rockies = numeric(2))
# ----------------------------------------------
# ----------------------------------------------
## morphogroups

# load occurrences
allOcc <- readRDS('data/SDM/occ5.rds')
allOcc <- allOcc[, c('decimalLongitude','decimalLatitude')]
colnames(allOcc) <- c('Longitude','Latitude')


bg <- readRDS('data/SDM/PA.rds')[[1]]
bg <- coordinates(bg)
bg <- tail(bg, 100000)
rownames(bg) <- NULL

load('data/SDM/region_list.Rdata')

# Coastal
subOcc <- gIntersection(SpatialPoints(allOcc, proj4string=CRS(proj4string(region_list$rockies))), region_list$coastal)
subOcc <- coordinates(subOcc)
colnames(subOcc) <- c('Longitude','Latitude')
rownames(subOcc) <- NULL

PA <- rbind(subOcc, bg)
PA <- SpatialPoints(PA, proj4string=CRS('+proj=longlat +datum=WGS84'))
PAbin <- c(rep(1, nrow(subOcc)), rep(0, nrow(bg)))

px <- raster(paste0('data/SDM/finalSDMmodels/', coastal[1]))

TSSthresholds[['coastal']][1] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss

px <- raster(paste0('data/SDM/finalSDMmodels/', coastal[2]))

TSSthresholds[['coastal']][2] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss



# Interior
subOcc <- gIntersection(SpatialPoints(allOcc, proj4string=CRS(proj4string(region_list$rockies))), region_list$interior)
subOcc <- coordinates(subOcc)
colnames(subOcc) <- c('Longitude','Latitude')
rownames(subOcc) <- NULL

PA <- rbind(subOcc, bg)
PA <- SpatialPoints(PA, proj4string=CRS('+proj=longlat +datum=WGS84'))
PAbin <- c(rep(1, nrow(subOcc)), rep(0, nrow(bg)))

px <- raster(paste0('data/SDM/finalSDMmodels/', interior[1]))

TSSthresholds[['interior']][1] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss

px <- raster(paste0('data/SDM/finalSDMmodels/', interior[2]))

TSSthresholds[['interior']][2] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss



# Coastal+Interior
subOcc <- gIntersection(SpatialPoints(allOcc, proj4string=CRS(proj4string(region_list$rockies))), gUnion(region_list$interior, region_list$coastal))
subOcc <- coordinates(subOcc)
colnames(subOcc) <- c('Longitude','Latitude')
rownames(subOcc) <- NULL

PA <- rbind(subOcc, bg)
PA <- SpatialPoints(PA, proj4string=CRS('+proj=longlat +datum=WGS84'))
PAbin <- c(rep(1, nrow(subOcc)), rep(0, nrow(bg)))

px <- raster(paste0('data/SDM/finalSDMmodels/', coastalInterior[1]))

TSSthresholds[['coastalInterior']][1] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss

px <- raster(paste0('data/SDM/finalSDMmodels/', coastalInterior[2]))

TSSthresholds[['coastalInterior']][2] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss


# Rockies
subOcc <- gIntersection(SpatialPoints(allOcc, proj4string=CRS(proj4string(region_list$rockies))), region_list$rockies)
subOcc <- coordinates(subOcc)
colnames(subOcc) <- c('Longitude','Latitude')
rownames(subOcc) <- NULL

PA <- rbind(subOcc, bg)
PA <- SpatialPoints(PA, proj4string=CRS('+proj=longlat +datum=WGS84'))
PAbin <- c(rep(1, nrow(subOcc)), rep(0, nrow(bg)))

px <- raster(paste0('data/SDM/finalSDMmodels/', rockies[1]))

TSSthresholds[['rockies']][1] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss

px <- raster(paste0('data/SDM/finalSDMmodels/', rockies[2]))

TSSthresholds[['rockies']][2] <- attributes(tssWeighted(extract(px, PA[which(PAbin == 1)]), extract(px, PA[which(PAbin == 0)])))$thresholdMaxTss

saveRDS(TSSthresholds, 'data/SDM/TSSthresholds.rds')



