(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    119043,       3068]
NotebookOptionsPosition[    117791,       3024]
NotebookOutlinePosition[    118136,       3039]
CellTagsIndexPosition[    118093,       3036]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"Gauss", "-", 
   RowBox[{"Chebyshev", " ", "quadrature", " ", 
    SubscriptBox["T", "k"]}]}], TraditionalForm]],
 ExpressionUUID -> "4244b2ca-f997-4cf1-8bff-691d7a1fa3dd"]], "Section",
 CellChangeTimes->{{3.694432541775999*^9, 3.694432545816378*^9}, {
  3.694432596404376*^9, 3.694432620380569*^9}, {3.6944330414465322`*^9, 
  3.6944330414466543`*^9}, {3.694433180265167*^9, 3.6944331802652884`*^9}, {
  3.694433265457508*^9, 3.694433265657895*^9}, {3.69564339491175*^9, 
  3.695643394911852*^9}, {3.873625613654057*^9, 3.873625614153933*^9}},
 ExpressionUUID -> "85fa84a6-e677-4453-8949-be1e46fce747"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"n", ",", "nz"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"definitionsTk", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"nz", "=", 
      RowBox[{"n", "-", "1"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"number", " ", "of", " ", "z"}], "-", "points"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"\[Pi]", 
           RowBox[{"(", 
            RowBox[{"j", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}], "n"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}], "//", "N"}]}], ";", "   ", 
     "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]z", "=", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"\[Pi]", " ", "i"}], "n"], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "nz"}], "}"}]}], "]"}], "//", "N"}]}], ";", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"z", "=", 
      RowBox[{"Cos", "[", "\[Theta]z", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"wGC", "=", 
      RowBox[{
       FractionBox["\[Pi]", "n"], " ", 
       SuperscriptBox["1", 
        RowBox[{"Range", "[", 
         RowBox[{"1", ",", "n"}], "]"}]]}]}], ";", " ", 
     RowBox[{"(*", 
      RowBox[{"quadrature", " ", "weights"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalH]", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "\[Pi]"], 
          FractionBox["wGC", 
           RowBox[{"#", "-", "s"}]]}], "&"}], "/@", "z"}], "  ", "//", 
       "N"}]}], ";", " ", 
     RowBox[{"(*", 
      RowBox[{
      "Hilbert", " ", "transform", " ", "operator", " ", "from", " ", "s", 
       " ", "to", " ", "z"}], "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "extrapolation", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalP]", "=", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"Range", "[", 
         RowBox[{"1", ",", "n"}], "]"}]], 
       FractionBox[
        RowBox[{"Tan", "[", 
         RowBox[{"\[Theta]", "/", "2"}], "]"}], "n"]}]}], ";", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"\[ScriptCapitalQ]", "=", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", "n"}], "]"}]]}], 
       FractionBox[
        RowBox[{"Cot", "[", 
         RowBox[{"\[Theta]", "/", "2"}], "]"}], "n"]}]}], ";", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalP]z", "=", 
      RowBox[{
       FractionBox[
        FractionBox["\[Omega]z", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "z"}]], 
        RowBox[{"Total", "[", 
         FractionBox["\[Omega]z", 
          RowBox[{
           RowBox[{"-", "1"}], "-", "z"}]], "]"}]], "//", "N"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "integration", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalPhi]", "[", "Z_", "]"}], "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"-", 
          RowBox[{"ArcCos", "[", "Z", "]"}]}], "}"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}], 
              RowBox[{"ArcCos", "[", "Z", "]"}]}], "]"}], 
            RowBox[{"k", "-", "1"}]]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "2", ",", "n"}], "}"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalB]", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"Sign", "[", 
           RowBox[{"k", "-", "1"}], "]"}]], 
         FractionBox[
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "-", "1"}], ")"}], " ", "\[Theta]"}], "]"}], "n"]}],
         "/.", 
        RowBox[{"k", "\[Rule]", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", "n"}], "]"}]}]}], "//", "Transpose"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Sign", "[", 
        RowBox[{"k", "-", "1"}], "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"0", " ", "for", " ", "k"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"1", " ", "and"}], " ", "+", 
          RowBox[{"1", " ", "for", " ", "k"}]}], ">", "1"}]}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalS]reverse", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalPhi]", "[", "1", "]"}], "-", 
           RowBox[{"\[CapitalPhi]", "[", "z", "]"}]}], ")"}], 
         "\[Transpose]"}], ".", "\[ScriptCapitalB]"}], " ", "//", "N"}]}], 
     ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"d\[Delta]", "/", "dz"}], " ", "=", " ", 
        RowBox[{
         RowBox[{"w", "[", "z", "]"}], 
         RowBox[{"F", "[", "z", "]"}]}]}], ";", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Delta]", "[", "1", "]"}], "-", 
         RowBox[{"\[Delta]", "[", 
          SubscriptBox["z", 
           RowBox[{"\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]], 
          "]"}]}], "=", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"j", "=", "1"}], "n"], 
         RowBox[{
          SubscriptBox["\[ScriptCapitalS]reverse", 
           RowBox[{"\[LeftDoubleBracket]", 
            RowBox[{"i", ",", "j"}], "\[RightDoubleBracket]"}]], 
          RowBox[{"F", "[", 
           SubscriptBox["s", 
            RowBox[{"\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}]], 
           "]"}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalS]All", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]", "[", 
           RowBox[{"+", "1"}], "]"}], "-", 
          RowBox[{"\[CapitalPhi]", "[", 
           RowBox[{"-", "1"}], "]"}]}], ")"}], ".", "\[ScriptCapitalB]"}], 
       " ", "//", "N"}]}], ";"}]}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.694432634064925*^9, 3.6944326668423033`*^9}, {
   3.69443305431511*^9, 3.694433056305437*^9}, 3.6944331827097397`*^9, {
   3.694433254875112*^9, 3.69443326883453*^9}, {3.6944333183166523`*^9, 
   3.694433320811528*^9}, 3.6954238703483152`*^9, {3.6954239716458263`*^9, 
   3.6954241896288557`*^9}, {3.695424222332136*^9, 3.695424277004714*^9}, {
   3.695424322943903*^9, 3.695424352022368*^9}, {3.6954244404942093`*^9, 
   3.695424470557414*^9}, {3.6954245254378557`*^9, 3.6954246813047457`*^9}, {
   3.6954247226757*^9, 3.6954247610720577`*^9}, 3.6954248450561113`*^9, {
   3.695424937677783*^9, 3.6954250007407513`*^9}, {3.6954250404806223`*^9, 
   3.695425104945137*^9}, {3.695425147876444*^9, 3.695425157452375*^9}, {
   3.695425562185207*^9, 3.695425650841379*^9}, {3.695425700881897*^9, 
   3.695425875448312*^9}, {3.695426392469726*^9, 3.6954264547422523`*^9}, {
   3.695427847792131*^9, 3.695427857973198*^9}, {3.695428061701557*^9, 
   3.695428062031623*^9}, {3.695428740862438*^9, 3.695428800879067*^9}, {
   3.6954295694533863`*^9, 3.695429569530946*^9}, {3.695430615903866*^9, 
   3.6954309100419903`*^9}, {3.695431037933688*^9, 3.695431097120571*^9}, {
   3.695481375905408*^9, 3.6954814113749323`*^9}, {3.6954828289700947`*^9, 
   3.6954828441240177`*^9}, {3.695482916854678*^9, 3.695482926509303*^9}, {
   3.6954835372660007`*^9, 3.695483555347245*^9}, {3.6954836048050957`*^9, 
   3.6954836203322477`*^9}, {3.695577821221738*^9, 3.695577857431302*^9}, {
   3.695578026429853*^9, 3.695578047382131*^9}, {3.695643089379456*^9, 
   3.6956431221478043`*^9}, {3.6956431602453327`*^9, 3.695643205351185*^9}, {
   3.695643441667296*^9, 3.695643463776867*^9}, {3.6956435007763042`*^9, 
   3.695643549062852*^9}, {3.695643590563717*^9, 3.695643609146057*^9}, {
   3.695643736065168*^9, 3.6956437436002617`*^9}, {3.695643774676442*^9, 
   3.6956438042703133`*^9}, 3.695643858650693*^9, {3.695643903504591*^9, 
   3.695643931359275*^9}, {3.695644161273761*^9, 3.6956441817547083`*^9}, {
   3.6956442640813637`*^9, 3.695644314675867*^9}, {3.695644353399724*^9, 
   3.695644408783725*^9}, 3.695644457278318*^9, {3.695644494176612*^9, 
   3.695644569669491*^9}, {3.695644653678439*^9, 3.695644702539688*^9}, {
   3.695644903630918*^9, 3.695644905156266*^9}, {3.695645215336953*^9, 
   3.6956452160143547`*^9}, {3.695645262100864*^9, 3.69564527431758*^9}, 
   3.6956455721890707`*^9, {3.6956514222377653`*^9, 3.695651465568904*^9}, {
   3.714149678720858*^9, 3.714149711257634*^9}, {3.714150260203726*^9, 
   3.714150261763042*^9}, {3.714152171742722*^9, 3.714152184906518*^9}, {
   3.7142164428861923`*^9, 3.7142164512900352`*^9}, {3.714227943910996*^9, 
   3.7142280464610367`*^9}, {3.714228080654817*^9, 3.714228140055031*^9}, {
   3.714228173451633*^9, 3.71422819614499*^9}, {3.7142282262542467`*^9, 
   3.7142283073440104`*^9}, {3.714228454060039*^9, 3.714228828565935*^9}, {
   3.714228874704357*^9, 3.71422893052779*^9}, {3.714228963683298*^9, 
   3.7142290175222883`*^9}, {3.714229829358644*^9, 3.714229830024954*^9}, {
   3.71423018892542*^9, 3.7142301990499372`*^9}, {3.714230272155772*^9, 
   3.714230287068158*^9}, {3.714230479663013*^9, 3.714230542523671*^9}, {
   3.714230595329899*^9, 3.7142306131136303`*^9}, {3.7142309450854607`*^9, 
   3.714230954443338*^9}, {3.71423891642435*^9, 3.7142389328826113`*^9}, {
   3.714239366207094*^9, 3.714239367743383*^9}, {3.7143078586353416`*^9, 
   3.714307888733583*^9}, {3.714311976965427*^9, 3.714311977311988*^9}, {
   3.714312691036826*^9, 3.7143126919354687`*^9}, 3.7156081227675753`*^9, {
   3.7160420665712833`*^9, 3.716042072109992*^9}, {3.716042130090733*^9, 
   3.7160421302664223`*^9}, 3.717500450107832*^9, {3.739509901811414*^9, 
   3.739509942611721*^9}, {3.873260831167678*^9, 3.8732608644685225`*^9}, {
   3.873260916572773*^9, 3.873260946117762*^9}, {3.873260984752535*^9, 
   3.8732610158186903`*^9}, {3.873261077025563*^9, 3.873261128414826*^9}, 
   3.873261161719471*^9, {3.8736249590766783`*^9, 3.873625013588293*^9}, {
   3.8736263271668906`*^9, 3.873626329950301*^9}, {3.8736272044190645`*^9, 
   3.873627207624919*^9}},
 ExpressionUUID -> "7568ad0a-9522-4ceb-83fb-d428d2301bb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solver", "Section",
 CellChangeTimes->{{3.854161589237958*^9, 3.854161590136191*^9}, 
   3.8769021090699496`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"z_", ",", "zo_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"z", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["zo", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], 
        RowBox[{"1", "/", "2"}]]}], 
      RowBox[{"zo", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], 
        RowBox[{"1", "/", "2"}]]}]]}], ")"}], 
   FractionBox["zo", 
    RowBox[{
     SuperscriptBox["z", "2"], "-", 
     SuperscriptBox["zo", "2"]}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"G", "[", 
    RowBox[{"z_", ",", "zo_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["zo", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], 
          RowBox[{"1", "/", "2"}]]}], 
        RowBox[{"zo", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["z", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], 
          RowBox[{"1", "/", "2"}]]}]]}], ")"}], 
     FractionBox[
      RowBox[{"2", 
       SuperscriptBox["zo", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["z", "2"], "-", 
         SuperscriptBox["zo", "2"]}], ")"}], "2"]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", " ", 
       FractionBox[
        RowBox[{"z", " ", "zo"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["zo", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], 
          RowBox[{"1", "/", "2"}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["z", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], 
          RowBox[{"1", "/", "2"}]]}]]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "-", 
       SuperscriptBox["zo", "2"]}], ")"}]}]}]}], 
  RowBox[{"(*", 
   RowBox[{
   "partial", " ", "differential", " ", "derivation", " ", "of", " ", "F", 
    " ", "for", " ", "zo"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "2"], "I", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"Conjugate", "[", "z", "]"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"Conjugate", "[", "z", "]"}], ")"}], "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], 
        RowBox[{"1", "/", "2"}]]], "-", 
      FractionBox["z", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], 
        RowBox[{"1", "/", "2"}]]], "+", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"2", " ", "\[Theta]a", " ", "I"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Conjugate", "[", "z", "]"}], "-", "z"}], ")"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], 
            RowBox[{"3", "/", "2"}]]], 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", 
          FractionBox["z", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], 
            RowBox[{"1", "/", "2"}]]]}], "-", "2"}], ")"}]}]}], ")"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.847849840631806*^9, 3.847849841952121*^9}, {
   3.8478501478854885`*^9, 3.847850175392643*^9}, {3.8478502312977896`*^9, 
   3.8478502408165827`*^9}, {3.847850849614809*^9, 3.847850941189292*^9}, {
   3.847943008220632*^9, 3.8479430201765366`*^9}, {3.8497548284245777`*^9, 
   3.8497548286901217`*^9}, {3.849755057485113*^9, 3.8497550691561356`*^9}, {
   3.8499079245760827`*^9, 3.8499079354123096`*^9}, 3.8499308666003113`*^9, {
   3.8499309259866414`*^9, 3.849930937178913*^9}, {3.8499325687676077`*^9, 
   3.84993258318058*^9}, {3.850178101741686*^9, 3.8501781026947575`*^9}, {
   3.850178359757809*^9, 3.85017845440362*^9}, {3.8501787811357822`*^9, 
   3.850178785644415*^9}, {3.8501989900723205`*^9, 3.850199014108122*^9}, {
   3.8501990459799023`*^9, 3.850199074291219*^9}, {3.8503343881270375`*^9, 
   3.8503343901269245`*^9}, 3.8503405836051664`*^9, {3.8504354566870627`*^9, 
   3.8504355198174205`*^9}, {3.8504355804987087`*^9, 3.85043559133544*^9}, {
   3.850435750665251*^9, 3.850435756919483*^9}, {3.8505275605769386`*^9, 
   3.8505275670613737`*^9}, {3.85061956752793*^9, 3.8506196067368903`*^9}, {
   3.851026041729986*^9, 3.8510260653452177`*^9}, {3.8510262536316824`*^9, 
   3.8510262614820423`*^9}, {3.8541602194155955`*^9, 
   3.8541602326157293`*^9}, {3.8541668445265083`*^9, 
   3.8541668685705123`*^9}, {3.854255256397356*^9, 3.854255262418292*^9}, 
   3.85425685296535*^9, 3.854260969777019*^9, 3.854261571405812*^9, {
   3.8548138205716076`*^9, 3.8548138218891487`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{"F_", ",", "z_", ",", "zo_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"F", "[", 
      RowBox[{"z", ",", "zo"}], "]"}]}], "+", 
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"Conjugate", "[", "z", "]"}], ",", "zo"}], "]"}], "+", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"2", " ", "I", " ", "\[Theta]a"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"F", "[", 
         RowBox[{"z", ",", "zo"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", 
          RowBox[{"Conjugate", "[", "z", "]"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{"z", ",", "zo"}], "]"}], ",", "z"}], "]"}], ")"}]}]}], 
      ")"}]}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "possibility", " ", "of", " ", "derivation", " ", "of", " ", "z", " ", 
    "or", " ", "zo"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsum", "[", 
   RowBox[{"z_", ",", "zo_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{"z", ",", "zo"}], "]"}], "+", 
   RowBox[{"F", "[", 
    RowBox[{"z", ",", 
     RowBox[{"Conjugate", "[", "zo", "]"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G1", "[", 
   RowBox[{"z_", ",", "zo_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"zo", "-", 
     RowBox[{"Conjugate", "[", "zo", "]"}]}], ")"}], 
   RowBox[{"G", "[", 
    RowBox[{"z", ",", "zo"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2", "[", 
   RowBox[{"z_", ",", "zo_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Conjugate", "[", "zo", "]"}], "-", "zo"}], ")"}], 
   RowBox[{"G", "[", 
    RowBox[{"z", ",", 
     RowBox[{"Conjugate", "[", "zo", "]"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L1", "[", 
    RowBox[{"z_", ",", "zo_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Mu]", " ", "I"}]}], ")"}], "2"], 
     RowBox[{"U", "[", 
      RowBox[{"Fsum", ",", "z", ",", "zo"}], "]"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[Mu]", " ", "I"}]}], ")"}], "2"], 
     RowBox[{"U", "[", 
      RowBox[{"G1", ",", "z", ",", "zo"}], "]"}]}], "-", 
    FractionBox["1", 
     RowBox[{"z", "+", "zo"}]], "+", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"2", "\[Theta]a", " ", "I"}], "]"}], 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Conjugate", "[", "z", "]"}], "+", 
        RowBox[{"Conjugate", "[", "zo", "]"}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "zo"}], ")"}], "2"]]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L2", "[", 
    RowBox[{"z_", ",", "zo_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[Mu]", " ", "I"}]}], ")"}]}], "2"], 
     RowBox[{"U", "[", 
      RowBox[{"Fsum", ",", "z", ",", "zo"}], "]"}]}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Mu]", " ", "I"}]}], ")"}], "2"], 
     RowBox[{"U", "[", 
      RowBox[{"G2", ",", "z", ",", "zo"}], "]"}]}], "-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"Conjugate", "[", "z", "]"}], "+", 
      RowBox[{"Conjugate", "[", "zo", "]"}]}]], "-", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"2", "\[Theta]a", " ", "I"}], "]"}], 
     FractionBox["1", 
      RowBox[{"z", "+", "zo"}]]}]}]}], " ", ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Kp1", "[", 
     RowBox[{"s_", ",", "t_"}], "]"}], ":=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"s", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "\[Theta]a"}], "]"}]}], "-", "t"}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{
            RowBox[{"-", "I"}], " ", "\[Theta]a"}], "]"}]}], "-", "t"}], 
        ")"}], 
       RowBox[{"Exp", "[", 
        RowBox[{"2", " ", "I", " ", "\[Theta]a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", "\[Theta]a"}], "]"}]}], "-", "t"}], ")"}], 
       "2"]]}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"K", " ", "stands", " ", "for", " ", "kink"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Kp2", "[", 
     RowBox[{"s_", ",", "t_"}], "]"}], ":=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"s", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[Theta]a"}], "]"}]}], "-", "t"}]], "+", 
     FractionBox[
      RowBox[{"Exp", "[", 
       RowBox[{"2", " ", "I", " ", "\[Theta]a"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "\[Theta]a"}], "]"}]}], "-", "t"}], ")"}]]}]}], 
   ";"}], " ", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"given", " ", "terms"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tp1", "[", 
     RowBox[{"u_", ",", "r_"}], "]"}], ":=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"u", "-", 
       RowBox[{"r", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}]], "-", 
     FractionBox[
      RowBox[{"(", 
       RowBox[{"u", "-", 
        RowBox[{"r", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "\[Theta]a"}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"u", " ", "-", " ", 
         RowBox[{"r", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], "2"]]}]}], 
   ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tp2", "[", 
    RowBox[{"u_", ",", "r_"}], "]"}], ":=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"u", "-", 
      RowBox[{"r", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "\[Theta]a"}], "]"}]}]}]], "+", 
    FractionBox[
     RowBox[{" ", "1"}], 
     RowBox[{"(", 
      RowBox[{"u", " ", "-", " ", 
       RowBox[{"r", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}]]}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8541668740333147`*^9, 3.854167018291613*^9}, {
   3.8541670527525144`*^9, 3.8541670529869175`*^9}, {3.854182372138383*^9, 
   3.8541823993351135`*^9}, {3.8541836878017135`*^9, 3.8541836881141624`*^9}, 
   3.854339208088297*^9, {3.854352592167367*^9, 3.854352602564963*^9}, {
   3.8544324476500425`*^9, 3.854432449698106*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Us", "[", 
   RowBox[{"F_", ",", "z_", ",", "zo_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"F", "[", 
     RowBox[{"z", ",", "zo"}], "]"}]}], "+", 
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"Conjugate", "[", "z", "]"}], ",", "zo"}], "]"}], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"F", "[", 
       RowBox[{"z", ",", "zo"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", 
        RowBox[{"Conjugate", "[", "z", "]"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"F", "[", 
          RowBox[{"z", ",", "zo"}], "]"}], ",", "z"}], "]"}], ")"}]}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Ls1", "[", 
    RowBox[{"z_", ",", "zo_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Mu]", " ", "I"}]}], ")"}], "2"], 
     RowBox[{"Us", "[", 
      RowBox[{"Fsum", ",", "z", ",", "zo"}], "]"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[Mu]", " ", "I"}]}], ")"}], "2"], 
     RowBox[{"Us", "[", 
      RowBox[{"G1", ",", "z", ",", "zo"}], "]"}]}], "-", 
    FractionBox["1", 
     RowBox[{"z", "+", "zo"}]], "+", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Conjugate", "[", "z", "]"}], "+", 
       RowBox[{"Conjugate", "[", "zo", "]"}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "zo"}], ")"}], "2"]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Ls2", "[", 
    RowBox[{"z_", ",", "zo_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[Mu]", " ", "I"}]}], ")"}]}], "2"], 
     RowBox[{"Us", "[", 
      RowBox[{"Fsum", ",", "z", ",", "zo"}], "]"}]}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Mu]", " ", "I"}]}], ")"}], "2"], 
     RowBox[{"Us", "[", 
      RowBox[{"G2", ",", "z", ",", "zo"}], "]"}]}], "-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"Conjugate", "[", "z", "]"}], "+", 
      RowBox[{"Conjugate", "[", "zo", "]"}]}]], "-", 
    FractionBox["1", 
     RowBox[{"z", "+", "zo"}]]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sp", "[", "u_", "]"}], "=", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{"c", "+", "u"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "u", " ", "c"}], "+", 
         SuperscriptBox["u", "2"]}], ")"}], 
       RowBox[{"1", "/", "2"}]]], "-", "1"}], ")"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.854169063965314*^9, 3.8541691349620743`*^9}, {
   3.854183676341182*^9, 3.85418368346441*^9}, {3.8542574210056243`*^9, 
   3.8542574597482977`*^9}, 3.854260974017788*^9, 3.8542615758581305`*^9, 
   3.8548138036275434`*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"for", " ", "a", " ", "given", " ", 
   RowBox[{"\[Tau]Y", "/", "\[Sigma]2"}], " ", "ratio"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8560996662376432`*^9, 3.8560996838641253`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SolveGC", "[", 
    RowBox[{
    "lp_", ",", "lt_", ",", "\[Theta]a_", ",", "n_", ",", "\[Mu]_", ",", 
     "\[Gamma]_", ",", "ts2Ratio_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "term1", ",", "term2", ",", "term3", ",", "term4", ",", "term5", ",", 
       "termboundary", ",", "termK", ",", "term6", ",", "term7", ",", 
       "term8a", ",", "term8b", ",", " ", "Eqn1", ",", "\[IndentingNewLine]", 
       "terms1", ",", "terms2a", ",", "terms2b", ",", "terms3", ",", "terms4",
        ",", "terms5a", ",", "terms5b", ",", "terms6", ",", "terms7", ",", 
       "termsK", ",", "termsK2", ",", "Eqn2", ",", "\[IndentingNewLine]", 
       "Eqns12", ",", "RealEqns", ",", "ImaginaryEqns", ",", "Eqns3", ",", 
       "sol", ",", "\[IndentingNewLine]", "\[Tau]ys1", ",", "KI", ",", 
       "\[IndentingNewLine]", "Fr", ",", "F\[Theta]", ",", "Fp", ",", "t", 
       ",", "u"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "For", " ", "a", " ", "given", " ", "confining", " ", "stress", " ", 
        RowBox[{"\[Tau]Y", "/", "\[Sigma]2"}]}], ",", " ", 
       RowBox[{"incilination", " ", "angles", " ", "\[Theta]a"}], ",", " ", 
       RowBox[{
        RowBox[{"\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"we", " ", "set", " ", "\[Theta]a"}], "=", 
           RowBox[{"\[Gamma]", "=", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "4"}], " ", "in", " ", "our", " ", 
             "paper"}]}]}], ")"}]}], ";", " ", 
        RowBox[{
        "tensile", " ", "wing", " ", "crack", " ", "length", " ", "lt"}]}], 
       ",", " ", 
       RowBox[{"plastic", " ", "zone", " ", "size", " ", "lp"}], ",", " ", 
       RowBox[{"we", " ", "solve", " ", "for", " ", "Fr"}], ",", " ", 
       "F\[Theta]", ",", " ", 
       RowBox[{
        RowBox[{"Fp", " ", "and", " ", "\[Sigma]21"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Sigma]21", " ", "represents", " ", 
         RowBox[{"\[Sigma]2", "/", "\[Sigma]1"}]}]}], ",", " ", 
       RowBox[{
        RowBox[{
        "and", " ", "negative", " ", "represents", " ", "compression"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tsRatio", " ", "represents", " ", 
         RowBox[{"\[Tau]Y", "/", "\[Sigma]2"}]}], ";", " ", 
        RowBox[{
        "and", " ", "it", " ", "should", " ", "be", " ", "negative"}]}], ",", 
       " ", 
       RowBox[{
       "since", " ", "negative", " ", "represents", " ", "compression"}]}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"definitionsTk", "[", "n", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"t", "=", "s"}], ";", "\[IndentingNewLine]", 
      RowBox[{"u", "=", "z"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Fr", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Phi]r", "j"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", "  ", 
      "\[IndentingNewLine]", 
      RowBox[{"F\[Theta]", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Phi]\[Theta]", "j"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", "  ", 
      "\[IndentingNewLine]", 
      RowBox[{"Fp", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Phi]t", "j"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Tau]Y1", "=", 
       RowBox[{"ts2Ratio", " ", "\[Sigma]21"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"term1", "=", 
       RowBox[{
        FractionBox["1", "lt"], " ", 
        RowBox[{"\[ScriptCapitalH]", ".", 
         RowBox[{"(", 
          RowBox[{"F\[Theta]", "+", 
           RowBox[{"I", " ", "Fr"}]}], ")"}]}], 
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"term2", "=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"8", " ", "\[Pi]"}]], 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"L1", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                 RowBox[{"Exp", "[", 
                  RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                 RowBox[{"Exp", "[", 
                  RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}]}], "]"}], 
            "&"}], "/@", "z"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"wGC", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Fr", " ", 
                RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
               RowBox[{"F\[Theta]", " ", 
                RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "-", 
             RowBox[{"I", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Fr", " ", 
                 RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                RowBox[{"F\[Theta]", " ", 
                 RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
            ")"}]}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"term3", "=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"8", " ", "\[Pi]"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"L2", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}]}], "]"}],
              "&"}], "/@", "z"}], ")"}], ".", 
          RowBox[{"(", " ", 
           RowBox[{"wGC", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Fr", " ", 
                 RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                RowBox[{"F\[Theta]", " ", 
                 RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "+", 
              RowBox[{"I", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Fr", " ", 
                  RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                 RowBox[{"F\[Theta]", " ", 
                  RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
             ")"}]}], ")"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"term4", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"2", " ", "\[Gamma]"}], "]"}], "+", 
             RowBox[{"\[Mu]", " ", 
              RowBox[{"Cos", "[", 
               RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{
           FractionBox["1", "2"], "\[Mu]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Sigma]21"}], ")"}]}], "+", "\[Tau]c1"}], 
         ")"}], 
        RowBox[{"(", 
         RowBox[{"S", "[", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             FractionBox[
              RowBox[{"(", 
               RowBox[{"z", "+", "1"}], ")"}], "2"], "lt", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], "]"}], " ", 
         ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"term5", "=", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Sigma]21"}], ")"}]}], "-", 
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
         RowBox[{"Cos", "[", 
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{"\[Gamma]", "-", "\[Theta]a"}], ")"}]}], "]"}]}], "+", 
        RowBox[{"I", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{"Sin", "[", 
            RowBox[{"2", 
             RowBox[{"(", 
              RowBox[{"\[Gamma]", "-", "\[Theta]a"}], ")"}]}], "]"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Sigma]21"}], ")"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"termboundary", "=", 
       RowBox[{"-", 
        RowBox[{"\[ScriptCapitalS]All", ".", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Fr", " ", 
            RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
           RowBox[{"F\[Theta]", " ", 
            RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"termK", "=", 
       RowBox[{"\[ScriptCapitalP]", ".", "Fr"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"term6", "=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"8", " ", "\[Pi]"}]], 
        RowBox[{"(", 
         RowBox[{"-", "I"}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Kp1", "[", 
             RowBox[{
              RowBox[{
               FractionBox[
                RowBox[{"#", "+", "1"}], "2"], " ", "lt"}], ",", 
              RowBox[{
               FractionBox[
                RowBox[{"(", 
                 RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], "]"}], "&"}],
            "/@", "z"}], " ", ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"wGC", " ", "Fp"}], ")"}]}]}]}], " ", ";", 
      "\[IndentingNewLine]", 
      RowBox[{"term7", "=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"8", " ", "\[Pi]"}]], 
        RowBox[{"(", "I", ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Kp2", "[", 
             RowBox[{
              RowBox[{
               FractionBox[
                RowBox[{"#", "+", "1"}], "2"], " ", "lt"}], ",", 
              RowBox[{
               FractionBox[
                RowBox[{"(", 
                 RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], "]"}], "&"}],
            "/@", "z"}], " ", ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"wGC", " ", "Fp"}], ")"}]}]}]}], " ", ";", 
      "\[IndentingNewLine]", 
      RowBox[{"term8a", "=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"8", " ", "\[Pi]"}]], 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"L1", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                 RowBox[{"Exp", "[", 
                  RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], " ", 
               ")"}]}], "]"}], "&"}], "/@", "z"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"wGC", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "I"}], "  ", "Fp"}], ")"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"term8b", "=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"8", " ", "\[Pi]"}]], 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"L2", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                 RowBox[{"Exp", "[", 
                  RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], " ", 
               ")"}]}], "]"}], "&"}], "/@", "z"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"wGC", " ", 
           RowBox[{"(", 
            RowBox[{"I", "  ", "Fp"}], ")"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eqn1", "=", 
       RowBox[{"(", 
        RowBox[{
        "term1", "+", "term2", "+", "term3", "+", "term4", "+", "term5", "+", 
         "term6", "+", "term7", "+", "term8a", "+", "term8b"}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"terms1", "=", 
       RowBox[{
        FractionBox["1", "lp"], " ", 
        RowBox[{"\[ScriptCapitalH]", ".", 
         RowBox[{"(", 
          RowBox[{"I", " ", "Fp"}], ")"}]}], 
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"terms2a", "=", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Ls1", "[", 
              RowBox[{
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}]}], "]"}], 
             "&"}], "/@", "u"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", 
            RowBox[{"(", " ", 
             RowBox[{
              RowBox[{"-", "I"}], " ", "Fp"}], ")"}]}], ")"}]}]}], ")"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"terms2b", "=", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Ls2", "[", 
              RowBox[{
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
               RowBox[{"1", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"(", 
                   RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}]}], "]"}], 
             "&"}], "/@", "u"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", 
            RowBox[{"(", 
             RowBox[{"I", " ", "Fp"}], ")"}]}], ")"}]}]}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"terms3", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", 
             RowBox[{"8", " ", "\[Pi]"}]], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Tp1", "[", 
                 RowBox[{
                  RowBox[{
                   FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}], ",", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt"}]}], "]"}], 
                "&"}], "/@", "u"}], ")"}], ".", 
             RowBox[{"(", 
              RowBox[{"wGC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                   RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "-", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                ")"}]}], ")"}]}]}], ")"}], "//", "Im"}], ")"}], "I"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"terms4", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", 
             RowBox[{"8", " ", "\[Pi]"}]], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Tp2", "[", 
                 RowBox[{
                  RowBox[{
                   FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}], ",", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt"}]}], "]"}], 
                "&"}], "/@", "u"}], ")"}], ".", 
             RowBox[{"(", 
              RowBox[{"wGC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                   RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "+", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                ")"}]}], ")"}]}]}], ")"}], "//", "Im"}], ")"}], "I"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"terms5a", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", 
             RowBox[{"8", " ", "\[Pi]"}]], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Ls1", "[", 
                 RowBox[{
                  RowBox[{"1", "+", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}]}], " ", "]"}], 
                "&"}], "/@", "u"}], ")"}], ".", 
             RowBox[{"(", 
              RowBox[{"wGC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                   RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "-", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                ")"}]}], ")"}]}]}], " ", ")"}], "//", "Im"}], ")"}], "I"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"terms5b", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", 
             RowBox[{"8", " ", "\[Pi]"}]], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Ls2", "[", 
                 RowBox[{
                  RowBox[{"1", "+", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}]}], " ", "]"}], 
                "&"}], "/@", "u"}], ")"}], ".", 
             RowBox[{"(", 
              RowBox[{"wGC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                   RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "+", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                ")"}]}], ")"}]}]}], " ", ")"}], "//", "Im"}], ")"}], "I"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"terms6", "=", 
       RowBox[{"I", 
        RowBox[{"(", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sp", "[", 
            RowBox[{
             FractionBox[
              RowBox[{"(", 
               RowBox[{"u", "+", "1"}], ")"}], "2"], "lp"}], "]"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"(", 
               RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Sin", "[", 
                 RowBox[{"2", " ", "\[Gamma]"}], "]"}], "+", 
                RowBox[{"\[Mu]", " ", 
                 RowBox[{"Cos", "[", 
                  RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{
              FractionBox["1", "2"], "\[Mu]", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Sigma]21"}], ")"}]}], "+", "\[Tau]c1"}], 
            ")"}]}], ")"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"terms7", "=", 
       RowBox[{"I", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"2", " ", "\[Gamma]"}], "]"}]}], "+", "\[Tau]Y1"}], 
         ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"termsK", "=", 
       RowBox[{"\[ScriptCapitalQ]", ".", "Fp"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"termsK2", "=", 
       RowBox[{"\[ScriptCapitalP]", ".", "Fp"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Eqn2", "=", 
       RowBox[{
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", "termboundary", "}"}], ",", 
          RowBox[{"{", "termK", "}"}], ",", 
          RowBox[{"{", "termsK2", "}"}], ",", 
          RowBox[{"{", "termsK", "}"}]}], "]"}], "//", "N"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eqns12", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"Eqn1", ",", "Eqn2"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"RealEqns", "=", 
       RowBox[{
        RowBox[{"Eqns12", "//", "Re"}], "//", "ComplexExpand"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ImaginaryEqns", "=", 
       RowBox[{
        RowBox[{"Eqns12", "//", "Im"}], "//", "ComplexExpand"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eqns3", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
          "terms1", "+", "terms2a", "+", "terms2b", "+", "terms3", "+", 
           "terms4", "+", "terms5a", "+", "terms5b", "+", "terms6", "+", 
           "terms7"}], ")"}], "//", "Im"}], "//", "ComplexExpand"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "sol", "}"}], "=", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"RealEqns", ",", 
            RowBox[{"Drop", "[", 
             RowBox[{"ImaginaryEqns", ",", 
              RowBox[{"-", "4"}]}], "]"}], ",", "Eqns3"}], "]"}], "\[Equal]", 
          "0"}], ",", 
         RowBox[{"Join", "[", 
          RowBox[{"Fr", ",", "F\[Theta]", ",", "Fp", ",", 
           RowBox[{"{", "\[Sigma]21", "}"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Tau]ys1", "=", 
       RowBox[{
        RowBox[{"\[Tau]Y1", "/.", "sol"}], "//", "Re"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"KI", "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"2", 
            SqrtBox["2"]}]], 
          SuperscriptBox[
           RowBox[{"(", "lt", ")"}], 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}]], 
          RowBox[{"(", 
           RowBox[{"1", "/", "\[Tau]Y1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"\[ScriptCapitalQ]", ".", "F\[Theta]"}], ")"}]}], "/.", 
         "sol"}], "//", "Re"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"sol", ",", "\[Tau]ys1", ",", "KI"}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8560047431351147`*^9, 3.856004824709817*^9}, {
   3.8560048807432756`*^9, 3.8560049519995394`*^9}, {3.856005447807413*^9, 
   3.8560055551660657`*^9}, {3.85609740882657*^9, 3.856097412500327*^9}, {
   3.8560974876315737`*^9, 3.856097562757046*^9}, {3.8560976242615395`*^9, 
   3.8560976245271387`*^9}, {3.856098038014436*^9, 3.856098124253251*^9}, {
   3.856098667674296*^9, 3.856098670812829*^9}, {3.85609873933366*^9, 
   3.8560988101122627`*^9}, {3.8560988416306415`*^9, 3.8560988919107056`*^9}, 
   3.856099412607299*^9, {3.856099604296672*^9, 3.8560996048278847`*^9}, {
   3.8560996633159847`*^9, 3.8560996638315806`*^9}, 3.8560999544707713`*^9, {
   3.8561000089448414`*^9, 3.856100092130613*^9}, {3.8561001259292893`*^9, 
   3.8561001299325542`*^9}, {3.856100830273845*^9, 3.856100919122116*^9}, {
   3.8561862524334154`*^9, 3.8561862612738924`*^9}, {3.856186359813426*^9, 
   3.8561863662800035`*^9}, {3.8561866584502635`*^9, 
   3.8561866606063533`*^9}, {3.856186725518751*^9, 3.8561867292743683`*^9}, 
   3.8561884318708487`*^9, {3.873624635102502*^9, 3.873624651609259*^9}, {
   3.873625547134838*^9, 3.8736255680081406`*^9}, {3.8736256349245057`*^9, 
   3.873625776895671*^9}, {3.873625874690067*^9, 3.8736259427692876`*^9}, {
   3.8736259733610764`*^9, 3.8736259925653644`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StressStrain", "[", 
    RowBox[{
    "n_", ",", "ltArray_", ",", "lpArray_", ",", "KIArray_", ",", 
     "\[Tau]YArray_", ",", "solutionArray_", ",", "\[Theta]a_", ",", "\[Mu]_",
      ",", "\[Gamma]_", ",", "ts2Ratio_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "n\[CapitalDelta]", ",", "\[Epsilon]dxxlist", ",", "\[Epsilon]dxylist", 
       ",", "\[Epsilon]dyylist", ",", "\[Epsilon]dvlist", ",", 
       "difstresslist", ",", "\[IndentingNewLine]", "solution", ",", 
       "\[Delta]\[Theta]", ",", "\[Delta]r", ",", "\[Delta]p", ",", 
       "\[Tau]Ylist", ",", "ltlist", ",", "lplist", ",", "stress", ",", 
       "\[IndentingNewLine]", "ux", ",", "\[Epsilon]b1", ",", "up", ",", 
       "\[Epsilon]b2", ",", "\[Epsilon]byy", ",", "\[Epsilon]bxx", ",", 
       "\[Epsilon]bxy", ",", "\[Epsilon]12", ",", "\[Epsilon]11", ",", 
       "\[Epsilon]dxx", ",", "\[Epsilon]dyy", ",", "\[Epsilon]dxy"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"n\[CapitalDelta]", "=", 
       RowBox[{"ltArray", "//", "Length"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"global", " ", "parameters"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"definitionsTk", "[", "n", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"t", "=", "s"}], ";", "\[IndentingNewLine]", 
      RowBox[{"u", "=", "z"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Fr", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Phi]r", "j"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", "  ", 
      "\[IndentingNewLine]", 
      RowBox[{"F\[Theta]", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Phi]\[Theta]", "j"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", "  ", 
      "\[IndentingNewLine]", 
      RowBox[{"Fp", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Phi]t", "j"], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", " ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"\[Epsilon]dxxlist", "=", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "n\[CapitalDelta]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Epsilon]dxylist", "=", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "n\[CapitalDelta]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Epsilon]dyylist", "=", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "n\[CapitalDelta]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Epsilon]dvlist", "=", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "n\[CapitalDelta]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"difstresslist", "=", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "n\[CapitalDelta]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"solution", "=", 
          RowBox[{"solutionArray", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Delta]\[Theta]", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"\[ScriptCapitalS]reverse", ".", "F\[Theta]"}]}], "/.", 
           "solution"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Delta]r", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"\[ScriptCapitalS]reverse", ".", "Fr"}]}], "/.", 
           "solution"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Delta]p", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"\[ScriptCapitalS]reverse", ".", "Fp"}]}], "/.", 
           "solution"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Tau]Ylist", "=", 
          RowBox[{"\[Tau]YArray", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"ltlist", "=", 
          RowBox[{"ltArray", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"lplist", "=", 
          RowBox[{"lpArray", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"stress", "=", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", "\[Tau]Ylist", ")"}]}], "//", "Flatten"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ux", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Sin", "[", "\[Theta]a", "]"}], 
                RowBox[{"(", 
                 RowBox[{"\[ScriptCapitalP]z", ".", 
                  RowBox[{"\[Delta]\[Theta]", "[", 
                   RowBox[{"[", "#", "]"}], "]"}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"Cos", "[", "\[Theta]a", "]"}], 
                RowBox[{"(", 
                 RowBox[{"\[ScriptCapitalP]z", ".", 
                  RowBox[{"\[Delta]r", "[", 
                   RowBox[{"[", "#", "]"}], "]"}]}], ")"}]}]}], ")"}], 
             RowBox[{"(", 
              RowBox[{"1", "/", 
               RowBox[{"\[Tau]Ylist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}]}], "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]b1", "=", "ux"}], ";", "\[IndentingNewLine]", 
         RowBox[{"up", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\[ScriptCapitalP]z", ".", 
               RowBox[{"\[Delta]p", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}], 
             RowBox[{"(", 
              RowBox[{"1", "/", 
               RowBox[{"\[Tau]Ylist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}]}], "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]b2", "=", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "2"]}], "lplist", 
           RowBox[{"(", 
            RowBox[{"up", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "\[Tau]Ylist"}], ")"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[ScriptCapitalS]All", ".", 
                 RowBox[{"(", 
                  RowBox[{"t", " ", "Fp"}], ")"}]}], "/.", "solution"}], 
               ")"}]}]}], ")"}]}]}], " ", ";", "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]byy", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"\[Epsilon]b1", "+", "\[Epsilon]b2"}], ")"}]}], 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]bxx", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Epsilon]b1", "+", "\[Epsilon]b2"}], ")"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]bxy", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"\[Epsilon]b1", "+", "\[Epsilon]b2"}], ")"}]}], 
           RowBox[{"Cos", "[", 
            RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]12", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], 
             RowBox[{"ltlist", "[", 
              RowBox[{"[", "#", "]"}], "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[ScriptCapitalP]z", ".", 
                RowBox[{"(", 
                 RowBox[{"\[Delta]r", "[", 
                  RowBox[{"[", "#", "]"}], "]"}], ")"}]}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[ScriptCapitalS]All", ".", 
                  RowBox[{"(", 
                   RowBox[{"s", " ", "Fr"}], ")"}]}], "/.", 
                 RowBox[{"(", 
                  RowBox[{"solution", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], ")"}]}], ")"}]}], ")"}]}], 
            "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]11", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"ltlist", "[", 
              RowBox[{"[", "#", "]"}], "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[ScriptCapitalP]z", ".", 
                RowBox[{"(", 
                 RowBox[{"\[Delta]\[Theta]", "[", 
                  RowBox[{"[", "#", "]"}], "]"}], ")"}]}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[ScriptCapitalS]All", ".", 
                  RowBox[{"(", 
                   RowBox[{"s", " ", "F\[Theta]"}], ")"}]}], "/.", 
                 RowBox[{"(", 
                  RowBox[{"solution", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], ")"}]}], ")"}]}], ")"}]}], 
            "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]dxx", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "/", 
               RowBox[{"\[Tau]Ylist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}], 
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"\[Gamma]", "-", "\[Theta]a"}], "]"}], 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"\[Epsilon]11", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], " ", 
                  RowBox[{"Cos", "[", 
                   RowBox[{"\[Gamma]", "-", "\[Theta]a"}], "]"}]}], "+", " ", 
                 RowBox[{"2", " ", 
                  RowBox[{"\[Epsilon]12", " ", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], 
                  RowBox[{"Sin", "[", 
                   RowBox[{"\[Gamma]", "-", "\[Theta]a"}], "]"}]}]}], ")"}]}],
               ")"}]}], "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]dyy", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "/", 
               RowBox[{"\[Tau]Ylist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"\[Gamma]", "-", "\[Theta]a"}], "]"}], 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"\[Epsilon]12", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], "  ", 
                  RowBox[{"Cos", "[", 
                   RowBox[{"\[Gamma]", "-", "\[Theta]a"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{"\[Epsilon]11", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], " ", 
                  RowBox[{"Sin", "[", 
                   RowBox[{"\[Gamma]", "-", "\[Theta]a"}], "]"}]}]}], ")"}]}],
               ")"}]}], "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]dxy", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "/", 
               RowBox[{"\[Tau]Ylist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"\[Epsilon]12", "[", 
                  RowBox[{"[", "#", "]"}], "]"}]}], " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", 
                  RowBox[{"(", 
                   RowBox[{"\[Gamma]", "-", "\[Theta]a"}], ")"}]}], "]"}]}], 
               "+", 
               RowBox[{
                RowBox[{"1", "/", "2"}], " ", 
                RowBox[{"\[Epsilon]11", "[", 
                 RowBox[{"[", "#", "]"}], "]"}], " ", 
                RowBox[{"Sin", "[", 
                 RowBox[{"2", 
                  RowBox[{"(", 
                   RowBox[{"\[Gamma]", "-", "\[Theta]a"}], ")"}]}], "]"}]}]}],
               ")"}]}], "&"}], "/@", 
           RowBox[{"Range", "[", 
            RowBox[{"ltlist", "//", "Length"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Epsilon]dxxlist", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"\[Epsilon]dxx", "+", "\[Epsilon]bxx"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Epsilon]dxylist", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"\[Epsilon]dxy", "+", "\[Epsilon]bxy"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Epsilon]dyylist", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"\[Epsilon]dyy", "+", "\[Epsilon]byy"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Epsilon]dvlist", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{
          "\[Epsilon]dxx", "+", "\[Epsilon]dyy", "+", "\[Epsilon]bxx", "+", 
           "\[Epsilon]byy"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"difstresslist", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"-", "stress"}], "+", 
           RowBox[{"1", "/", "ts2Ratio"}]}]}], ";"}], "\[IndentingNewLine]", 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n\[CapitalDelta]"}], "}"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "\[Epsilon]dvlist", ",", "difstresslist", ",", "\[Epsilon]dxxlist", 
        ",", "\[Epsilon]dyylist", ",", "\[Epsilon]dxylist"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8597160619561844`*^9, 3.8597161270375576`*^9}, {
   3.859716162569929*^9, 3.8597162067190294`*^9}, {3.859716238456428*^9, 
   3.859716318836009*^9}, {3.8597163576072598`*^9, 3.8597163789718657`*^9}, {
   3.8597164252091007`*^9, 3.8597166245951757`*^9}, {3.8597209698849354`*^9, 
   3.859720970900484*^9}, 3.859721298721972*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Benchmark for constant \[Sigma]1/\[Sigma]2 conditions with a given length of \
wing crack length lt and plastic zone size lp\
\>", "Section",
 CellChangeTimes->{{3.850340642526592*^9, 3.8503406485969725`*^9}, {
   3.8504198058003173`*^9, 3.8504198287868204`*^9}, {3.850507611420844*^9, 
   3.850507639562162*^9}, {3.8505104573042917`*^9, 3.850510466184187*^9}, {
   3.850620508436393*^9, 3.8506205104362164`*^9}, {3.8506205603553543`*^9, 
   3.85062059957318*^9}, 3.8506206327182875`*^9, {3.850621671468974*^9, 
   3.850621688220354*^9}, {3.8506226297369423`*^9, 3.850622653763399*^9}, {
   3.8510259078043375`*^9, 3.8510259176688175`*^9}, {3.8510273858865848`*^9, 
   3.8510273929789133`*^9}, {3.851030305632329*^9, 3.8510303126207657`*^9}, {
   3.8541602463671427`*^9, 3.854160259290244*^9}, 3.8541619115734143`*^9, {
   3.854183655774458*^9, 3.8541836663562737`*^9}, {3.854340280852212*^9, 
   3.854340287289242*^9}, {3.854340460470024*^9, 3.8543404681569595`*^9}, {
   3.8543448483226304`*^9, 3.854344858995262*^9}, {3.8543520909199543`*^9, 
   3.8543520925118856`*^9}, {3.8543525714679313`*^9, 3.854352577055113*^9}, {
   3.8543546542128577`*^9, 3.854354661981643*^9}, 3.854371446523744*^9, {
   3.8543750593918943`*^9, 3.854375060633313*^9}, 3.854376502464653*^9, {
   3.873704483949658*^9, 3.8737045235199747`*^9}, {3.873704831692937*^9, 
   3.8737048436765*^9}, {3.8737050712907543`*^9, 3.873705077563831*^9}}],

Cell["\<\
We show here the benchmark for the configuration same as in figure 16a of \
Horri & Nemat-Nasser, 1986. 
Note that negative stress indicates compression.\
\>", "Text",
 CellChangeTimes->{{3.873704526288099*^9, 3.8737045927574787`*^9}, {
  3.8737053142242413`*^9, 3.873705336533144*^9}, {3.8769021374124594`*^9, 
  3.876902142290245*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", "1."}], ";", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"we", " ", "set", " ", "c"}], "=", 
     RowBox[{"1", " ", "for", " ", "simplicity"}]}], ",", " ", 
    RowBox[{
    "this", " ", "value", " ", "will", " ", "be", " ", "canceled", " ", "in", 
     " ", "the", " ", "end"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]c1", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]21", "=", "0."}], ";"}]}], "Input",
 CellChangeTimes->{{3.8541703027791357`*^9, 3.854170303997772*^9}, {
  3.8541703607695017`*^9, 3.854170370753645*^9}, {3.873704943916587*^9, 
  3.87370496404139*^9}, {3.876902158445637*^9, 3.8769021675245895`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"definitionsTk", "[", "n", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "=", "s"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "=", "z"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fr", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Phi]r", "j"], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"F\[Theta]", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Phi]\[Theta]", "j"], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fp", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Phi]t", "j"], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lp", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ltlist", "=", 
    RowBox[{"{", 
     RowBox[{
     "0.01", ",", "0.1", ",", " ", "0.5", ",", " ", "1.", ",", " ", "2."}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]list", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.125", ",", "0.15", ",", "0.175", ",", "0.2", ",", "0.225", ",", 
       "0.25", ",", "0.275", ",", "0.3", ",", "0.325", ",", "0.35", ",", 
       "0.375", ",", "0.4", ",", "0.425", ",", "0.44"}], "}"}], "\[Pi]"}]}], 
   ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KIlist", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"ltlist", "//", "Length"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KIIlist", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", " ", 
     RowBox[{"ltlist", "//", "Length"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solutionarray", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"ltlist", "//", "Length"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8499071984640703`*^9, 3.8499072061211147`*^9}, {
   3.8499201306529756`*^9, 3.8499201336596923`*^9}, 3.8499203930843067`*^9, 
   3.849920558443282*^9, 3.8499215926681843`*^9, 3.84992380938896*^9, 
   3.8499309578256645`*^9, 3.850437578863394*^9, {3.8506185838952985`*^9, 
   3.8506185843414087`*^9}, 3.850629039538028*^9, 3.850629112713729*^9, 
   3.8506293987907743`*^9, 3.8506310825128593`*^9, {3.851026217764044*^9, 
   3.851026218092109*^9}, {3.854164546733497*^9, 3.8541645786116257`*^9}, {
   3.8541646111269107`*^9, 3.8541646137071185`*^9}, 3.854164664900714*^9, {
   3.854166120665*^9, 3.8541661207431197`*^9}, {3.8541673785064707`*^9, 
   3.8541673946350985`*^9}, 3.8541702849792995`*^9, {3.8541703295006065`*^9, 
   3.8541703392194433`*^9}, {3.85417043647781*^9, 3.854170438368258*^9}, {
   3.85418369525246*^9, 3.8541837259731436`*^9}, {3.8541844063606205`*^9, 
   3.854184469084223*^9}, {3.854184613615152*^9, 3.854184630209248*^9}, 
   3.854188155919411*^9, 3.85426093418404*^9, 3.854339965363141*^9, {
   3.854340482376213*^9, 3.8543405045971603`*^9}, {3.854340543175867*^9, 
   3.854340575100011*^9}, {3.854340695905264*^9, 3.8543406989831476`*^9}, {
   3.8543407701503882`*^9, 3.8543407999617167`*^9}, 3.8543714533981447`*^9, 
   3.8543734968217983`*^9, 3.8543765112786045`*^9, 3.8737050545277543`*^9}],

Cell[BoxData[
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"KI", "=", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{"0", ",", 
       RowBox[{"\[Theta]list", "//", "Length"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"KII", "=", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{"0", ",", " ", 
       RowBox[{"\[Theta]list", "//", "Length"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"solution", "=", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{"0", ",", " ", 
       RowBox[{"\[Theta]list", "//", "Length"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"lt", "=", 
     RowBox[{"ltlist", "[", 
      RowBox[{"[", "ilt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Theta]a", "=", 
        RowBox[{"\[Theta]list", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"term1", "=", 
        RowBox[{
         FractionBox["1", "lt"], " ", 
         RowBox[{"\[ScriptCapitalH]", ".", 
          RowBox[{"(", 
           RowBox[{"F\[Theta]", "+", 
            RowBox[{"I", " ", "Fr"}]}], ")"}]}], 
         RowBox[{"(", 
          FractionBox["1", "2"], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"term2", "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"L1", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}]}], "]"}],
              "&"}], "/@", "z"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Fr", " ", 
                 RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                RowBox[{"F\[Theta]", " ", 
                 RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "-", 
              RowBox[{"I", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Fr", " ", 
                  RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                 RowBox[{"F\[Theta]", " ", 
                  RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
             ")"}]}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"term3", "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"L2", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                   RowBox[{"Exp", "[", 
                    RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                   RowBox[{"Exp", "[", 
                    RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}]}], 
               "]"}], "&"}], "/@", "z"}], ")"}], ".", 
           RowBox[{"(", " ", 
            RowBox[{"wGC", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Fr", " ", 
                  RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                 RowBox[{"F\[Theta]", " ", 
                  RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "+", 
               RowBox[{"I", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Fr", " ", 
                   RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                  RowBox[{"F\[Theta]", " ", 
                   RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
              ")"}]}], ")"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"term4", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"2", " ", "\[Gamma]"}], "]"}], "+", 
              RowBox[{"\[Mu]", " ", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ")"}]}], "-", 
           RowBox[{
            FractionBox["1", "2"], "\[Mu]", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Sigma]21"}], ")"}]}], "+", "\[Tau]c1"}], 
          ")"}], 
         RowBox[{"(", 
          RowBox[{"S", "[", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              FractionBox[
               RowBox[{"(", 
                RowBox[{"z", "+", "1"}], ")"}], "2"], "lt", " ", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], "]"}], " ", 
          ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"term5", "=", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Sigma]21"}], ")"}]}], "-", 
         RowBox[{
          FractionBox["1", "2"], 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{"\[Gamma]", "-", "\[Theta]a"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"I", 
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{"Sin", "[", 
             RowBox[{"2", 
              RowBox[{"(", 
               RowBox[{"\[Gamma]", "-", "\[Theta]a"}], ")"}]}], "]"}], 
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Sigma]21"}], ")"}]}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"termboundary", "=", 
        RowBox[{"-", 
         RowBox[{"\[ScriptCapitalS]All", ".", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Fr", " ", 
             RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
            RowBox[{"F\[Theta]", " ", 
             RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"termK", "=", 
        RowBox[{"\[ScriptCapitalP]", ".", "Fr"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"term6", "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{"(", 
          RowBox[{"-", "I"}], ")"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Kp1", "[", 
              RowBox[{
               RowBox[{
                FractionBox[
                 RowBox[{"#", "+", "1"}], "2"], " ", "lt"}], ",", 
               RowBox[{
                FractionBox[
                 RowBox[{"(", 
                  RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], "]"}], 
             "&"}], "/@", "z"}], " ", ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", " ", "Fp"}], ")"}]}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"term7", "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{"(", "I", ")"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Kp2", "[", 
              RowBox[{
               RowBox[{
                FractionBox[
                 RowBox[{"#", "+", "1"}], "2"], " ", "lt"}], ",", 
               RowBox[{
                FractionBox[
                 RowBox[{"(", 
                  RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], "]"}], 
             "&"}], "/@", "z"}], " ", ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", " ", "Fp"}], ")"}]}]}]}], " ", ";", 
       "\[IndentingNewLine]", 
       RowBox[{"term8a", "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"L1", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], " ", 
                ")"}]}], "]"}], "&"}], "/@", "z"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "I"}], "  ", "Fp"}], ")"}]}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"term8b", "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"8", " ", "\[Pi]"}]], 
         RowBox[{
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"L2", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lt", " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}], ")"}], ",", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}], " ", 
                ")"}]}], "]"}], "&"}], "/@", "z"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"wGC", " ", 
            RowBox[{"(", 
             RowBox[{"I", "  ", "Fp"}], ")"}]}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Eqn1", "=", 
        RowBox[{"(", 
         RowBox[{
         "term1", "+", "term2", "+", "term3", "+", "term4", "+", "term5", "+",
           "term6", "+", "term7", "+", "term8a", "+", "term8b"}], ")"}]}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"terms1", "=", 
        RowBox[{
         FractionBox["1", "lp"], " ", 
         RowBox[{"\[ScriptCapitalH]", ".", 
          RowBox[{"(", 
           RowBox[{"I", " ", "Fp"}], ")"}]}], 
         RowBox[{"(", 
          FractionBox["1", "2"], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"terms2a", "=", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"8", " ", "\[Pi]"}]], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Ls1", "[", 
               RowBox[{
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}]}], "]"}], 
              "&"}], "/@", "u"}], ")"}], ".", 
           RowBox[{"(", 
            RowBox[{"wGC", 
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"-", "I"}], " ", "Fp"}], ")"}]}], ")"}]}]}], ")"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"terms2b", "=", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"8", " ", "\[Pi]"}]], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Ls2", "[", 
               RowBox[{
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
                RowBox[{"1", "+", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"(", 
                    RowBox[{"t", "+", "1"}], ")"}], "2"], "lp"}]}]}], "]"}], 
              "&"}], "/@", "u"}], ")"}], ".", 
           RowBox[{"(", 
            RowBox[{"wGC", 
             RowBox[{"(", 
              RowBox[{"I", " ", "Fp"}], ")"}]}], ")"}]}]}], ")"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"terms3", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"8", " ", "\[Pi]"}]], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Tp1", "[", 
                  RowBox[{
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}], ",", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt"}]}], "]"}], 
                 "&"}], "/@", "u"}], ")"}], ".", 
              RowBox[{"(", 
               RowBox[{"wGC", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "-", 
                  RowBox[{"I", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                 ")"}]}], ")"}]}]}], ")"}], "//", "Im"}], ")"}], "I"}]}], " ",
        ";", "\[IndentingNewLine]", 
       RowBox[{"terms4", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"8", " ", "\[Pi]"}]], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Tp2", "[", 
                  RowBox[{
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}], ",", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt"}]}], "]"}], 
                 "&"}], "/@", "u"}], ")"}], ".", 
              RowBox[{"(", 
               RowBox[{"wGC", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "+", 
                  RowBox[{"I", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                 ")"}]}], ")"}]}]}], ")"}], "//", "Im"}], ")"}], "I"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"terms5a", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"8", " ", "\[Pi]"}]], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Ls1", "[", 
                  RowBox[{
                   RowBox[{"1", "+", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}]}], " ", "]"}], 
                 "&"}], "/@", "u"}], ")"}], ".", 
              RowBox[{"(", 
               RowBox[{"wGC", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "-", 
                  RowBox[{"I", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                 ")"}]}], ")"}]}]}], " ", ")"}], "//", "Im"}], ")"}], "I"}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"terms5b", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"8", " ", "\[Pi]"}]], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Ls2", "[", 
                  RowBox[{
                   RowBox[{"1", "+", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"#", "+", "1"}], ")"}], "2"], "lp"}]}], ",", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"(", 
                    RowBox[{"s", "+", "1"}], ")"}], "2"], "lt", " ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", " ", "\[Theta]a"}], "]"}]}]}]}], " ", "]"}], 
                 "&"}], "/@", "u"}], ")"}], ".", 
              RowBox[{"(", 
               RowBox[{"wGC", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}], "+", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}]}], ")"}], "+", 
                  RowBox[{"I", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Fr", " ", 
                    RowBox[{"Cos", "[", "\[Theta]a", "]"}]}], "-", 
                    RowBox[{"F\[Theta]", " ", 
                    RowBox[{"Sin", "[", "\[Theta]a", "]"}]}]}], ")"}]}]}], 
                 ")"}]}], ")"}]}]}], " ", ")"}], "//", "Im"}], ")"}], "I"}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"terms6", "=", 
        RowBox[{"I", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sp", "[", 
              RowBox[{
               FractionBox[
                RowBox[{"(", 
                 RowBox[{"u", "+", "1"}], ")"}], "2"], "lp"}], "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "2"], 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Sin", "[", 
                   RowBox[{"2", " ", "\[Gamma]"}], "]"}], "+", 
                  RowBox[{"\[Mu]", " ", 
                   RowBox[{"Cos", "[", 
                    RowBox[{"2", "\[Gamma]"}], "]"}]}]}], ")"}]}], "-", 
               RowBox[{
                FractionBox["1", "2"], "\[Mu]", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Sigma]21"}], ")"}]}], "+", "\[Tau]c1"}],
               ")"}]}], ")"}], "//", "Im"}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"terms7", "=", 
        RowBox[{"I", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Sigma]21"}], ")"}], 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "\[Gamma]"}], "]"}]}], "+", "\[Tau]Y1"}], 
          ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"termsK", "=", 
        RowBox[{"\[ScriptCapitalQ]", ".", "Fp"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"termsK2", "=", 
        RowBox[{"\[ScriptCapitalP]", ".", "Fp"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Eqn2", "=", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"{", "termboundary", "}"}], ",", 
           RowBox[{"{", "termK", "}"}], ",", 
           RowBox[{"{", "termsK2", "}"}], ",", 
           RowBox[{"{", "termsK", "}"}]}], "]"}], "//", "N"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"RealEqns", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"Eqn1", ",", "Eqn2"}], "]"}], "//", "Re"}], "//", 
         "ComplexExpand"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"ImaginaryEqns", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"Eqn1", ",", " ", "Eqn2"}], "]"}], "//", "Im"}], "//", 
         "ComplexExpand"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Eqns3", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"(", 
            RowBox[{
            "terms1", "+", "terms2a", "+", "terms2b", "+", "terms3", "+", 
             "terms4", "+", "terms5a", "+", "terms5b", "+", "terms6", "+", 
             "terms7"}], ")"}], ")"}], "//", "Im"}], "//", 
         "ComplexExpand"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"sol", "=", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"RealEqns", ",", 
             RowBox[{"Drop", "[", 
              RowBox[{"ImaginaryEqns", ",", 
               RowBox[{"-", "4"}]}], "]"}], ",", "Eqns3"}], "]"}], "\[Equal]",
            "0"}], ",", 
          RowBox[{"Join", "[", 
           RowBox[{"Fr", ",", "F\[Theta]", ",", "Fp", ",", 
            RowBox[{"{", "\[Tau]Y1", "}"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"KI", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["1", 
            RowBox[{"2", 
             SqrtBox["2"]}]], 
           SuperscriptBox[
            RowBox[{"(", "lt", ")"}], 
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}]], 
           RowBox[{"(", 
            RowBox[{"\[ScriptCapitalQ]", ".", "F\[Theta]"}], ")"}]}], "/.", 
          "sol"}], "//", "Flatten"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"KII", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["1", 
            RowBox[{"2", 
             SqrtBox["2"]}]], 
           SuperscriptBox[
            RowBox[{"(", "lt", ")"}], 
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}]], 
           RowBox[{"(", 
            RowBox[{"\[ScriptCapitalQ]", ".", "Fr"}], ")"}]}], "/.", "sol"}], 
         "//", "Flatten"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"solution", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"sol", "//", "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"\[Theta]list", "//", "Length"}]}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"KIlist", "[", 
      RowBox[{"[", "ilt", "]"}], "]"}], "=", 
     RowBox[{"KI", "//", "Flatten"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"KIIlist", "[", 
      RowBox[{"[", "ilt", "]"}], "]"}], "=", 
     RowBox[{"KII", "//", "Flatten"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"solutionarray", "[", 
      RowBox[{"[", "ilt", "]"}], "]"}], "=", "solution"}], ";"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"ilt", ",", "1", ",", 
     RowBox[{"ltlist", "//", "Length"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8506217672349305`*^9, 3.850621982315235*^9}, {
   3.850622692809865*^9, 3.8506227482232227`*^9}, {3.850622782264515*^9, 
   3.8506228139096622`*^9}, {3.8506228664080906`*^9, 3.8506230314704404`*^9}, 
   3.850623234448207*^9, {3.85102610830443*^9, 3.851026182268131*^9}, {
   3.854164621302312*^9, 3.854164681979745*^9}, {3.854165988730116*^9, 
   3.854166028785035*^9}, {3.8541661078678627`*^9, 3.854166135222126*^9}, {
   3.8541714836068354`*^9, 3.854171513331713*^9}, {3.8541837354264164`*^9, 
   3.8541837695113907`*^9}, {3.854183961330988*^9, 3.854184030900937*^9}, {
   3.854184363791024*^9, 3.854184389737238*^9}, {3.8541845178406415`*^9, 
   3.854184518380669*^9}, {3.854185030862837*^9, 3.854185045405117*^9}, {
   3.8541854601672387`*^9, 3.854185460401596*^9}, {3.8541855506311097`*^9, 
   3.854185581304985*^9}, {3.8541857454403086`*^9, 3.85418579257215*^9}, {
   3.8541858275723286`*^9, 3.8541858319712987`*^9}, {3.854185868790475*^9, 
   3.8541858828935986`*^9}, {3.854186302627014*^9, 3.854186306341547*^9}, {
   3.85418755133519*^9, 3.8541875617766037`*^9}, 3.8541876554271307`*^9, {
   3.8541877071918583`*^9, 3.854187718151737*^9}, {3.8541877707810388`*^9, 
   3.8541877731986465`*^9}, 3.854187849870449*^9, 3.8542603250319834`*^9, {
   3.854339975707511*^9, 3.854339980238431*^9}, {3.8543406078200455`*^9, 
   3.854340647104227*^9}, {3.854340680998604*^9, 3.854340753114394*^9}, {
   3.854340805680044*^9, 3.854340858896145*^9}, {3.854344202298917*^9, 
   3.854344210331045*^9}, {3.854352191341997*^9, 3.85435225322605*^9}, {
   3.855205672583819*^9, 3.855205730041422*^9}, {3.8552058369036627`*^9, 
   3.8552058606284304`*^9}, {3.873624181414193*^9, 3.8736241819419317`*^9}, {
   3.8737046956504755`*^9, 3.8737047000969615`*^9}, {3.8737047377749434`*^9, 
   3.8737047398824797`*^9}, {3.873704780943369*^9, 3.87370478922183*^9}, {
   3.873704861623298*^9, 3.8737049211763535`*^9}, {3.873705165930274*^9, 
   3.873705192346811*^9}, {3.873705265375574*^9, 3.8737052744758463`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ListPlot", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Theta]list", "/", "\[Pi]"}], " ", "180"}], ",", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"KIlist", "[", 
               RowBox[{"[", "#", "]"}], "]"}]}], "//", "Flatten"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
         RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"1", "/", "6"}], "*", "180"}], ",", 
              RowBox[{
               RowBox[{"4", "/", "9"}], "*", "180"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.", ",", "0.4"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", " ", "Black"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", 
          RowBox[{"4", "/", "3"}]}]}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"ltlist", "//", "Length"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Theta]/deg\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(K\), \(I\)]\)/[|\!\(\*SubscriptBox[\(\
\[Sigma]\), \(1\)]\)|(\[Pi]c\!\(\*SuperscriptBox[\()\), \(1/2\)]\)]\>\""}], 
       "}"}]}], ",", 
     RowBox[{"RotateLabel", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ListPlot", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Theta]list", "/", "\[Pi]"}], " ", "180"}], ",", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"KIIlist", "[", 
               RowBox[{"[", "#", "]"}], "]"}]}], "//", "Flatten"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
         RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"1", "/", "6"}], "*", "180"}], ",", 
              RowBox[{
               RowBox[{"4", "/", "9"}], "*", "180"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.", ",", "0.4"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", " ", "Black"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", 
          RowBox[{"4", "/", "3"}]}]}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"ltlist", "//", "Length"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Theta]/deg\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(K\), \(II\)]\)/[|\!\(\*SubscriptBox[\(\
\[Sigma]\), \(1\)]\)|(\[Pi]c\!\(\*SuperscriptBox[\()\), \(1/2\)]\)]\>\""}], 
       "}"}]}], ",", 
     RowBox[{"RotateLabel", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{
  3.8541845738426075`*^9, {3.854184637505865*^9, 3.8541846590780134`*^9}, {
   3.854184908278055*^9, 3.8541849297228107`*^9}, {3.854188111535075*^9, 
   3.8541881260742064`*^9}, {3.8543401383793755`*^9, 3.854340144664806*^9}, {
   3.8543401934784656`*^9, 3.8543402144674325`*^9}, {3.8543408815228367`*^9, 
   3.8543409101951923`*^9}, {3.854340994327992*^9, 3.8543411021503987`*^9}, 
   3.8543519423696203`*^9, {3.8737047430076475`*^9, 3.873704745032939*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{22.5, 0.1135518276927149}, {27., 
         0.14402623132215295`}, {31.500000000000004`, 0.17324489267912707`}, {
         36., 0.2008542452977777}, {40.5, 0.2265549187255827}, {45., 
         0.2500397697941054}, {49.50000000000001, 0.270967888972002}, {54., 
         0.2889458065218983}, {58.5, 0.30350462001387407`}, {
         63.00000000000001, 0.31406307963977076`}, {67.5, 
         0.31984877663386363`}, {72., 0.3196723250490841}, {76.5, 
         0.3111056485000835}, {79.2, 
         0.29932858876599855`}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{22.5, 0.07295876907238318}, {27., 
         0.10567948655562388`}, {31.500000000000004`, 0.13601094254588228`}, {
         36., 0.16361329386477869`}, {40.5, 0.18816088213910748`}, {45., 
         0.20933154193464237`}, {49.50000000000001, 0.2267991279688036}, {54.,
          0.2402304609843057}, {58.5, 0.24928556595174642`}, {
         63.00000000000001, 0.2536162068090988}, {67.5, 
         0.25284665734301426`}, {72., 0.24648497099435984`}, {76.5, 
         0.2335672445712779}, {79.2, 
         0.22161485979554538`}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{22.5, 0.004906935083840468}, {27., 
         0.0455062860984843}, {31.500000000000004`, 0.08079788916068129}, {
         36., 0.1101825345144666}, {40.5, 0.13316036443359727`}, {45., 
         0.14932709791774296`}, {49.50000000000001, 0.15837123041200857`}, {
         54., 0.16007123319136035`}, {58.5, 0.15428849576159795`}, {
         63.00000000000001, 0.1409449572225668}, {67.5, 
         0.11995234733202483`}, {72., 0.09098288973671691}, {76.5, 
         0.052615765295650964`}, {79.2, 
         0.022862034047190234`}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], 
        LineBox[{{25.9550995821328, 0.}, {27., 0.01121191804600113}, {
         31.500000000000004`, 0.051490467722119494`}, {36., 
         0.08296921153352278}, {40.5, 0.1050001905768422}, {45., 
         0.11708918057392731`}, {49.50000000000001, 0.11890805663325318`}, {
         54., 0.11030167010310074`}, {58.5, 0.09128077678828171}, {
         63.00000000000001, 0.061980920848953014`}, {67.5, 
         0.02252725244428706}, {69.53031159628532, 
         0.}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{29.60785629067131, 0.}, {31.500000000000004`, 
         0.02065488983760081}, {36., 0.056691028963100354`}, {40.5, 
         0.07871734120951097}, {45., 0.08608866781706413}, {49.50000000000001,
          0.07846523179940523}, {54., 0.055829808182880705`}, {58.5, 
         0.018475065778032367`}, {60.11258956898504, 
         0.}}]}}, {}, {}, {{}, {}}}},
    AspectRatio->NCache[
      Rational[4, 3], 1.3333333333333333`],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{30.25, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{
      FormBox["\"\[Theta]/deg\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(K\\), \
\\(I\\)]\\)/[|\\!\\(\\*SubscriptBox[\\(\[Sigma]\\), \\(1\\)]\\)|(\[Pi]c\\!\\(\
\\*SuperscriptBox[\\()\\), \\(1/2\\)]\\)]\"", TraditionalForm]},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->400,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{30, 80}, {0., 0.4}},
    PlotRangeClipping->True,
    PlotRangePadding->{{0, 0}, {0, 0}},
    RotateLabel->True,
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{78.36757474769787, 0.}, {79.2, 
         0.00596389722544678}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{71.213253486607, 0.}, {72., 0.005952955712965456}, {
         76.5, 0.03902964954090059}, {79.2, 
         0.058227348594610075`}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{59.90717936028702, 0.}, {63.00000000000001, 
         0.03264156563469053}, {67.5, 0.07756807108671038}, {72., 
         0.11904564153109848`}, {76.5, 0.15633542981901938`}, {79.2, 
         0.1765473762791909}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{54.396716626888775`, 0.}, {58.5, 
         0.05818383564909428}, {63.00000000000001, 0.11839269368256582`}, {
         67.5, 0.1736632221621598}, {72., 0.222821932423768}, {76.5, 
         0.2650830420010779}, {79.2, 
         0.2872362416798959}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{{50.165999523787384`, 0.}, {54., 
         0.07750506098850654}, {58.5, 0.16393065986147454`}, {
         63.00000000000001, 0.24359846078782352`}, {67.5, 
         0.31446638658259807`}, {72., 0.37482128212908716`}, {
         74.32064553208642, 0.4}}]}}, {}, {}, {{}, {}}}},
    AspectRatio->NCache[
      Rational[4, 3], 1.3333333333333333`],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{30.25, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{
      FormBox["\"\[Theta]/deg\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(K\\), \\(II\\)]\\)/[|\\!\\(\\*SubscriptBox[\
\\(\[Sigma]\\), \\(1\\)]\\)|(\[Pi]c\\!\\(\\*SuperscriptBox[\\()\\), \
\\(1/2\\)]\\)]\"", TraditionalForm]},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->400,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{30, 80}, {0., 0.4}},
    PlotRangeClipping->True,
    PlotRangePadding->{{0, 0}, {0, 0}},
    RotateLabel->True,
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8541849088248916`*^9, 3.8541849305821314`*^9}, 
   3.8541852316662827`*^9, 3.854186167107169*^9, 3.85418658362332*^9, 
   3.8541880659114065`*^9, 3.8541881265803623`*^9, {3.8541883631844516`*^9, 
   3.8541883683515787`*^9}, 3.854257754958194*^9, 3.85426070451075*^9, 
   3.8543401052929435`*^9, 3.854340145096017*^9, 3.854340216217291*^9, 
   3.854344476097831*^9, {3.8543519372077208`*^9, 3.85435194584295*^9}, 
   3.854352451085534*^9, 3.8543527571425867`*^9, 3.8543749450220995`*^9, 
   3.8543777560691986`*^9, 3.855206794638213*^9, 3.864186993037809*^9, 
   3.87370808550136*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1536, 821},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (October 8, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 652, 11, 70, "Section"],
Cell[1235, 35, 10962, 248, 674, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[12234, 288, 119, 2, 70, "Section"],
Cell[12356, 292, 5580, 155, 183, "Input",
 InitializationCell->True],
Cell[17939, 449, 3795, 126, 210, "Input",
 InitializationCell->True],
Cell[21737, 577, 3306, 105, 221, "Input",
 InitializationCell->True],
Cell[25046, 684, 3088, 100, 179, "Input",
 InitializationCell->True],
Cell[28137, 786, 222, 4, 30, "Input"],
Cell[28362, 792, 28149, 738, 1481, "Input",
 InitializationCell->True],
Cell[56514, 1532, 15029, 361, 969, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[71580, 1898, 1428, 20, 70, "Section"],
Cell[73011, 1920, 347, 7, 49, "Text"],
Cell[73361, 1929, 893, 21, 107, "Input"],
Cell[74257, 1952, 3621, 90, 324, "Input"],
Cell[77881, 2044, 27947, 723, 1392, "Input"],
Cell[CellGroupData[{
Cell[105853, 2771, 3777, 95, 103, "Input"],
Cell[109633, 2868, 8130, 152, 530, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

