function [ outcode ] = run_lamp_simulation(LAMP)
%% Run Simulation
    %tic
    
    
    fprintf('\nStarting Simulation')
    
    switch LAMP.os
        case 'win' % inherited from Kevin
            lamprun = [LAMP.binary_path, 'lamp.exe ', LAMP.filename_root];
            
            startInfo = System.Diagnostics.ProcessStartInfo('cmd.exe', sprintf('/c "%s"', lamprun));
            startInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
            proc = System.Diagnostics.Process.Start(startInfo);
            
            if isempty(proc)
                error('\nSimulation Failed to Launch');
            end
            while true
                if proc.HasExited
                    fprintf('\nSimulation Complete\n');
                    break
                end
                fprintf('.');
                pause(LAMP.sleep_time);
            end
    
    
        case 'linux'
            lamprun = [LAMP.binary_path, 'lamp ', LAMP.filename_root];          
            command = lamprun;
            [status,cmdout] = system(command);
            
            %fprintf(status)
            
            if LAMP.verbose >= 2
                fprintf(cmdout)
            end
    end

    

    
    
    %toca = toc
    %timestamp(n) = toca;
    
    outcode = 1;
end

