function [ output_struct ] = process_data(LAMP, suffix)
%% Data Processing

%
% Produces a struct Output with the following fields:
%
% mot_time - time stamps for the time series mot_M_y, Z_pos, and Y_rot
% mot_M_y  - time series for the total VBM not including slamming
% Z_pos    - time series of the ship vertical displacement
% Y_rot    - time series of the ship pitch angle
%
% slam_time - time stamps for the time series slam_M_y_1, slam_M_y_2, and
%               slam_M_y_3
% slam_M_y_1 - time series of the slamming induced VBM at a location (1)
% slam_M_y_2 - time series of the slamming induced VBM at a location (2)
% slam_M_y_3 - time series of the slamming induced VBM at a location (3)
%
% tot_VBM_time - time stamps for the time series tot_M_y_1, tot_M_y_2, and
%               tot_M_y_3
% tot_M_y_1 - time series of the total VBM at a location (1)
% tot_M_y_2 - time series of the total VBM at a location (2)
% tot_M_y_3 - time series of the total VBM at a location (3)
%

    fprintf('\nProcessing Data')
    
    %
    % process the total VBM
    %

    fid = fopen([LAMP.filename_root,'_ftot.out']);

    line = fgetl(fid);
    line = fgetl(fid);
    line = fgetl(fid);
    
    
    n = 0;

    while ~feof(fid)

        n = n + 1;
        line = strsplit(strtrim(fgetl(fid)));
        Output.mot_time(n) = str2double(line{1});
        Output.mot_M_y(n) = str2double(line{6});  

    end

    fid = fclose(fid);
    
    %
    % process the kinematics
    %

    fid = fopen([LAMP.filename_root,'_mot.out']);

    line = fgetl(fid);
    line = fgetl(fid);
    line = fgetl(fid);
    n = 0;

    while ~feof(fid)

        n = n + 1;
        line = strsplit(strtrim(fgetl(fid)));
        Output.Z_pos(n) = str2double(line{4}); 
        Output.Y_rot(n) = str2double(line{6});  

    end

    fid = fclose(fid);

    %
    % process the slamming VBM
    %
    
    slam_filename = [LAMP.filename_root,'_wav.out'];
     
    if exist(slam_filename, 'file')

        fid = fopen([LAMP.filename_root,'.vbmi']);

        line = fgetl(fid);
        line = fgetl(fid);
        line = fgetl(fid);
        line = fgetl(fid); % extra header line

        n = 0;

        while ~feof(fid)

            n = n + 1;
            line = strsplit(strtrim(fgetl(fid)));
            Output.slam_time(n) = str2double(line{1});
            Output.slam_M_y_1(n) = str2double(line{2});
            Output.slam_M_y_2(n) = str2double(line{3});
            Output.slam_M_y_3(n) = str2double(line{4}); 

        end


        fid = fopen([LAMP.filename_root,'.vbmt']);

        line = fgetl(fid);
        line = fgetl(fid);
        line = fgetl(fid);
        line = fgetl(fid);  % extra header line

        n = 0;

        while ~feof(fid)

            n = n + 1;
            line = strsplit(strtrim(fgetl(fid)));
            Output.tot_VBM_time(n) = str2double(line{1});
            Output.tot_M_y_1(n) = str2double(line{2});
            Output.tot_M_y_2(n) = str2double(line{3});
            Output.tot_M_y_3(n) = str2double(line{4}); 

        end

        fid = fclose(fid);
    end


    fprintf('\nData Processed\n');
    filename = [LAMP.output_path, 'Output_', suffix, '.mat'];

    
    save(filename, 'Output');

    output_struct = Output;
end

