function [ zz_next ] = gpe_extrapolate(zz_in, B, sig, n_steps)
%GPE_EXTRAPOLATE Summary of this function goes here
%   Detailed explanation goes here

    nM = length(B);
    
    zz_next = zeros(n_steps + length(zz_in), 1);
    zz_next((length(zz_next)-length(zz_in) + 1):end) = zz_in;
    
    for k = 1:n_steps
        prev_i = n_steps + 2 - k;
        cur_i = n_steps + 1 - k;
        final_i = min(prev_i + nM - 1, length(zz_next));
        
        s = zz_next(prev_i:final_i);
        m = 0;
        
        L = length(s);
        bb = 1:L;
        mu = 0 + B(bb)*flipud(s - m);
        
        s_new = mu + randn().*sig;
        zz_next(cur_i) = real(s_new);
    end
end

