function [ outcode ] = generate_data(LAMP)
%% Generate Data

     fprintf('\nGenerating Data\n')

    switch LAMP.os
        case 'win' % inherited from Kevin
            lmplot = [LAMP.binary_path, 'lmplot.exe -s get_motion.scpt -root ', LAMP.filename_root];
            startInfo = System.Diagnostics.ProcessStartInfo('cmd.exe', sprintf('/c "%s"', lmplot));
            startInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
            proc = System.Diagnostics.Process.Start(startInfo);

            if isempty(proc)
                error('\nFailed to launch process');
            end
            while true
                if proc.HasExited
                    fprintf('\nData Generation Complete\n');
                    break
                end
                fprintf('.');
                pause(LAMP.sleep_time);
            end
        case 'linux'
            lmplot = [LAMP.binary_path, 'lmplot -s get_motion.scpt -root ', LAMP.filename_root];
            command = lmplot;
            [status,cmdout] = system(command);
            
            %fprintf(status)
            
            if LAMP.verbose >= 2
                fprintf(cmdout)
            end
    end
    
    outcode = 1;

end

