function [ W, A, phi ] = discretize_scsp_signal( l_par, gpe_par, Xi, dt )
%DISCRETIZE_SCSP_SIGNAL Summary of this function goes here
%   Detailed explanation goes here


    %
    % FFT for sinusoids!
    %
    
    YY = Xi(:)';
    
    YYr = [YY, fliplr(YY)];
       
    k_shift =  gpe_par.n_var_length + 0;
    %k_shift = 0;
    
    YYrs = circshift(YYr, k_shift);
    zz = fft(YYrs);
    
    nt = length(zz);
    %wn = 2*pi/nt;
    a0 = zz(1);  % we're going to ignore this, and assume the sea state is
                 % zero mean
    aa = zz(2:floor(nt/2)) + fliplr(zz((ceil(nt/2)+2):end));
    bb = zz(2:floor(nt/2)) - fliplr(zz((ceil(nt/2)+2):end));

    mm = 1:(floor(nt/2) - 1);
    W = 2*pi/nt.*mm/dt;
    A = 1/nt*sqrt(abs(aa).^2 + abs(bb).^2);
    phi =  atan2(real(1i*bb), real(aa));
   
    max_sinusoids = l_par.nfreq;
    [~, I] = maxk(A, max_sinusoids);
    
    W = W(I);     % regularly spaced fft frequencies
    A = A(I);     % positve amplitudes
    phi = phi(I); % phase offsets
    
    
    
    %W = W(1:max_sinusoids);     % regularly spaced fft frequencies
    %A = A(1:max_sinusoids);     % positve amplitudes
    %phi = phi(1:max_sinusoids); % phase offsets
    
end

