function [ outcode ] = create_input_file(~, LAMP, wave_freq, A, phi_deg)
%% Create LAMP Input File

    inputfilename = [LAMP.filename_root, '.in'];
    %movefile(inputfilename, 'input.in');

    fid = fopen(LAMP.template_path,'r');
    gid = fopen(inputfilename,'w');

    while ~feof(fid)

        line = fgetl(fid);

        if strcmp(line, '!05 FOUT - Destination file for primary output') == 1

            fprintf(gid, '%s\n', line);
            fprintf(gid, '%s.out\n', LAMP.filename_root);
            line = fgetl(fid);

        elseif strcmp(line, '!14 TINIT NSTEP DTH IRST - Initial Time, Number of Steps, Time Step, Restart') == 1

            fprintf(gid, '%s\n', line);
            fprintf(gid, '     %g   %g %g   0\n', LAMP.initial_time, LAMP.nstep, LAMP.timestep);
            line = fgetl(fid);

        elseif strcmp(line, '!16 PMGIN(1:6) Initial position and orientation in global frame') == 1

            fprintf(gid, '%s\n',line);
            fprintf(gid, '  %g       0.00000       %g\n', LAMP.xstart, LAMP.z_pos_init);
            fprintf(gid, '  0.00000     %g         0.00000       \n', LAMP.y_rot_init);
            line = fgetl(fid);
            line = fgetl(fid);
            
        elseif strcmp(line, '!17 VMGSHP(1:6) Initial Velocity and Rotation rate in ship fixed system') == 1
            fprintf(gid, '%s\n',line);
            fprintf(gid, '  %g       0.00000       %g\n', LAMP.xvelstart, LAMP.z_vel_init);
            fprintf(gid, '  0.00000     %g         0.00000       \n', LAMP.y_drot_init);
            line = fgetl(fid);
            line = fgetl(fid);
            
            
        elseif strcmp(line, '!21 ISEA  NWAVES  NWSC') == 1

            fprintf(gid, '%s\n', line);
            fprintf(gid, '     1   %g        2\n', LAMP.nfreq);
            line = fgetl(fid);

        elseif strcmp(line, '!21 (cont) FREQW   PHASEW   AMPW   HEADW ') == 1

            fprintf(gid, '%s\n', line);
            for k = 1:LAMP.nfreq
                fprintf(gid, '     %g   %g   %g   180.0 \n', wave_freq(k), phi_deg(k), A(k));
            end
            line = fgetl(fid);
            
         elseif strcmp(line, '!21 (cont) WSCSTP  WSCFAC = wave scaling data') == 1
             
             fprintf(gid, '%s\n', line);
             fprintf(gid, '     %g   0.0 \n', LAMP.initial_time- 1);
             fprintf(gid, '     %g   1.000\n', LAMP.final_ramp_time);
             line = fgetl(fid);
 
        else

            fprintf(gid, '%s\n', line);

        end

    end

    fid = fclose(fid);
    fid = fclose(gid);
    
    outcode = 1;
end

