function [ sig, B ] = calc_gpe_coeff(gpe_par, R_fun, dt)
%CALC_GPE_COEFF Summary of this function goes here
%   Detailed explanation goes here
    
    nM = gpe_par.n_memory;
    
    TT = (0:1:(nM))*dt;
    
    RR = R_fun(TT);
    
    % cut off the memory length when the autocorr is gone anyway
    Reps = 1e-5;
    Rl = find(abs(RR) > Reps, 1, 'last');  
    
    nM = min(nM, Rl);
   
    
    switch gpe_par.arma_alg
        case 'direct'
    
            R0 = RR(1);
            R_trunc = RR(1:nM);
            S = toeplitz(R_trunc);
            S_inv = inv(S);
            %S_row = fliplr(RR(2:(nM+1)));
            S_row = RR(2:(nM+1));

            sig2 = R0 - S_row*(S\(S_row'));
            sig = sqrt(sig2);

            B = S_row/S;

            
        case 'levinson'
            [a,e,k] = levinson(RR, nM);
            
            %B = -fliplr(a(2:end));
            B = -a(2:end);
            
            sig = sqrt(e);
            
            
        otherwise
            warnging('%s not recognized!\n', gpe_par.arma_alg)
    end
    
end

