function [ V_out, D_out ] = calc_direct_kl_modes(AA, WW, TT)
%CALC_DIRECT_KL_MODES Summary of this function goes here
%   Detailed explanation goes here
    

    n_copies = 2e4;

    zz = zeros(n_copies, length(TT));
    dw = WW(2) - WW(1);
    
    for k = 1:n_copies
        phi = 2*pi*rand(size(WW));
        WWtwi = dw*rand(size(WW));
        zz(k, :) = sum(AA.*cos((WW + WWtwi)*TT + phi), 1);
    end
    
    
    zz_mu = mean(zz, 1);
    zz_res = zz - repmat(zz_mu, [n_copies, 1]);
    
    CC = (zz_res')*(zz_res) / n_copies;
    
    [V,D] = eig(CC, 'vector');
    
    V_out = fliplr(V);
    D_out = flipud(D);
    

end

