function [ R_fun ] = calc_autocorrelation_fft( S_fun )
%CALC_AUTOCORRELATION_FFT Summary of this function goes here
%   Detailed explanation goes here

    n_f = 1e5;

    w_max = 40;
    W = linspace(-w_max, w_max, n_f);
    dw = W(2) - W(1);
    
    S = S_fun(W);
    R = w_max*ifftshift(ifft(fftshift(S), 'symmetric'));
    
    T_max = 1/(2*dw);
    Tp = 2*pi*linspace(-T_max, T_max, n_f-1);
    
    R_fun = @(t) interp1(Tp, R(2:end), t);
    
    %TT = (0:dt:100);
    %RR = real(R_fun(TT));

   
end
