function [ YY ] = build_scsp_signal( gpe_par, kl_var, kl_modes, B, sig, alpha )
%BUILD_SCSP_SIGNAL Summary of this function goes here
%   Detailed explanation goes here    
    
 
    %
    % Reconstruct the KL fixed region
    %
    
    
    YY1 = zeros([1, size(kl_modes, 1)]);
    
    for k = 1:length(alpha)
        mag = alpha(k).*sqrt(kl_var(k));
        YY1 = YY1 + mag.*kl_modes(:, k)';
    end
    
    %
    % GP Extrapolation
    %
    
    %[ YY ] = transpose(gp_extrapolate_signal(gpe_par, R, YY1 ));  
    
    YY1 = transpose(YY1);
    
    if gpe_par.extrap_backward
        nV = gpe_par.n_var_length;
        B_back = fliplr(B);
        zz_in = flipud(YY1);
        [ zz_out ] = gpe_extrapolate(zz_in, B_back, sig, nV);
        YY2 = flipud( zz_out );
    else
        YY2 = YY1;
    end
    
    if gpe_par.extrap_forward
        nV = gpe_par.n_var_length;
        zz_in = YY2;
        [ zz_out ] = gpe_extrapolate(zz_in, B_back, sig, nV);
        YY = zz_out ;
    else
        YY = YY2;
    end
    
    %smooth_dist = 5;
    %x1 = YY(smooth_dist);
    %x2 = YY(end - smooth_dist + 1);
    %
    %xx = linspace(x1, x2, 2*smooth_dist);
    %YY(1:smooth_dist) = xx(1:smooth_dist);
    %YY((end-smooth_dist+1):end) = xx(end:-1:(smooth_dist+1));
    
    
end

