classdef LAMP_Parameters < handle
    %LAMP_PARAMETERS Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        initial_time;
        time;
        timestep
        nstep;
        
        z_pos_init;
        y_rot_init;
        z_vel_init;
        y_drot_init;
        
        final_ramp_time;
        
        nfreq;
        seed;
        
        Simulation;
        
        xstart;
        xvelstart;
        
        filename_root;
        output_path;
        binary_path;
        template_path;
        
        sleep_time;

        n_simulation;
        
        os;
        verbose;
    end
    
    methods
        function par = LAMP_Parameters(seed, n, os)

            par.initial_time = 0;
            par.time = 1860;
            par.timestep = 0.1;
            par.nstep = floor((par.time - par.initial_time)/ par.timestep);
            
            par.z_pos_init = 0;
            par.y_rot_init = 0;
            par.z_vel_init = 0;
            par.y_drot_init = 0;
            
            
            
            par.final_ramp_time =  par.initial_time;
            
            
            % Primary Input Argument

            par.nfreq = 250; % Number of Frequencies in Simulation
            par.seed = seed; % Random number seed integer for phase angles
            
            par.Simulation = 2;
            % 0 = LAMP_0 Simulation
            % 2 = LAMP_2 Simulation
            
            par.xstart = 0;
            par.xvelstart = 5.144;
            

            
            par.sleep_time = 10;
            
            par.n_simulation = n;
            
            if (nargin == 3)
                par.os = os;
            else
                par.os = 'win';
            end
            
            switch par.os
                case 'win'
                    par.filename_root = ['..\..\..\Data\LAMP\Window_Test\JONSWAP_time', ...
                        num2str(par.time), '_seed', num2str(par.seed)];
                    %par.filename_root = ['JONSWAP_time', num2str(par.time), '_seed', num2str(par.seed)];
                    par.output_path =  '..\..\..\Data\LAMP\Test_Data\';
                    par.binary_path = 'lamp_binaries\';
                    par.template_path = 'lamp_templates\Template_sj.in';
                case 'linux'
                    %par.filename_root = ['../../../Data/LAMP/Test_Data/JONSWAP_time', ...
                    %    num2str(par.time), '_seed', num2str(par.seed)];
                    %par.filename_root = ['JONSWAP_time', num2str(par.time), '_seed', num2str(par.seed)];
                    %par.output_path =  '../../../Data/LAMP/Test_Data/';
                    %par.binary_path = './lamp_binaries/';
                    %par.template_path = './lamp_templates/Template_sj.in';
                    
                    par.filename_root = ['JONSWAP_time', ...
                        num2str(par.time), '_seed', num2str(par.seed)];
                    %par.filename_root = ['JONSWAP_time', num2str(par.time), '_seed', num2str(par.seed)];
                    par.output_path =  '';
                    par.binary_path = 'lamp_binaries/';
                    par.template_path = 'lamp_templates/Template_sj.in';
            end
            
            par.verbose = 0;
        end
        
    end
end

