fprintf('Beginning LAMP data postprocessing step.\n');
fprintf('This step is designed to be run on sandlab,\n');
fprintf('and is designed to produce ascii files for easy networking.\n');




fixed_T = 40;       % length of wave episode
n_modes = 4;        % number of retained wave episode modes

output_path = sprintf('/output/deepo-%d-%d/', fixed_T, n_modes);
control_filenam = sprintf('%scontrol.mat', output_path);

os = 'linux';

file_prefix = sprintf('run-%d-%d-out', n_modes, fixed_T);

n_exp = 10;

Y_rot = cell(n_exp, 1);
VBM_global = cell(n_exp, 1);
is_Good = zeros(n_exp, 1);

%
% Because the ship is a Lagrangian tracer, but the fixed region is defined
% in the Eulerian frame, we have to be careful where we cut the ship data
% records.
% First, we need to know the LENGTH_ADJUSTMENT_FACTOR between Lagrangian
% frame and Eulerian frame, which is 35/80 for the ship velocity in Guth
% and Sapsis (2022).
% Second, we need to know where/when the fixed region is located.  In Guth
% and Sapsis (2022), it ends at t=0.
%

T_cut_start = -35/80*cur_t;
T_cut_end = -0;

default_good_times = 0;


k_save = 0;

for k_next = 1:n_exp
    fprintf('Starting %d.', k_next);

    k_save = k_save+1;

    suffix = sprintf('run-%d-%d-out', k_next, 1);
    filename = [output_path_list{k_exp}, 'Output_', suffix, '.mat'];
    if exist(filename, 'file')
        load(filename, 'Output');


        TT1 = Output.mot_time;
        mm1 = (TT1 > T_cut_start) & (TT1 < T_cut_end);

        if (k_next == 1)
            default_good_times = sum(mm1);
        end

        if (sum(mm1) == default_good_times)
            is_Good(k_save) = 1;

            Y_rot{k_save} = Output.Y_rot(mm1);
            VBM_global{k_save} = Output.mot_M_y(mm1);

        else
            is_Good(k_save) = 0;

            Y_rot{k_save} = zeros(1, default_good_times);
            VBM_global{k_save} = zeros(1, default_good_times);
        end


        fclose('all');
        fprintf('  Saw %d good times.\n', sum(mm1));
    else
        fprintf('%s doesn''t exist!\n', filename);
    end
end


X_design_list = cell(1, 1);

for k_exp = 1:length(control_filename_list)
    load(control_filename_list{k_exp}, 'X_design');
    X_design_list{k_exp} = X_design;
    fclose('all');
end

TT1_save = TT1;
Y_rot_save = cell2mat(Y_rot);
VBM_global_save = cell2mat(VBM_global);
is_Good_save = is_Good;
X_design_save = cell2mat(X_design_list);



outputfilename = sprintf('%s-tt.txt', file_prefix);
save(outputfilename, 'TT1_save', '-ascii');
outputfilename = sprintf('%s-pitch.txt', file_prefix);
save(outputfilename, 'Y_rot_save', '-ascii');
outputfilename = sprintf('%s-vbmg.txt', file_prefix);
save(outputfilename, 'VBM_global_save', '-ascii');
outputfilename = sprintf('%s-isgood.txt', file_prefix);
save(outputfilename, 'is_Good_save', '-ascii');
outputfilename = sprintf('%s-design.txt', file_prefix);
save(outputfilename, 'X_design_save', '-ascii');
