close('all');

%
% Set surrogate model parameters here
%

a_par = Analysis_Parameters();
a_par.fig_path = './test_pix/';
if ~exist(a_par.fig_path, 'dir')
    mkdir(a_par.fig_path);
end
a_par.n_modes = 12;
a_par.kl_transformation_rule = 'structured-sampling';
a_par.gpr_verbosity = 1;
a_par.gpr_kernel_class = 'ardsquaredexponential';
a_par.gpr_explicit_basis_class = 'linear';

%
% Load the data from the scatter files.  We use the design parameters (the 
% alphase), and the VBM time series.  We use uniformly distributed data
% for training models, but the MC data may be useful for testing /
% validation
%

[ AA_uniform, ZZ_uniform, AA_mc, ZZ_mc ] = load_sample_data();
n_in = size(AA_uniform, 2);

plot_raw_timeseries(ZZ_uniform);

%
% Set active search parameters here
%

as_par = Active_Search_Parameters();
as_par.video_path = a_par.fig_path;
as_par.nq_mc = 5e5;
as_par.n_init = 10;
as_par.n_iter = 50;
as_par.n_dim_in = size(AA_uniform, 2);
as_par.overall_norm_factor = beta;

%
% Normalize the data.  Keep the normalization parameter handy
%

beta = std(ZZ_mc(:));
ZZ_uniform_norm = ZZ_uniform./beta;
ZZ_mc_norm = ZZ_mc./beta;

%
% Build 'true' (full data) model.  Plot this surrogate model if you don't
% want/need the full active search machinery
%

true_model_protocol= LAMP_Protocol(a_par);
true_model_protocol.overall_norm = beta;
true_model_protocol.exp_name = sprintf('four-40-true');
true_model_protocol.load_training_data(AA_uniform, ZZ_uniform_norm);
true_model_protocol.load_testing_data(AA_mc, ZZ_mc_norm);
true_model_protocol.transform_data();
true_model_protocol.train_gpr();

%
% Plot some true model things.  Check the code for these plotters for best
% practices for making your own plots
%

true_model_protocol.plot_basis();
true_model_protocol.plot_surrogate(1);
RR = draw_reconstruction_scatterplots( true_model_protocol );
[ XX, FF] = draw_recon_pdf( true_model_protocol );

%
% function handles for error stuff
%

true_f_sample = @(alpha) true_model_protocol.gpr_obj.sample(alpha);
true_f_mean = @(alpha) true_model_protocol.gpr_obj.predict(alpha);   

%
% Statistics of true model
%
% Use this to calibrate some error metrics later
%

pq_filename = sprintf('%strue_pq.m', a_par.fig_path);
pz_filename = sprintf('%strue_pz.m', a_par.fig_path);

if exist(pq_filename, 'file')
    fprintf('Loading true model MC sampling from file.\n')

    data = load(pq_filename, '-mat');
    true_pq = data.true_pq;
    data = load(pz_filename, '-mat');
    true_pz = data.true_pz;
    
else

    fprintf('Starting true model MC sampling.\n')
    tic;
        
    [ true_pq, true_pz] = compute_histograms_from_gpr_protocol(a_par, ...
        as_par, true_model_protocol);
    
    save(pq_filename, 'true_pq');
    save(pz_filename, 'true_pz');

    fprintf('True model MC sampling done after %0.2f seconds.\n', toc);
end

%
% Active Search loop!  The magic happens here.
%
% We use as_from_precomputed() because we don't call the true black box
% LAMP at each step--instead, we decide which of the precomputed points
% will be best, and then consult the 'oracle' of the precomputed data
%

protocol_list = as_from_precomputed(a_par, as_par, AA_uniform, ZZ_uniform_norm );

%
% Plots!  Some of these plots want true_f_mean().  For problems from data,
% we use the big N data GPR surrogate as a proxy for the truth
%

fprintf('Starting plots!\n');
draw_true_model_plots(a_par, as_par, true_f_mean);
draw_movie_plots(a_par, as_par, protocol_list, true_f_mean, true_pq);
aa_train = protocol_list{as_par.n_iter}.aa_train;
draw_sample_point_plots(a_par, as_par, aa_train);

%f_fake = @(a) 1;  in case true_f_mean() isn't easy to make
[ err_struct  ] = calc_error_metrics( a_par, as_par, protocol_list, ...
    true_f_mean, true_pq, true_pz);
draw_error_plots( a_par, as_par, protocol_list, ...
    true_pq, true_pz, err_struct);

err_filename = sprintf('%serr_struct.mat', a_par.fig_path);
save(err_filename, 'err_struct', '-mat');