function [ outcode ] = draw_error_plots( a_par, as_par, protocol_list, ...
    true_pq, true_pz, err_struct)
%DRAW_ERROR_PLOTS Summary of this function goes here
%   Detailed explanation goes here

    tic;
    fprintf('Beginning error plot calculations.\n')

    f_input = @(alpha) prod(1/sqrt(2*pi)*exp(-alpha.^2/2), 2);

%     a3_grid = linspace(-as_par.z_max, as_par.z_max, as_par.n_grid_likelihood);
%     [aa13, aa23, aa33] = meshgrid(a3_grid, a3_grid, a3_grid);
%     aa3_grid = [aa13(:), aa23(:), aa33(:)];

    aa3_grid = as_par.z_max*(1-2*lhsdesign(1e4, as_par.n_dim_in));
    ww3 = f_input(aa3_grid);
    dww3 = ww3./sum(ww3(:));

    bbq = linspace(-as_par.q_max, as_par.q_max, as_par.nqb+1);
    qq_interval = 1/2*(bbq(1:end-1) + bbq(2:end));

    beta = protocol_list{1}.gpr_obj.overall_norm_factor;
    bbz = linspace(-7*beta, 7*beta, as_par.nqb+1);
    qqz_interval = 1/2*(bbz(1:end-1) + bbz(2:end));


    NN_plot = (1:length(protocol_list)) + as_par.n_init;
    
    
    fprintf('Plotting recovered q pdf and error metrics.\n');


    if as_par.draw_plots
        lkk = [5:5:length(protocol_list), length(protocol_list)+1];
        CC = colormap(parula(length(protocol_list)));

        figure(18);
        clf;
        hold on
        hh = zeros(length(protocol_list)+1, 1);
        names = cell(length(protocol_list)+1, 1);
        for k = 1:length(protocol_list)
            hh(k) = plot(qqz_interval, err_struct.pz_list{k}, 'LineWidth', 1, 'Color', CC(k, :));
            names{k} = sprintf('n = %d', k+as_par.n_init);
        end
        hh(length(protocol_list)+1) = plot(qqz_interval, true_pz, 'LineWidth', 3, 'Color', 'Black');
        names{length(protocol_list)+1} = 'truth';
        xlabel('$M_y$', 'Interpreter', 'Latex')
        ylabel('$p_M(m_y)$', 'Interpreter', 'Latex');
        legend(hh(lkk), names(lkk), 'Interpreter', 'Latex', 'Location', 'South');
        set(gca, 'YScale', 'log')
        title(sprintf('full VBM pdf'), 'Interpreter', 'Latex');
        %ylim([1e-16, 1e-9])
        set(gca, 'FontSize', 9);
        set(gcf,'units','inches','position', a_par.plot_pos);
        set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
    
        if a_par.save_figs
            filename = sprintf('%svbm-pdf_total', a_par.fig_path);
            print(filename,'-dpdf');
            savefig(filename);
        end
    
        if as_par.compute_mode_errors
            figure(13);
            clf;
            hold on
            hh = zeros(length(protocol_list)+1, 1);
            names = cell(length(protocol_list)+1, 1);
            for k = 1:length(protocol_list)
                hh(k) = plot(qq_interval, err_struct.pq_list{k}, 'LineWidth', 1, 'Color', CC(k, :));
                names{k} = sprintf('n = %d', k+as_par.n_init);
            end
            hh(length(err_struct.pq_list)+1) = plot(qq_interval, true_pq, 'LineWidth', 3, 'Color', 'Black');
            names{length(err_struct.pq_list)+1} = 'truth';
            xlabel('$q_1$', 'Interpreter', 'Latex')
            ylabel('$p_Q(q_1)$', 'Interpreter', 'Latex');
            legend(hh(lkk), names(lkk), 'Interpreter', 'Latex', 'Location', 'South');
            set(gca, 'YScale', 'log')
            title(sprintf('q pdf, mode %d', as_par.q_plot), 'Interpreter', 'Latex');
            ylim([1e-7, 1e0])
            set(gca, 'FontSize', 9);
            set(gcf,'units','inches','position', a_par.plot_pos);
            set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
        
            if a_par.save_figs
                filename = sprintf('%sq-pdf_total_mode_%d', a_par.fig_path, as_par.q_plot);
                print(filename,'-dpdf');
                savefig(filename);
            end

            figure(14);
            clf;
            hold on
            plot(NN_plot, err_struct.qp_mae_list);
            plot(NN_plot, err_struct.qp_rmse_list);
            xlabel('$n$', 'Interpreter', 'Latex')
            ylabel('$\epsilon$', 'Interpreter', 'Latex');
            legend({'MAE', 'RMSE'}, 'Interpreter', 'Latex')
            set(gca, 'YScale', 'log')
            title(sprintf('q-pdf error q=%d', as_par.q_plot), 'Interpreter', 'Latex');
            set(gca, 'FontSize', 9);
            set(gcf,'units','inches','position', a_par.plot_pos);
            set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
        
            if a_par.save_figs
                filename = sprintf('%sq-pdf-error_q=%d', a_par.fig_path, as_par.q_plot);
                print(filename,'-dpdf');
                savefig(filename);
            end
    
            figure(15);
            clf;
            hold on
            hh = zeros(2*as_par.n_kl_bounds, 1);
            for j = 1:as_par.n_kl_bounds
                hh(2*j-1) = plot(NN_plot, err_struct.qp_log_mae_list(:, j), 'Color', 'Red');
                hh(2*j) = plot(NN_plot, err_struct.qp_log_rmse_list(:, j), 'Color', 'Blue');
            end
            xlabel('$n$', 'Interpreter', 'Latex')
            ylabel('$\epsilon$', 'Interpreter', 'Latex');
            legend(hh(1:2), {'MAE', 'RMSE'}, 'Interpreter', 'Latex')
            set(gca, 'YScale', 'log')
            title(sprintf('q-pdf log error q=%d', as_par.q_plot), 'Interpreter', 'Latex');
            set(gca, 'FontSize', 9);
            set(gcf,'units','inches','position', a_par.plot_pos);
            set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
        
            if a_par.save_figs
                filename = sprintf('%sq-pdf-log_error_q=%d', a_par.fig_path, as_par.q_plot);
                print(filename,'-dpdf');
                savefig(filename);
            end
    
            figure(16);
            clf;
            hold on
            hh = zeros(2*as_par.n_kl_bounds, 1);
            for j = 1:as_par.n_kl_bounds
                hh(2*j-1) = plot(NN_plot, err_struct.qp_kl_div_forward_list(:, j), 'Color', 'Red');
                hh(2*j) = plot(NN_plot, err_struct.qp_kl_div_backward_list(:, j), 'Color', 'Blue');
            end
            xlabel('$n$', 'Interpreter', 'Latex')
            ylabel('$D_{KL}$', 'Interpreter', 'Latex');
            legend(hh(1:2), {'$D_{KL}(\mbox{true} || \mbox{model})$', '$D_{KL}(\mbox{model} || \mbox{true})$'}, ...
                'Interpreter', 'Latex')
            set(gca, 'YScale', 'log')
            title(sprintf('q-pdf KL divergence q=%d', as_par.q_plot), 'Interpreter', 'Latex');
            set(gca, 'FontSize', 9);
            set(gcf,'units','inches','position', a_par.plot_pos);
            set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
        
            if a_par.save_figs
                filename = sprintf('%sq-pdf-kl-div_q=%d', a_par.fig_path, as_par.q_plot);
                print(filename,'-dpdf');
                savefig(filename);
            end
        end
    
        if as_par.compute_surr_errors
            figure(17);
            clf;
            hold on
            plot(NN_plot, err_struct.surr_mu_mae_list);
            plot(NN_plot, err_struct.surr_mu_rmse_list);
            xlabel('$n$', 'Interpreter', 'Latex')
            ylabel('$\epsilon$', 'Interpreter', 'Latex');
            legend({'MAE', 'RMSE'}, 'Interpreter', 'Latex')
            set(gca, 'YScale', 'log')
            title(sprintf('surrogate mean expected error q=%d', as_par.q_plot), 'Interpreter', 'Latex');
            set(gca, 'FontSize', 9);
            set(gcf,'units','inches','position', a_par.plot_pos);
            set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
        
            if a_par.save_figs
                filename = sprintf('%ssurrogate-mean-expected-error_q=%d', a_par.fig_path, as_par.q_plot);
                print(filename,'-dpdf');
                savefig(filename);
            end
        end



        figure(19);
        clf;
        hold on
        plot(NN_plot, err_struct.pz_mae_list);
        plot(NN_plot, err_struct.pz_rmse_list);
        xlabel('$n$', 'Interpreter', 'Latex')
        ylabel('$\epsilon$', 'Interpreter', 'Latex');
        legend({'MAE', 'RMSE'}, 'Interpreter', 'Latex')
        set(gca, 'YScale', 'log')
        title(sprintf('VBM-pdf error'), 'Interpreter', 'Latex');
        set(gca, 'FontSize', 9);
        set(gcf,'units','inches','position', a_par.plot_pos);
        set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
    
        if a_par.save_figs
            filename = sprintf('%sVBM-pdf-error', a_par.fig_path);
            print(filename,'-dpdf');
            savefig(filename);
        end

        figure(20);
        clf;
        hold on
        hh = zeros(2*as_par.n_kl_bounds, 1);
        for j = 1:as_par.n_kl_bounds
            hh(2*j-1) = plot(NN_plot, err_struct.pz_log_mae_list(:, j), 'Color', 'Red');
            hh(2*j) = plot(NN_plot, err_struct.pz_log_rmse_list(:, j), 'Color', 'Blue');
        end
        xlabel('$n$', 'Interpreter', 'Latex')
        ylabel('$\epsilon$', 'Interpreter', 'Latex');
        legend(hh(1:2), {'MAE', 'RMSE'}, 'Interpreter', 'Latex')
        set(gca, 'YScale', 'log')
        title(sprintf('VBM-pdf log error'), 'Interpreter', 'Latex');
        set(gca, 'FontSize', 9);
        set(gcf,'units','inches','position', a_par.plot_pos);
        set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
    
        if a_par.save_figs
            filename = sprintf('%sVBM-pdf-log_error', a_par.fig_path);
            print(filename,'-dpdf');
            savefig(filename);
        end

        figure(21);
        clf;
        hold on
        hh = zeros(2*as_par.n_kl_bounds, 1);
        for j = 1:as_par.n_kl_bounds
            hh(2*j-1) = plot(NN_plot, err_struct.pz_kl_div_forward_list(:, j), 'Color', 'Red');
            hh(2*j) = plot(NN_plot, err_struct.pz_kl_div_backward_list(:, j), 'Color', 'Blue');
        end
        xlabel('$n$', 'Interpreter', 'Latex')
        ylabel('$D_{KL}$', 'Interpreter', 'Latex');
        legend(hh(1:2), {'$D_{KL}(\mbox{true} || \mbox{model})$', '$D_{KL}(\mbox{model} || \mbox{true})$'}, ...
            'Interpreter', 'Latex')
        set(gca, 'YScale', 'log')
        title(sprintf('VBM-pdf KL divergence'), 'Interpreter', 'Latex');
        set(gca, 'FontSize', 9);
        set(gcf,'units','inches','position', a_par.plot_pos);
        set(gcf,'PaperUnits', 'inches', 'PaperPosition', a_par.half_paper_pos, 'PaperSize', a_par.half_paper_size);
    
        if a_par.save_figs
            filename = sprintf('%sVBM-pdf-kl-div', a_par.fig_path);
            print(filename,'-dpdf');
            savefig(filename);
        end
    end

    outcode = 1;

end

