import json
import pandas as pd


questions = {}
choiceByNum = {}
choiceByText = {}

with open('questions.json', 'r') as f:
    questions = json.load(f)
    for qId, qDef in questions.items():
        if 'choices' not in qDef:
            continue
        choiceByNum[qId] = {}
        choiceByText[qId] = {}
        for cText, cNum in qDef['choices'].items():
            choiceByNum[qId][cNum] = cText
            choiceByText[qId][cText] = cNum
            
def choiceNum(q,t):
    return choiceByText[q][t]

def choiceText(q,n):
    return choiceByNum[q][n]  


def singleOptionBreakdown(col, index):
    return pd.DataFrame(col.groupby(col).size().rename('count').rename_axis("")).rename(index=index)

def multiOptionBreakdown(col,index):
    return pd.DataFrame(
        col.apply(pd.Series).melt().dropna().groupby(['value']).size()
    ).rename(index).rename({0:'count'}, axis=1).rename_axis("")