The Museum of Modern Art (MoMA) Collection
===================

The Museum of Modern Art (MoMA) acquired its first artworks in 1929, the year it was established. Today, the Museum’s evolving collection contains almost 200,000 works from around the world spanning the last 150 years. The collection includes an ever-expanding range of visual expression, including painting, sculpture, printmaking, drawing, photography, architecture, design, film, and media and performance art.

MoMA is committed to helping everyone understand, enjoy, and use our collection. The Museum’s [website](http://www.moma.org/collection) features 98,361 artworks from 27,140 artists. This research dataset contains 140,848 records, representing all of the works that have been accessioned into MoMA’s collection and cataloged in our database. It includes basic metadata for each work, including title, artist, date made, medium, dimensions, and date acquired by the Museum. Some of these records have incomplete information and are noted as “not Curator Approved.”

The Artists dataset contains 15,243 records, representing all the artists who have work in MoMA's collection and have been cataloged in our database. It includes basic metadata for each artist, including name, nationality, gender, birth year, death year, Wiki QID, and Getty ULAN ID.

At this time, both datasets are available in CSV format, encoded in UTF-8. While UTF-8 is the standard for multilingual character encodings, it is not correctly interpreted by Excel on a Mac. Users of Excel on a Mac can convert the UTF-8 to UTF-16 so the file can be imported correctly. The datasets are also available in JSON.

This datasets are placed in the public domain using a [CC0 License](https://creativecommons.org/publicdomain/zero/1.0/).

For a roundup of how people have used our data so far, visit our [Medium post](https://medium.com/@foe/here-s-a-roundup-of-how-people-have-used-our-data-so-far-80862e4ce220#.f6272outn). We love adding to the list, so please email us at collection@moma.org if you'd like to be included.

## Additional usage guidelines
### Images not included
Images are not included and are not part of the dataset. To license images of works of art in MoMA’s collection please contact [Art Resource](http://www.artres.com/) (North America) or [Scala Archives](http://www.scalarchives.com/) (outside North America).

### Research in progress
This data is provided “as is” for research purposes and you use this data at your own risk. Much of the information included in this dataset is not complete and has not been curatorially approved. MoMA offers the datasets as-is and makes no representations or warranties of any kind.

We plan to update the datasets with new and revised information on a regular basis. You are advised to regularly update your copy of the datasets to ensure you are using the best available information.


### Pull requests
Because these datasets are generated from our internal database, we do *not* accept pull requests. If you have identified errors or have extra information to share, please email us at [collection@moma.org](mailto:collection@moma.org) and we will forward to the appropriate department for review.

### Give attribution to MoMA
MoMA requests that you actively acknowledge and give attribution to MoMA wherever possible. If you use one or both of the datasets for a publication, please cite it using the digital object identifier [![DOI](https://zenodo.org/badge/doi/10.5281/zenodo.7269353.svg)](http://dx.doi.org/10.5281/zenodo.7269353). Attribution supports efforts to release other data. It also reduces the amount of “orphaned data,” helping retain links to authoritative sources.

### Do not misrepresent the dataset
Do not mislead others or misrepresent the datasets or their source. You must not use MoMA’s trademarks or otherwise claim or imply that MoMA endorses you or your use of the dataset.

Whenever you transform, translate or otherwise modify the dataset, you must make it clear that the resulting information has been modified. If you enrich or otherwise modify the dataset, consider publishing the derived dataset without reuse restrictions.



The writers of these guidelines thank the [Tate](http://www.tate.org.uk/), [Cooper-Hewitt](http://www.cooperhewitt.org/), and [Europeana](http://www.europeana.eu/).
