//--------------------------------------------------------------------------
/*! \file synapse_support_code_event_sim_code/test.cc

\brief Main test code that is part of the feature testing
suite of minimal models with known analytic outcomes that are used for continuous integration testing.
*/
//--------------------------------------------------------------------------


// Google test includes
#include "gtest/gtest.h"

// Autogenerated simulation code includess
#include "synapse_support_code_event_sim_code_CODE/definitions.h"

// **NOTE** base-class for simulation tests must be
// included after auto-generated globals are includes
#include "../../utils/simulation_test_vars.h"
#include "../../utils/simulation_neuron_policy_pre_var.h"
#include "../../utils/simulation_synapse_policy_dense.h"

// Combine neuron and synapse policies together to build variable-testing fixture
typedef SimulationTestVars<SimulationNeuronPolicyPreVar, SimulationSynapsePolicyDense> SimTest;

TEST_F(SimTest, SynapseSupportCodeEventSimCode)
{
  float err = Simulate(
    [](unsigned int d, unsigned int j, unsigned int, float t, float &newX)
    {
        if ((t > d*DT+0.1001) && (fmod(t-2*DT-d*DT+5e-5+10*j,(float) (2*(d+1))) < 1e-4))
        {
            newX = t-2*DT-d*DT+10*j;
            return true;
        }
        else
        {
          return false;
        }
    });

  // Check total error is less than some tolerance
  EXPECT_LT(err, 1e-2);
}
