//--------------------------------------------------------------------------
/*! \file post_vars_in_sim_code/test.cc

\brief Main test code that is part of the feature testing
suite of minimal models with known analytic outcomes that are used for continuous integration testing.
*/
//--------------------------------------------------------------------------


// Google test includes
#include "gtest/gtest.h"

// Autogenerated simulation code includess
#include "post_vars_in_sim_code_CODE/definitions.h"

// **NOTE** base-class for simulation tests must be
// included after auto-generated globals are includes
#include "../../utils/simulation_test_vars.h"
#include "../../utils/simulation_neuron_policy_pre_post_var.h"
#include "../../utils/simulation_synapse_policy_dense.h"

// Combine neuron and synapse policies together to build variable-testing fixture
typedef SimulationTestVars<SimulationNeuronPolicyPrePostVar, SimulationSynapsePolicyDense> SimTest;

TEST_F(SimTest, PostVarsInSimCode)
{
  float err = Simulate(
    [](unsigned int d, unsigned int, unsigned int k, float t, float &newX)
    {
        if ((t > 1.1001) && (fmod(t-DT-(d+1)*DT+5e-5,1.0f) < 1e-4)) {
            newX = t-2*DT+10*k;
            return true;
        }
        else {
          return false;
        }
    });

  // Check total error is less than some tolerance
  EXPECT_LT(err, 3e-2);
}
