
df <- readRDS(file='data.rds')  

printf <- function(...) invisible(cat(sprintf(...)))

sizes <- c(2:19)
AUTs <- unique(df$aut)

names <- c("AUT", "FirstVar", "FirstVarKS","IsFirstVarNormal", "SecondVar", "SecondVarKS", "IsSecondNormal", "Test", "Alternative", "TestValue", "Outcome")
tests <- data.frame(AUT = NA, FirstVar = NA, FirstVarShapiro=NA, IsFirstNormal = NA, SecondVar = NA, SecondVarShapiro = NA, IsSecondNormal = NA, Test=NA, Alternative=NA, TestValue=NA, Outcome=NA )
names(tests) <- names
tests <- tests[FALSE,]

for(alt in c("less","greater")){
  for(AUT in AUTs){
    printf("AUT: %s\n",AUT)
    for(sUET in sizes){ #UET
      printf("%d UET\n",sUET)
      #check if first var is normal
      firstVar <- df[which(df$aut==AUT & df$size==sUET & df$strategy=='UET'),]$coverage
      firstVarKS <- ks.test(firstVar,"pnorm")$p.value
      isFirstVarNormal <- firstVarKS > 0.05
      
      for(sIET in sizes){ #IET
        #check if second var is normal
        secondVar <- df[which(df$aut==AUT & df$size==sIET & df$strategy=='IET'),]$coverage
        secondVarKS <- ks.test(secondVar,"pnorm")$p.value
        isSecondVarNormal <- secondVarKS > 0.05
        
        if(isFirstVarNormal & isSecondVarNormal) { #non accade mai
          printf("T-TEST???")
          test <- "T-test"
        } else {
          test <- "Wilcoxon"
          testV <- wilcox.test(coverage ~ strategy, data=df, alternative=alt, subset = df$aut==AUT & ( (df$size==sUET & df$strategy=='UET') | (df$size==sIET & df$strategy=='IET') )  )       
          #testValue <- as.numeric(format(testV$p.value,digits=2, nsmall=2))
          testValue <- testV$p.value
          if(testValue > 0.05){
            outcome <- "Not refuse"
          } else {
            outcome <- sprintf("Refuse: N=%d UET coverage is %s than N=%d IET coverage",sUET,alt,sIET);
          }
        }
        
        record <- data.frame(
          AUT, 
          paste(sUET,'UET'), firstVarKS, isFirstVarNormal,
          paste(sIET,'IET'), secondVarKS, isSecondVarNormal,
          test, alt, testValue, outcome
        )
        names(record) <- names
        
        tests <- rbind(tests,record)
        
      }
    }
  }
}

saveRDS(tests, file="tests.rds")
write.csv(tests,"tests.csv", row.names = FALSE)