library(stringr)
library(tidyr)
library(data.table)
library(scales)

csv_files <- list.files(path="./data/mix/",pattern="*6IET_2UET_results.csv", recursive=TRUE)

mix_data <- data.frame(
  rep=numeric(), aut=character(), sizeIET=numeric(), sizeUET=numeric(), subjectsIET=character(), 
  subjectsUET=character(), strategy=character(), coverage=numeric()
)

for(csv_file in csv_files){
  rep <- str_split(csv_file,"/")[[1]][1]
  rep <- str_replace(rep, "mix_rep", "")
  print(csv_file)
  current_data <- read.csv(paste("./data/mix",csv_file,sep="/"), sep = ";")
  current_data$rep = rep(rep, nrow(current_data))
  # current_data$versions = rep(versions, nrow(current_data))
  # current_data$variant = 1:nrow(current_data)
  # 
  mix_data <- rbind(aggregate_data, current_data)
}

mix_data <- setDT(mix_data)[,list(coverage=mean(coverage)), by=c("aut","sizeIET","sizeUET","strategy")]


saveRDS(mix_data, './data/mix/mix_data.rds')

