library(data.table)
library(ggplot2)
library(scales)

plotDir <- "./plots"

stats <- read.csv("./data/ce/statistics.csv")

p <- ggplot(data=stats, aes(x=size,y=Std,group=aut)) +
  geom_line() +
  geom_point() +
  xlab("Number of testers") +
  ylab("St.Dev. of LOC coverage (%)")+
  facet_grid(aut~strategy) 
print(p)
ggsave(filename=paste(plotDir,'stdev_loc_coverage.png',sep="/"))

p <- ggplot(data=stats, aes(x=size,y=Median,group=aut)) +
  geom_line() +
  geom_point() +
  xlab("Number of testers") +
  ylab("Median LOC coverage (%)")+
  facet_grid(aut~strategy)  
print(p)
ggsave(filename=paste(plotDir,'median_loc_coverage.png',sep="/"))

p <- ggplot(data=stats, aes(x=size,y=Mean)) +
  geom_line() +
  geom_point() +
  xlab("Number of testers") +
  ylab("Average LOC coverage (%)")+
  facet_grid(aut~strategy) 
print(p)
ggsave(filename=paste(plotDir,'average_loc_coverage.png',sep="/"))
