library(data.table)
library(ggplot2)
library(scales)

plotDir <- "./plots"

stats <- readRDS('./data/stats.RDS')

stats$experiment <- as.character(stats$experiment)

stats$Mean <- round(stats$Mean,0)
stats$Median <- round(stats$Median,0)

# plot heatmap

# prepare dataframe

names <- c("AUT", "Experiment", "UETsize1", "UETsize2","DifferenceOfMedians", "DifferenceOfMeans")
heatmapData <- data.frame(AUT = NA, Experiment=NA, UETsize = NA, IETsize=NA, DifferenceOfMedians = NA, DifferenceOfMeans = NA)
names(heatmapData) <- names
heatmapData <- heatmapData[FALSE,]

for(AUT in unique(stats$aut)){
  for(expp in unique(stats$experiment)){
    for(sUET1 in c(2:19)){
      for(sUET2 in c(2:19)){
        
        if(expp=='CS' & (sUET1 > 9 | sUET2>9 | AUT=='SimplyDo' | AUT=='Trolly') ){
          break;
        }
        print(paste(AUT,expp,sUET1,sUET2))
        
        medianUET1 <- stats[which(stats$aut==AUT & stats$experiment==expp & stats$size==sUET1 & stats$strategy=='UET'),]$Median
        meanUET1   <- stats[which(stats$aut==AUT & stats$experiment==expp & stats$size==sUET1 & stats$strategy=='UET'),]$Mean
        
        medianUET2 <- stats[which(stats$aut==AUT & stats$experiment==expp & stats$size==sUET2 & stats$strategy=='UET'),]$Median
        meanUET2   <- stats[which(stats$aut==AUT & stats$experiment==expp & stats$size==sUET2 & stats$strategy=='UET'),]$Mean
        
        medianDiff <- abs(medianUET2 - medianUET1)
        meanDiff   <- abs(meanUET2 - meanUET1)
        
        print(paste(AUT,expp,sUET1,sUET2,medianDiff,meanDiff))
        
        record <- data.frame(
          AUT, expp,
          sUET1, sUET2, medianDiff, meanDiff
        )
        names(record) <- names
        
        heatmapData <- rbind(heatmapData,record)
      }
    }
  }
}

#already percentages now
#get percentages
#heatmapData$DifferenceOfMedians <- heatmapData$DifferenceOfMedians*100
#heatmapData$DifferenceOfMeans   <- heatmapData$DifferenceOfMeans*100

heatmapData <- heatmapData[which(heatmapData$Experiment=='CE'),] #get only CE

heatmap <- ggplot(data=heatmapData, aes(x=UETsize1,y=UETsize2,fill=DifferenceOfMedians)) +
  geom_tile() + #color="white",size=0.1
  scale_fill_viridis_c(breaks=seq(-10,10,by=2))+
  facet_wrap(Experiment~AUT,ncol=4) +
  theme(legend.position="top")
print(heatmap)

heatmap <- ggplot(data=heatmapData, aes(x=UETsize1,y=UETsize2,fill=DifferenceOfMeans)) +
  geom_tile() +
  #scale_fill_viridis_c(breaks=seq(-3,10,by=1.5))+
  #scale_fill_gradientn(colours = c("white","lightgreen","#006130"), values=c(0,0.12,0.17,0.2,1), breaks=seq(0,10,by=1.5))+
  scale_fill_gradient2(low="white",high="#400078") +
  #[scale_fill_gradient2(low = "red4", high = "springgreen4",mid = "white", breaks=seq(-3,10,by=1.5))+
  facet_wrap(Experiment~AUT,ncol=4) +
  theme(legend.position="top")
print(heatmap)
ggsave(filename=paste(plotDir,"heatmap_difference_of_means.png",sep="/"))#,width=10,height=10,units="cm",dpi="print")


heatmap <- ggplot(data=heatmapData, aes(x=UETsize1,y=UETsize2,fill=DifferenceOfMedians)) +
  geom_tile() +
  #scale_fill_viridis_c(breaks=seq(-3,10,by=1.5))+
  #scale_fill_gradientn(colours = c("white","lightgreen","#006130"), values=c(0,0.12,0.17,0.2,1), breaks=seq(0,10,by=1.5))+
  scale_fill_gradient2(low="white",high="#400078") +
  #[scale_fill_gradient2(low = "red4", high = "springgreen4",mid = "white", breaks=seq(-3,10,by=1.5))+
  facet_wrap(Experiment~AUT,ncol=2) +
  theme(legend.position="top")
print(heatmap)
ggsave(filename=paste(plotDir,"heatmap_difference_of_medians.png",sep="/"))#,width=10,height=10,units="cm",dpi="print")