# Merge mix data with IET/UET only data
library(tidyr)
library(xlsx)

effortIET <- 3

data <- readRDS("./data/ce/data_augmented.rds")
mix_data <- readRDS("./data/mix/mix_data.rds")

data$sizeIET <- data$size
data$sizeUET <- data$size

data[which(data$strategy=="IET"),]$sizeUET <- 0 #IET only have 0 sizeUET
data[which(data$strategy=="UET"),]$sizeIET <- 0 #UET only have 0 sizeIET

data <- data[,c("aut","strategy","sizeIET","sizeUET","coverage")]

data <- setDT(data)[,list(coverage=mean(coverage)), by=c("aut","strategy","sizeIET","sizeUET")]

mix_data <- mix_data[, c("aut","strategy","sizeIET","sizeUET","coverage")]

data <- rbind(data, mix_data)

data$effort <- effortIET*data$sizeIET + data$sizeUET

data <- data[, c("effort","aut","strategy","sizeIET","sizeUET","coverage")]

data_pivoted <- pivot_wider(data, id_cols = c("effort","strategy","sizeIET","sizeUET"),names_from=c("aut"),values_from=c("coverage"))

write.csv(data_pivoted, file="./data/all_strategies.csv",row.names = F)