library(ggplot2)
library(ggbrace)

times <- c(0,5,15,45,50,60)

data <- data.frame(
  time=times,
  users=c(0,0,50,50,0,0)
)

lineplot <- ggplot(data,aes(x=time,y=users))+
  geom_line(color="blue",size=1.25) +
  scale_x_continuous(name="Time (minutes)", breaks=times, minor_breaks =  times
                     #labels=c("0","5","15","45","50","60")
                     )+
  scale_y_continuous(breaks=c(0,25,50), minor_breaks = c(0,25,50), limits = c(-20,50))+
  geom_brace(aes(c(times[1],times[2]), c(-2, -8), label="Initial\ndelay"),size=1,rotate=180,inherit.data=F,labelsize=4)+
  geom_brace(aes(c(times[2],times[3]), c(-2, -8), label="Startup\ntime"),size=1,rotate=180,inherit.data=F,labelsize=4)+
  geom_brace(aes(c(times[3],times[4]), c(-2, -8), label="Hold load time"),size=1,rotate=180,inherit.data=F,labelsize=4)+
  geom_brace(aes(c(times[4],times[5]), c(-2, -8), label="Shutdown\ntime"),size=1,rotate=180,inherit.data=F,labelsize=4)+
  ylab("Number of active users") +
  theme_bw()
print(lineplot)