library(data.table)
library(ggplot2)
library(scales)

mround <- function(x,base){
  base*round(x/base)
} 

plotDir = './plots'

dataCE <- readRDS(file="./data/ce/data_augmented.rds")
#dataCE <- dataCE[which(dataCE$strategy=='IET'),]
#dataCS <- readRDS(file="./data/cs/data.rds")

#dataCE$coverage <- mround(dataCE$coverage*100,.5)
#dataCE$coverage <- round(dataCE$coverage*100)
dataCE$coverage <- dataCE$coverage*100



stats <- setDT(dataCE)[,list(Mean=mean(coverage), Max=max(coverage), Min=min(coverage), Median=as.numeric(median(coverage)), Std=sd(coverage)), by=c("aut","size","strategy")]

names <- c("AUT", "sizeUET", "sizeIET", "DifferenceOfMedians", "DifferenceOfMeans")
heatmapData <- data.frame(AUT = NA, UETsize = NA, IETsize=NA, DifferenceOfMedians = NA, DifferenceOfMeans = NA)
names(heatmapData) <- names
heatmapData <- heatmapData[FALSE,]

for(AUT in unique(stats$aut)){
  for(sUET in c(1:20)){
    for(sIET in c(1:20)){
      
      #print(paste(AUT,strat,sUET1,sUET2))
      if(sUET==2 & sIET==19){
        print("foo")
      }
      
      medianUET <- stats[which(stats$aut==AUT & stats$size==sUET & stats$strategy=='UET'),]$Median
      meanUET   <- stats[which(stats$aut==AUT & stats$size==sUET & stats$strategy=='UET'),]$Mean
      
      medianIET <- stats[which(stats$aut==AUT & stats$size==sIET & stats$strategy=='IET'),]$Median
      meanIET   <- stats[which(stats$aut==AUT & stats$size==sIET & stats$strategy=='IET'),]$Mean
      
      medianDiff <- medianIET - medianUET
      meanDiff   <- meanIET - meanUET
      
      #print(paste(AUT,strat,sUET1,sUET2,medianDiff,meanDiff))
      
      record <- data.frame(
        AUT,
        sUET, sIET, medianDiff, meanDiff
      )
      names(record) <- names
      
      heatmapData <- rbind(heatmapData,record)
    }
  }
}


origHeatmapData <- heatmapData




heatmapData <- origHeatmapData

heatmapData$DiffMeansCat <- rep(NA,nrow(heatmapData))

heatmapData[which(heatmapData$DifferenceOfMeans < -3),]$DiffMeansCat <- "Less than -3%"
heatmapData[which(heatmapData$DifferenceOfMeans >= -3 & heatmapData$DifferenceOfMeans < -1),]$DiffMeansCat <- "Between -3% and -1%"
heatmapData[which(heatmapData$DifferenceOfMeans >= -1 & heatmapData$DifferenceOfMeans < 1),]$DiffMeansCat <- "Between -1% and 1%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 1 & heatmapData$DifferenceOfMeans < 3),]$DiffMeansCat <- "Between 1% and 3%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 3 & heatmapData$DifferenceOfMeans < 5),]$DiffMeansCat <- "Between 3% and 5%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 5 & heatmapData$DifferenceOfMeans < 7),]$DiffMeansCat <- "Between 5% and 7%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 7 & heatmapData$DifferenceOfMeans < 9),]$DiffMeansCat <- "Between 7% and 9%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 9),]$DiffMeansCat <- "More than 9%"

heatmapData$DiffMeansCat <- factor(heatmapData$DiffMeansCat,levels=c(
  "Less than -3%","Between -3% and -1%","Between -1% and 1%",
  "Between 1% and 3%","Between 3% and 5%", "Between 5% and 7%", "Between 7% and 9%", "More than 9%"))


#heatmapData$DifferenceOfMeans <- round(heatmapData$DifferenceOfMeans,1)
heatmapData$DifferenceOfMeans <- mround(heatmapData$DifferenceOfMeans,0.5)
#heatmapData$DifferenceOfMeans <- round(heatmapData$DifferenceOfMeans)



hourlyCostUET <- 1
hourlyCostIET <- 1
hoursPerUetTask <- 1
hoursPerIetTask <- 4


heatmap <- ggplot(data=heatmapData, aes(x=sizeUET*hoursPerUetTask*hourlyCostUET,y=sizeIET*hoursPerIetTask*hourlyCostIET,fill=as.factor(DiffMeansCat))) +
  geom_tile(colour="black") +
  geom_abline(color="red",show.legend=TRUE,size=1.5) +
  #scale_fill_viridis_c(breaks=seq(-3,10,by=1.5))+
  #scale_fill_gradientn(colours = c("white","lightgreen","#006130"), values=c(0,0.12,0.17,0.2,1), breaks=seq(0,10,by=1.5))+
  #scale_fill_gradient2(low="white",high="midnightblue") +
  scale_fill_viridis_d() +
  scale_fill_manual(values=c("#fa4e27","#ffa8a8","white","#ADD5F7","#7ABAF2","#1B76FF","#0003C7","#020873"), name="Difference in average coverage percentage (IET coverage - UET coverage)") +

  #[scale_fill_gradient2(low = "red4", high = "springgreen4",mid = "white", breaks=seq(-3,10,by=1.5))+
  facet_wrap(~AUT,ncol=4) +
  theme_bw()+
  theme(legend.position="top") +
  #scale_y_continuous(breaks = seq(0, max(heatmapData$sizeIET*hoursPerIetTask*hourlyCostIET), by = 5))+
  scale_y_continuous(limits = c(1, 23))+
  labs(x="UET Investment (hours)", y="IET Investment (hours)",fill="Coverage IET - Coverage UET")
  #ggtitle(paste(hoursPerIetTask," hours per IET task"))
print(heatmap)
