library(data.table)
library(ggplot2)
library(scales)

mround <- function(x,base){
  base*round(x/base)
} 

plotDir = './plots'

dataCE <- readRDS(file="./data/ce/data_augmented.rds")
#dataCE <- dataCE[which(dataCE$strategy=='IET'),]
#dataCS <- readRDS(file="./data/cs/data.rds")

#dataCE$coverage <- mround(dataCE$coverage*100,.5)
#dataCE$coverage <- round(dataCE$coverage*100)
dataCE$coverage <- dataCE$coverage*100

stats <- setDT(dataCE)[,list(Mean=mean(coverage), Max=max(coverage), Min=min(coverage), Median=as.numeric(median(coverage)), Std=sd(coverage)), by=c("aut","size","strategy")]

write.csv(stats, file="./data/ce/statistics.csv")


names <- c("AUT", "Strategy", "size1", "size2", "DifferenceOfMedians", "DifferenceOfMeans")
heatmapData <- data.frame(AUT = NA, Strategy=NA, UETsize = NA, IETsize=NA, DifferenceOfMedians = NA, DifferenceOfMeans = NA)
names(heatmapData) <- names
heatmapData <- heatmapData[FALSE,]

for(AUT in unique(stats$aut)){
  for(strat in unique(stats$strategy)){
    for(sUET1 in c(1:20)){
      for(sUET2 in c(1:20)){
        
        #print(paste(AUT,strat,sUET1,sUET2))
        
        medianUET1 <- stats[which(stats$aut==AUT & stats$size==sUET1 & stats$strategy==strat),]$Median
        meanUET1   <- stats[which(stats$aut==AUT & stats$size==sUET1 & stats$strategy==strat),]$Mean
        
        medianUET2 <- stats[which(stats$aut==AUT & stats$size==sUET2 & stats$strategy==strat),]$Median
        meanUET2   <- stats[which(stats$aut==AUT & stats$size==sUET2 & stats$strategy==strat),]$Mean
        
        medianDiff <- abs(medianUET2 - medianUET1)
        meanDiff   <- abs(meanUET2 - meanUET1)
        
        #print(paste(AUT,strat,sUET1,sUET2,medianDiff,meanDiff))

        record <- data.frame(
          AUT, strat,
          sUET1, sUET2, medianDiff, meanDiff
        )
        names(record) <- names
        
        heatmapData <- rbind(heatmapData,record)
      }
    }
  }
}

heatmapData$Strategy <- factor(heatmapData$Strategy, levels = c("UET","IET"))
origHeatmapData <- heatmapData



heatmapData <- origHeatmapData

heatmapData$DiffMeansCat <- rep(NA,nrow(heatmapData))
heatmapData[which(heatmapData$DifferenceOfMeans < 1),]$DiffMeansCat <- "Less than 1%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 1 & heatmapData$DifferenceOfMeans < 3),]$DiffMeansCat <- "Between 1% and 3%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 3 & heatmapData$DifferenceOfMeans < 5),]$DiffMeansCat <- "Between 3% and 5%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 5 & heatmapData$DifferenceOfMeans < 7),]$DiffMeansCat <- "Between 5% and 7%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 7 & heatmapData$DifferenceOfMeans < 9),]$DiffMeansCat <- "Between 7% and 9%"
heatmapData[which(heatmapData$DifferenceOfMeans >= 9),]$DiffMeansCat <- "More than 9%"

heatmapData$DiffMeansCat <- factor(heatmapData$DiffMeansCat,levels=c(
  "Less than 1%",
  "Between 1% and 3%","Between 3% and 5%", "Between 5% and 7%", "Between 7% and 9%", "More than 9%"))

#heatmapData$DifferenceOfMeans <- round(heatmapData$DifferenceOfMeans,1)
heatmapData$DifferenceOfMeans <- mround(heatmapData$DifferenceOfMeans,0.5)
#heatmapData$DifferenceOfMeans <- round(heatmapData$DifferenceOfMeans)

heatmapData <- heatmapData[which(heatmapData$size1>heatmapData$size2),]

heatmap <- ggplot(data=heatmapData, aes(x=size1,y=size2,fill=as.factor(DiffMeansCat))) +
  geom_tile( width=0.8, height=0.8, color="black") +
  #scale_fill_viridis_c(breaks=seq(-3,10,by=1.5))+
  #scale_fill_gradientn(colours = c("white","lightgreen","#006130"), values=c(0,0.12,0.17,0.2,1), breaks=seq(0,10,by=1.5))+
  #scale_fill_gradient2(low="white",high="midnightblue") +
  scale_fill_viridis_d(name="Difference in coverage percentage",direction=-1) +
  scale_fill_manual(values=c("white","#ADD5F7","#7ABAF2","#1B76FF","#0003C7","#020873"), name="Difference in average coverage percentage") +
  #scale_fill_gradient2(low = "red4", high = "springgreen4",mid = "white", breaks=seq(-3,10,by=1.5))+
  #scale_fill_grey(start=.95,end=.05,name="Difference in coverage percentage") +
  facet_grid(Strategy~AUT)+#,ncol=4) +
  theme_bw()+
  xlab("Number of testers") + ylab("Number of testers") +
  theme(legend.position="top") 
print(heatmap)
