library(data.table)
library(ggplot2)
library(scales)
library(tidyr)

plotDir = './plots'

dataCE <- readRDS(file="./data/ce/data.rds")

singleton_data <- read.csv(file="./data/ce/singleton_data.csv", sep=";")
singleton_data$strategy <- toupper(singleton_data$strategy)


singleton_data <- pivot_longer(
  singleton_data, 
  c("MunchLife", "SimplyDo", "TippyTipper", "Trolly"),
  names_to = "aut",
  values_to = "coverage"
)

singleton_data$coverage <- as.numeric(gsub(",",".",singleton_data$coverage))
singleton_data$size <- rep(1,nrow(singleton_data))
names(singleton_data) <- c("subset","strategy","aut","coverage","size")
singleton_data <- singleton_data[,c("aut","coverage","size","strategy","subset")]

data <- rbind(dataCE,singleton_data)

full_set_data <- read.csv(file="./data/ce/full_set_data.csv")
data <- rbind(data,full_set_data)

saveRDS(data,file="./data/ce/data_augmented.rds")