package caldwell.ben.trolly.test;

import junit.framework.Test;
import caldwell.ben.trolly.Trolly;
import com.robotium.solo.*;

import android.test.ActivityInstrumentationTestCase2;


public class TrollyTest_SG extends ActivityInstrumentationTestCase2<Trolly> {
  	private Solo solo;
  	
  	public TrollyTest_SG() {
		super(Trolly.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
   
	public void testRun() {
		
		
		//TEST dell'applicazione TROLLY
		//le informazioni circa il test funzionale saranno riportate sotto forma di commento
		//prima del blocco di codice corrispondente
		
		//Si provveder inoltre a testare tutti i tasti (mediante CLICK e LONGCLICK) in corrispondenza
		//di ogni possibile schermata riportata a video (come ad es. i tasti OK e CANCEL dei Dialog)
		//in modo tale da valutare un comportamento corretto dell'app. in corrispondenza di tali eventi
		//ed in modo tale da massimizzare la copertura del codice sorgente (white box).
		
		//Il test dell'applicazione era in precedenza impossibile in quanto non risultava possibile
		//accedere alle View mediante il metodo "getView()": tale situazione era determinata da un
		//problema di "rendering" -> l'applicazione non riusciva ad accedere alla view in quanto
		//probabilmente ancora non riportate a video (specie per quegli elementi generati dinamicamente,
		//come ad esempio i Button associati ad un Dialog). Per ovviare tale problematica si usufruisce
		//quindi dei metodi waitForView(), waitForDialogToOpen() - gi presente -, e solo.sleep(),
		//utilizzato in corrispondenza della pressione del tasto Back (alcune volte non rilevato).
		//Si  deciso di utilizzare tale soluzione per tutti gli elementi (View) acceduti, in maniera
		//"indiscriminata", dato che il malfunzionamento risultava intermittente.
		//Tale soluzione minimizza ma non elimina il problema (potrebbe dipendere anche dalle performance
		//del calcolatore utilizzato per condurre il test).
		
		//Si  testato inoltre il reinserimento degli elementi in lista tramite ADD
		
		//Risulta inoltre impossibile coprire alcuni metodi, come ad esempio OnUpgrade-TrollyProvider
		//in quanto legato ad un'aventuale nuova versione del Database o il metodo getType()
		//Il metodo insert - trolly.provider non pu essere coperto totalmente (in termini di LOC o blocchi)
		//in quanto il metodo stesso realizza alcuni controlli su campi non direttamente controllabili
		//(verifica che questi, CREATED_DATE, MODIFIED_DATE..., siano stati correttamente settati
		//ed in caso contratio interviene opportunamente).
		
		//Non si  riusciti ad utilizzare il metodo AddExtraItems() in quanto utilizza gli intent
		//(gli intent verrebbero anche utilizzati dal altri metodi, come il metodo OnCreate 
		//questo infatti valuta se sono innanzitutto presenti alcuni elementi in Intent: 
		//questi non sono certamente presenti se si parte con MAIN ACTIVITY).
		//Tali elementi vengono ad esempio utilizzati dall'Activity Preferences per inviare le info
		//circa i nuovi settings alla Main Activity (che potr agire di conseguenza) -> si  cercato,
		//di garantire la copertura di tali elementi.	
			
		
		//Le funzionalit testate - nonch gli elementi utilizzati - sono riportati di seguito:
		
		
		// Wait for activity: 'caldwell.ben.trolly.Trolly'
		solo.sleep(2000); solo.waitForActivity(caldwell.ben.trolly.Trolly.class, 2000);
		// Set default small timeout to 12346 milliseconds
		Timeout.setSmallTimeout(12346);
		
		
		//RESET LIST con lista vuota
		// Click on action bar item
		solo.clickOnActionBarItem(0xa);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on OK 
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		//APRI MENU' (da Main Activity)
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		
		
		
		//Valuta il modus operandi dell'aplicazione quando in corrispondenza dei 2 valori di Settings
		//non  settata alcuna voce specifica.
		//(si ricorda infatti che l'app viene testata in seguito ad una reinizializzazione della stessa)
		
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		// Enter the text: 'Arancia'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Arancia");
		
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Enter the text: 'Fragola'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Fragola");
		
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Click on Fragola -> click su un elemento OFF_Trolley
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		
		// Enter the text: 'Zucchero'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Zucchero");
		
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Click on Zucchero
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 2));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		
		// Click on Empty Text View
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		// Enter the text: 'Mela'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Mela");
		
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Enter the text: 'Zucchero' -> Reinserisci l'elemento tramite Test: ON_TROLLEY -> OFF_TROLLEY
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Zucchero");
		
		// Click on Add -> PROVA INSERIMENTO CON EDITTEXT VUOTO (non succede nulla)
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Click on Fragola -> click su un elemento ON_Trolley: OFF_Trolley
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		//CLEAR LIST -> Cancel
		// Click on action bar item
		solo.clickOnActionBarItem(0x9);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));	
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		//RESET LIST -> Cancel
		// Click on action bar item
		solo.clickOnActionBarItem(0xa);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));	
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		// Long click Arancia -> Edit - Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));	
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Set default small timeout to 13272 milliseconds
		Timeout.setSmallTimeout(13272);
		
		
		// Long click Arancia -> Edit: Modifica e cancel
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Enter the text: 'Arancia'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Arancia");
		// Click on Arancia
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.edit));
		// Enter the text: 'blu'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "blu");
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));	
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		// Long click Fragola -> Delete - Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));	
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		//CHECKOUT con NESSUN ELEMENTO
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
		
		
		//CLEAR LIST -> OK
		// Click on action bar item
		solo.clickOnActionBarItem(0x9);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		//PREFERENCES: LMSO: Alpha_desc, SMSO: Alpha_desc
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!",solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Descending
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 1));	
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Descending
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.text1, 1));	
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// 2 Elementi sono inseriti EX-NOVO, 2 elementi sono inseriti tramite suggerimento
		// Click on Empty Text View
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		// Enter the text: 'Fr'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Fr");
		// Click on Fragola
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1));	
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Enter the text: 'Fragola'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Fragola");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Click on Empty Text View
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		// Enter the text: 'Mela'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Mela");
		// Click on Mela
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1));	
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Enter the text: 'Mela'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Mela");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Enter the text: 'Lamponi'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Lamponi");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Enter the text: 'Basilico'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Basilico");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		
		// Long click Basilico -> Edit - OK
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Enter the text: 'Basilico'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Basilico");
		// Click on Basilico
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.edit));
		// Enter the text: 'Prezzemolo'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Prezzemolo");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		// Long click Lamponi -> Delete - OK
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		// Long click Fragola -> IN_TROLLEY
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on In trolley 
		solo.clickInList(1, 0);
		
		
		// Long click Mela -> OFF_LIST
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Off list 
		solo.clickInList(2, 0);
		
		
		//CHECK-OUT con un ELEMENTO
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
		
		//CLEAR LIST con un ELEMENTO
		// Click on action bar item
		solo.clickOnActionBarItem(0x9);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		
		// Click on Add -> PROVA INSERIMENTO CON EDITTEXT VUOTO
		// Vengono visualizzati gli elementi gi inseriti in precedenza (non  stato realizzato il reset!)
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		
		//CLICK sul primo elemento della lista (in delete state)
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		

		
		/*
		// ELEMENTI AGGIUNTI SUCCESSIVAMENTE RISPETTO ALLA FASE IN LAB
		
		// Click on Add -> PROVA INSERIMENTO CON EDITTEXT VUOTO
		// Vengono visualizzati gli elementi gi inseriti in precedenza (non  stato realizzato il reset!)
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
				

		//LONGCLICK sul secondo elemento della lista (in delete state) -> ON_LIST
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on In trolley 
		solo.clickInList(1, 0);
		
		
		//LONGCLICK sul terzo elemento della lista (in delete state) -> ON_TROLLEY
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 2));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 2));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Off list 
		solo.clickInList(2, 0);
		
		
		//LONGCLICK sul quarto elemento della lista (in delete state) -> EDIT - OK
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 3));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 3));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Click on element
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.edit));
		// Enter the text: 'Birra'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit), "Birra");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		//LONGCLICK sul quinto elemento della lista (in delete state) -> DELETE - OK
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 4));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 4));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
			
		
		// Click on Add -> PROVA INSERIMENTO CON EDITTEXT VUOTO
		// Vengono visualizzati gli elementi gi inseriti in precedenza (non  stato realizzato il reset!)
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));		
		
		//Inserisci elemento (delete) tramite ADD
		// Enter the text: 'Birra'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Birra");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		*/
		
		
		//RESET LIST
		// Click on action bar item
		solo.clickOnActionBarItem(0xa);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		//PREFERENCES: LMSO: MOD_asc, SMSO: MOD_asc
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Modified Ascending
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 2));	
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Modified Ascending
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 2));
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// Enter the text: 'Zucchero'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Zucchero");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Enter the text: 'Fragole'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Fragole");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		
		// Click on Fragole: OFF_TROLLEY -> ON_TROLLEY
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		
		// Long click Fragole
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on On list: ON_TROLLEY -> OFF_TROLLEY
		solo.clickInList(1, 0);
		
		
		// Click on Zucchero: OFF_TROLLEY -> ON_TROLLEY
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		
		// Click on Zucchero: ON_TROLLEY -> OF_TROLLEY
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		
		
		//CLEAR LIST
		// Click on action bar item
		solo.clickOnActionBarItem(0x9);
		// Click on OK
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		//PREFERENCES: LMSO: MOD_desc, SMSO: MOD_desc
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Modified Descending
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.text1, 3));	
		solo.clickOnView(solo.getView(android.R.id.text1, 3));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Modified Descending
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.text1, 3));	
		solo.clickOnView(solo.getView(android.R.id.text1, 3));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// Enter the text: 'Pesche'
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "Pesche");
		
		// Click on Add
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Click on Pesche
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		
		// Long click Pesche -> chiudi menu' 
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Wait for dialog to close
		solo.sleep(3000); solo.waitForDialogToClose(5000);
		
		//CHECK-OUT con tutti gli elementi disattivi
		// Click on action bar item
		solo.clickOnActionBarItem(0x3);
		
		
		//PREFERENCES: LMSO: Alpha_asc, SMSO: Alpha_asc
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Click on List mode sort order Order of items on the list when in list mode LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Ascending
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.text1));	
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Click on Shopping mode sort order Order of items on the list when in shopping mode L
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Alphabetical Ascending
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.text1));	
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		// APRI IL MENU' da MENU' (per valutare la presenza di un men differente in corrispondenza 
		//						  di un'activity differente da main_activity -> non presente)
		
		// Click on action bar item
		solo.clickOnActionBarItem(0x4);
		// Wait for activity: 'caldwell.ben.trolly.TrollyPreferences'
		assertTrue("caldwell.ben.trolly.TrollyPreferences is not found!", solo.waitForActivity(caldwell.ben.trolly.TrollyPreferences.class));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
	
		// Inserimento elementi con spazi e valori numerici
		// Enter the text: ' 08 Dsd'
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), " 08 Dsd");
		// Click on Add
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		// Enter the text: 'A +'
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), "A +");
		// Click on Add
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		/*
		// Inserimento elemento gi presente in lista (nessun controllo su elem. raddoppiati)
		// Enter the text: ' 08 Dsd'
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), " 08 Dsd");
		// Click on Add
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
					
		// Long click  08 Dsd -> DELETE elem inserito
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		*/
		
		// EDIT su elemento -> sar associata al dato elemento una stringa vuota
		// Long click A +
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 1));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(3, 0);
		// Click on A +
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.edit));
		//Svuota Stringa
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.edit));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.edit));
		// Click on OK
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		/*
		// Enter the text: ' 08 Dsd2'
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), " 08 Dsd2");
		// Click on Add
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		
		
		//INSERISCI DA SUGGERIMENTO 2
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.textbox));
		// Enter the text: ' 08'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), " 08");
		// Click on Elemento2
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 1));	
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Enter the text: ' 08 Dsd2'
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.textbox));	
		solo.clearEditText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox));
		solo.enterText((android.widget.EditText) solo.getView(caldwell.ben.trolly.R.id.textbox), " 08 Dsd2");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.btn_add));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.btn_add));
		
		
		// Click on Elemento2: OFF_TROLLEY -> ON_TROLLEY
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item, 2));	
		solo.clickOnView(solo.getView(caldwell.ben.trolly.R.id.item, 1));
		
		
		// DELETE
		solo.sleep(3000); solo.waitForView(solo.getView(caldwell.ben.trolly.R.id.item));	
		solo.clickLongOnView(solo.getView(caldwell.ben.trolly.R.id.item));
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(4, 0);
		// Click on OK
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		//RESET LIST con pi elementi (alcuni OnList ed alcuni InTrolley)
		// Click on action bar item
		solo.clickOnActionBarItem(0xa);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));	
		solo.clickOnView(solo.getView(android.R.id.button1));
		*/
		
		// Press menu back key
		// solo.sleep(5000);
		// solo.goBack();
		// solo.sleep(5000);
		
		
		// Wait for activity: 'caldwell.ben.trolly.Trolly'
		//solo.sleep(2000); solo.waitForActivity(caldwell.ben.trolly.Trolly.class, 2000);
		
				
	}
}
