package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class TippyTipperTest_SG extends ActivityInstrumentationTestCase2<TippyTipper> {
  	private Solo solo;
  	
  	public TippyTipperTest_SG() {
		super(TippyTipper.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		
		//TEST dell'applicazione TIPPY TIPPER
		//le informazioni circa il test funzionale saranno riportate sotto forma di commento
		//prima del blocco di codice corrispondente
					
		//Si provveder inoltre a testare tutti i tasti (ove possibile, mediante CLICK e LONGCLICK) 
		//in corrispondenza di ogni possibile schermata riportata a video (come ad es. i tasti OK e CANCEL
		//dei Dialog, tutti i button del tastierino numerico) in modo tale da valutare un comportamento
		//corretto dell'app. in corrispondenza di tali eventi ed in modo tale da massimizzare la 
		//copertura del codice sorgente (white box).
						
		//Il test dell'applicazione era in precedenza impossibile in quanto non risultava possibile
		//accedere alle View mediante il metodo "getView()": tale situazione era determinata da un
		//problema di "rendering" -> l'applicazione non riusciva ad accedere alla view in quanto
		//probabilmente ancora non riportate a video (specie per alcuni elementi generati dinamicamente,
		//come ad esempio i Button associati ad un Dialog). Per ovviare tale problematica si usufruisce
		//quindi dei metodi waitForView(), waitForDialogToOpen() - gi presente -, e solo.sleep(),
		//utilizzato in corrispondenza della pressione del tasto Back (alcune volte non rilevato).
		//Si  deciso di utilizzare tale soluzione per tutti gli elementi (View) acceduti, in maniera
		//"indiscriminata", dato che il malfunzionamento risultava intermittente.
		//Tale soluzione minimizza ma non elimina il problema (potrebbe dipendere anche dalle performance
		//del calcolatore utilizzato per condurre il test).
		
		//Vi  stata inoltre la necessit di commentare alcune LOC in quanto relative ad eventi rilevati da
		//ROBOTIUM mediante Capture and Replay ma non effettivamente scaturiti durante la sessione
		//(L'esecuzione risultava impossibile dato che l'applicazione cercava View non pi presenti 
		//su schermo - ad esempio in seguito alla chiusura di un Dialog o alla modifica di un' Activity).

		//Risultava inoltre impossibile provvedere all'esecuzione del test tramite Junit in quanto 
		//le varie voci del men si rivelavano inaccessibili tramite il metodo
		//solo.clickOnActionBarItem(); -> si  quindi deciso di editare tale file commentando il metodo 
		//precedentemente descritto ed usufruendo del metodo "clickOnMenuItem(string Stringa)", dove
		//il parametro stringa identifica la voce del men alla quale si desidera accedere.
				
		//E' stata valutata la funzionalit di offerta dall'applicazione in corrispondenza di tutti 
		//i valori di settings utilizzabili:
		// ENABLE_EXCLUDE_TAX = true,false
		// TAX (con EET==TRUE) = uguale a zero, diversa da zero
		// ROUND_TYPE = ROUND_TIP, ROUND_TOTAL
		// ENABLE_ERROR_LOGGING = true, false
				
		// Si accede inoltre al menu' sia in corrispondenza della MainActivity (About, Settings) sia
		// in corrispondenza dell'activity Calcucate (in tal caso il men acceduto differisce dal precedente).
		
		
		
		
		
		//Le funzionalit testate - nonch gli elementi utilizzati - sono riportati di seguito:
		
		
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		solo.sleep(2000); solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);
		
		
		// DELETE con stringa TOTALE vuota (nessuna eliminazione)
		// Click on DEL
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$0.00'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		
		// CLEAR con stringa TOTALE vuota
		// Click on CLEAR
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Enter the text: '$0.00'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		
		
		
		
		// Valuta le funzionalit dell'applicazione in corrispondenza di un costo totale nullo
		// (La schermata successiva  comunque visualizzata)
		
		// Click on Calculate!
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		
		// Click su TIP1
		// Click on 10%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		
		// Click su TIP2
		// Click on 15%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		
		// Click su TIP3
		// Click on 20%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		
		// Click su ROUND_Type1
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// Click su ROUND_Type2
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		
		// MODIFICA BAR (TIP)
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 40);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 0);
		
		
		// BACK su MAIN ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		// APRI MENU' (About) da MAIN ACTIVITY
		// Click on action bar item
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.about));
		//solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		solo.clickOnMenuItem("About");
		// Click on About
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.title));
		solo.clickOnView(solo.getView(android.R.id.title));
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		
		// Set default small timeout to 11154 milliseconds
		Timeout.setSmallTimeout(11154);
		
		// BACK su MAIN ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		// Set default small timeout to 19807 milliseconds
		Timeout.setSmallTimeout(19807);
		
		
		
		// APRI MENU' (Settings) da MAIN ACTIVITY
		// Click on action bar item
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.settings));
		//solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		solo.clickOnMenuItem("Settings");
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		
		
		// MODIFICA "Default TIP" mediante BAR, CANCEL
		// Click on Default Tip Percentage Percentage to tip by default LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 0);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// MODIFICA "First TIP" mediante BAR, CANCEL
		// Click on First Tip Percentage Custom value for first tip percentage preset button Li
		solo.clickInList(3, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 24);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// MODIFICA "Second TIP" mediante BAR, CANCEL
		// Click on Second Tip Percentage Custom value for second tip percentage preset button 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 12);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// MODIFICA "Third TIP" mediante BAR, CANCEL
		// Click on Third Tip Percentage Custom value for third tip percentage preset button Li
		solo.clickInList(5, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// CLICK SU EET -> ATTIVA
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickInList(7, 0);
		
		// CLICK SU EET -> DISATTIVA
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickInList(7, 0);
		
		// CLICK SU TaxToExclude -> Voce disattiva
		// Scroll to Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView0 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView0, 3);
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Tax Rate to Exclude"));
		
		
		// CLICK SU ROUND_TYPE -> CANCEL
		// Click on Round Type Choose to round by tip or total LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Round Type"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		
		// CLICK SU Default Number of People: 
		//		"-" fino a raggiungere 1  (valore minimo:  2) : viene riportato il valore massimo 20
		//      CANCEL
		
		// Click on Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Enter the text: '20'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "20");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Enter the text: '19'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "19");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '20'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "20");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '2'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		// CLICK su ENABLE ERROR LOGGING -> DISATTIVA
		// Scroll to Enable Error Logging Application reports anonymous error/event information 
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView1 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView1, 4);
		// Click on Enable Error Logging Application reports anonymous error/event information 
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		
		
		// BACK SU ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		
		
		// INSERISCI IL TOTALE: 12.956 e valuta le fuzionalit dell'applicazione
		
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Enter the text: '$0.01'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.01");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$0.10'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.10");
		// Click on net.mandaria.tippytipper.R$id.btn_nine
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Enter the text: '$1.09'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1.09");
		// Click on net.mandaria.tippytipper.R$id.btn_five
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Enter the text: '$10.95'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$10.95");
		// Click on net.mandaria.tippytipper.R$id.btn_six
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		// Enter the text: '$109.56'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$109.56");
		
		// Click on Calculate!
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		
		
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		
		// DEFAULT TIP (round_up, round_down)
		// Click on 24%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		
		// FIRST TIP (round_up, round_down)
		// Click on 12%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		
		// SECOND TIP (round_up, round_down)
		// Click on 20%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// MODIFICA SEEK_BAR (MAX, MIN, valore_intermedio)
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 40);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 0);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 16);
		
		
		// SPLIT (add, remove)
		// Click on Split Bill
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		
		
		// BACK su CALCULATE_ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		// BACK su MAIN ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		// CLEAR (con EDIT_TEXT non nullo)
		// Click on CLEAR
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Enter the text: '$0.00'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.00");
		
		
		// APRI MENU' (Settings) da MAIN ACTIVITY
		// Click on action bar item
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.settings));
		//solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		solo.clickOnMenuItem("Settings");
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		
		// MODIFICA DEFAULT TIP mediante BAR -> OK
		// Click on Default Tip Percentage Percentage to tip by default LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 7);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// MODIFICA FIRST TIP mediante BAR -> OK
		// Click on First Tip Percentage Custom value for first tip percentage preset button Li
		solo.clickInList(3, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 8);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// MODIFICA SECOND TIP mediante BAR -> OK
		// Click on Second Tip Percentage Custom value for second tip percentage preset button 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 31);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 40);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// MODIFICA THIRD TIP mediante BAR -> OK
		// Click on Third Tip Percentage Custom value for third tip percentage preset button Li
		solo.clickInList(5, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.SeekBar.class, 0));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 16);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// CLICK su EET -> ATTIVA
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickInList(7, 0);
		// Scroll to Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView2 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView2, 2);
		
		
		
		// CLICK su TAX_RATE -> MODIFICA e OK:
		//		pressione dei 2 tasti "-" fino a raggiungere "0" -> visualizzato 9.999 %
		//      riporta su 0.002 % (CLICK su tasti "+")
		
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Tax Rate to Exclude"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Enter the text: '999'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "999");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '0'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Enter the text: '000'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "000");
		// Enter the text: '0'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Enter the text: '001'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "001");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Enter the text: '000'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "000");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Enter the text: '001'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "001");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Enter the text: '002'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "002");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: '0'
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		//solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		//solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Click on Round Type Choose to round by tip or total LinearLayout
		
		
		// CLICK su ROUND_TYPE (ROUND_tip)
		solo.clickOnText(java.util.regex.Pattern.quote("Round Type"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Round Tip
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1));
		solo.clickOnView(solo.getView(android.R.id.text1));
		
		
		
		// CLICK su SPLIT BILL:
		//		"+" fino a raggiungere 21 (valore massimo: 20): viene riportato il valore minimo 2
		//		setta poi su 3
		
		// Scroll to Default Number People The number of people to split bill by LinearLayout
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView3 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView3, 3);
		// Click on Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '3'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '4'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "4");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '5'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "5");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '6'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "6");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '7'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "7");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '8'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "8");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '9'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "9");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '10'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "10");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '11'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "11");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '12'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "12");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '13'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "13");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '14'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "14");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '15'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "15");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '16'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "16");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '17'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "17");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '18'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "18");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '19'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "19");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '20'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "20");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '2'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '3'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '4'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "4");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Enter the text: '3'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: '3'
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		//solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		//solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		
		// CLICK su ENABLE ERROR LOG -> ATTIVA
		// Scroll to Enable Error Logging Application reports anonymous error/event information 
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView4 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView4, 4);
		// Click on Enable Error Logging Application reports anonymous error/event information 
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		
		
		// BACK su MAIN ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		
		// INSERISCI il totale "23,4780"
		// TESTA IL TASTO DELETE -> totale = 23,478
		
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Enter the text: '$0.02'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.02");
		// Click on net.mandaria.tippytipper.R$id.btn_three
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Enter the text: '$0.23'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$0.23");
		// Click on net.mandaria.tippytipper.R$id.btn_four
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_four));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_four));
		// Enter the text: '$2.34'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$2.34");
		// Click on net.mandaria.tippytipper.R$id.btn_seven
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_seven));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_seven));
		// Enter the text: '$23.47'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$23.47");
		// Click on net.mandaria.tippytipper.R$id.btn_eight
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Enter the text: '$234.78'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$234.78");
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Enter the text: '$2,347.80'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$2,347.80");
		// Click on DEL
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Enter the text: '$234.78'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$234.78");
		
		// Click on Calculate!
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		
		
		// FIRST TIP (round_up, round_down)
		// Click on 8%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// SECOND TIP (round_up, round_down)
		// Click on 40%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// THIRD TIP (round_up, round_down)
		// Click on 16%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// MODIFICA SEEKBAR (MAX, MIN, valore intermedio)
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 40);
		// Set progress on SeekBar
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage));
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 0);
		
		// SPLIT (ADD, REMOVE)
		// Click on Split Bill
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		
		
		
		// BACK SU CALCULATE ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// APRI MENU' (About) da CALCULATE ACTIVITY (ogni activity presenta un proprio menu')
		// Click on action bar item
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.about));
		//solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		solo.clickOnMenuItem("About");
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		
		
		// BACK SU CALCULATE ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// APRI MENU' (Settings) da CALCULATE ACTIVITY
		// Click on action bar item
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.settings));
		//solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		solo.clickOnMenuItem("Settings");
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		
		
		

		// TEST FUNZIONALITA' con tassa da escludere pari a zero
		
		// Scroll to Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView5 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView5, 1);
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Tax Rate to Exclude"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Tax Rate to Exclude"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Enter the text: '002'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "002");
		// Enter the text: '0'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Enter the text: '001'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "001");
		// Click on ImageView
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Enter the text: '000'
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "000");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Enter the text: '0'
		//solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		//solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		//solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		
		
		// CLICK SU ROUND_TYPE (round total)
		// Scroll to Round Type Choose to round by tip or total LinearLayout
		solo.sleep(2000); solo.waitForView(solo.getView(android.widget.ListView.class, 0));
		android.widget.ListView listView6 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView6, 3);
		// Click on Round Type Choose to round by tip or total LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Round Type"));
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Round Total
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 1));
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		
		
		// BACK SU CALCULATE ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		

		// DEFAULT TIP (round_up, round_down)
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// FIRST TIP (round_up, round_down)
		// Click on 16%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		
		// SECOND TIP (round_up, round_down)
		// Click on 40%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		
		// 3 TIP (round_up, round_down)
		// Click on 8%
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on Round Down
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.sleep(2000); solo.waitForView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		
		
		// BACK su MAIN ACTIVITY
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		// Press menu back key
		//solo.sleep(5000);
		//solo.goBack();
		//solo.sleep(5000);
		
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		//assertTrue("net.mandaria.tippytipper.activities.TippyTipper is not found!", solo.sleep(2000); solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class));
		
		// Click on net.mandaria.tippytipper.R$id.btn_one
		//solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		
	}
}
