package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTest_SG extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
  	private Solo solo;
  	
  	public SimplyDoActivityTest_SG() {
		super(SimplyDoActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		
		//TEST dell'applicazione SIMPLYDO
		//le informazioni circa il test funzionale saranno riportate sotto forma di commento
		//prima del blocco di codice corrispondente
		
		//Si provveder inoltre a testare tutti i tasti (ove possibile, mediante CLICK e LONGCLICK) 
		//in corrispondenza di ogni possibile schermata riportata a video (come ad es. i tasti OK e CANCEL
		//dei Dialog) in modo tale da valutare un comportamento corretto dell'app. in corrispondenza di 
		//tali eventi ed in modo tale da massimizzare la copertura del codice sorgente (white box).
		
		//Il test dell'applicazione era in precedenza impossibile in quanto non risultava possibile
		//accedere alle View mediante il metodo "getView()": tale situazione era determinata da un
		//problema di "rendering" -> l'applicazione non riusciva ad accedere alla view in quanto
		//probabilmente ancora non riportate a video (specie per quegli elementi generati dinamicamente,
		//come ad esempio i Button associati ad un Dialog). Per ovviare tale problematica si usufruisce
		//quindi dei metodi waitForView(), waitForDialogToOpen() - gi presente -, e solo.sleep(),
		//utilizzato in corrispondenza della pressione del tasto Back (alcune volte non rilevato).
		//Si  deciso di utilizzare tale soluzione per tutti gli elementi (View) acceduti, in maniera
		//"indiscriminata", dato che il malfunzionamento risultava intermittente.
		//Tale soluzione minimizza ma non elimina il problema (potrebbe dipendere anche dalle performance
		//del calcolatore utilizzato per condurre il test).
		
		//Viene inoltre testato lo spostamento di elementi nei vari stati (ACTIVE, WITH STAR...) 
		//tra differenti liste
		
		//E' stata valutata la funzionalit di ordinamento delle liste e degli elementi all'interno 
		//delle stesse in corrispondenza di tutti i valori di ITEM_SORTING e LIST_SORTING, mediante 
		//l'utilizzo della voce SORT_NOW (menu') in corrispondenza di varie situazioni (tutti gli elem.
		//attivi, tutti gli elem. disattivi, elem con STAR...).
		
		
		//Una delle 3 classi (sulle 46 complessive) per le quali non risulta possibile garantire alcuna
		//copertura  "L.java": questa contiene semplicemente il Tag di Log utilizzato da SimplyDo;
		//il suo metodo non  per mai richiamato
		
		//La seconda classe  "SimpleDataViewer.java": la classe SimplyDo non utilizza infatti tale 
		//classe (l'operazione di creazione di un oggetto simpledataviewer  commentata!) bens
		//usufruisce della classe CachingDataViewer (simile alla precedente, in termini di metodi utilizzati);
		//non risulta quindi possibile coprire i suoi 21 metodi.
		
		//La terza classe  invece "NameOnlyFile" associata all'activity Restore: tale classe non pu
		//esser coperta vista l'impossibilit di creare i file di Restore sul dispositivo utilizzato
		//(nello specifico, uno dei 2 metodi viene utilizzato per realizzare il refresh dei file
		//di report, l'altro ne estrapola il nome).
		
		
		//Per le stesse motivazioni risulta impossibile coprire totalmente la classe RestoreActivity
		//(per la quale  comunque garantita una copertura del 43% in termini di metodi):
		//gran parte delle LOC non possono essere direttamente utilizzate; 
		//alcune sono per state comunque coperte (infatti, mediante esecuzione,si accede comunque 
		//alla schermata contenente i potenziali file di Restore, si richiede di creare un file di Backup,
		// nonostante l'operazione non sia effettivamente possibile); non risulta per possibile coprire, 
		//tra le altre, alcune LOC, come ad esempio quelle relative alla pressione dei tasti del dialog 
		//di Restore (dato che questo non viene effettivamente creato), n coprire i metodi
		//potenzialmente utilizzabili in tale contesto.
		
		//Non potendo realizzare il backup non  neppur possibile garantire la copertura dei metodi
		//"copyDB()","FileCopy()", nonch la copertura totale (in LOC) del metodo "backupDBselected()"
		//(tutti i metodi appartengono alla classe SettingsActivity.java), dei metodi "FetchList()",
		//"FetchItem()","flush()", "invalidatecache()","dbUpdateloop()" (CachingDataViewer.java).
		
		//Per quanto concerne i metodi "ItemIdBarrier()","FlushTaskNoLock()","doTaskandWait()","moveItem()"
		//non risulta possibile garantire una copertura completa dei blocchi, vista l'impossibilit
		//di riprodurre "situazioni limite" per tali metodi (ad esempio, per il metodo ItemIdBarrier(),
		//in corrispondenza di un item_ID pari a -1 - che indica che l'identificativo  stato gi utilizzato-
		// impossibile, dopo l'utilizzo del metodo flushtask(), determinare l'insorgenza della stessa 
		//condizione - ID==-1 -, che ci permetterebbe di eseguire il blocco di codice corrispondente;
		//lo stesso ragionamento pu esserre associato al metodo "createitem()" della classe DataManager).
		
		//Il metodo "ListDesc()", relativo all'omonima classe, non viene mai richiamato (non fa nulla).
		
		//Non  possibile neppure provvedere alla copertura del metodo DBupgrade() (file Datamanager.java,
		//classe DatabaseHelper) legato alla necessit di aggiornare il DB quando necessario.
		
		
		//Le funzionalit testate - nonch gli elementi utilizzati - sono riportati di seguito:
		
		
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.sleep(2000); solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		
		
		//APRI MENU' (Settings) da Main Activity
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		
		
		//Valuta il modus operandi dell'aplicazione quando in corrispondenza dei 2 valori di Settings
		//non  settata alcuna voce specifica.
		//(si ricorda infatti che l'app viene testata in seguito ad una reinizializzazione della stessa)
		
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		// DELETE ALL INACTIVE: Click (disattiva)
		// Click on Confirm Delete All Inactive  LinearLayout
		solo.clickInList(3, 0);
		
		
		// BACKUP -> Il dispositivo (su AVD) non permette la creazione del file di Restore
		//          Verr visualizzato un Toast di avviso su schermo
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		
		// Restore -> Accedi e Indietro (Test della View)
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		
		
		// Prova ad aprire Menu' da Menu' (da RESTORE)
		// (per valutare la presenza di un Men differente in corrispondenza delle varie Activity)
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		
		// Esci da schermata RESTORE
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		// Set default small timeout to 12473 milliseconds
		Timeout.setSmallTimeout(12473);
		
		// Ritorna su elenco liste
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		
		// Le 2 liste presentano nomi tali da valutare la metodologia di ordinamento delle liste utilizzato
		// Enter the text: 'Blista'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Blista");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		
		// Enter the text: 'Alista'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Alista");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		
		
		// Enter the text: 'Alista' (Valuta come sono gestiti eventuali diplicati di lista)
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Alista");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
				
		// DELETE LISTA (elimina duplicato)
		// Long click 'Alista' (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		
		
		// Accedi a Blista
		// Click on Blista (0/0)
		solo.clickInList(2, 0);
		
		// Inserimento con stringa vuota -> nessun inserimento
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
	
		// Nuovo Elemento
		// Enter the text: 'Attivare scheda'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Attivare scheda");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Nuovo Elemento (Valuta come sono gestiti eventuali duplicati di Item)
		// Enter the text: 'Attivare scheda'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Attivare scheda");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Delete 'Attivare scheda'
		// Long click passeggiata ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		
		// ADD STAR su 'Attivare scheda' (Elemento attivo)
		// Long click Attivare scheda ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		
		// Nuovo Elemento
		// Enter the text: 'Fare compere'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Fare compere");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Click su 'Fare compere' (senza stella) -> Disattiva
		// Click on Fare compere ImageSwitcher
		solo.clickInList(1, 0);
		
		// Nuovo elemento
		// Enter the text: 'Zio'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Zio");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// ADD STAR su 'Zio' (elemento attivo)
		// Long click Zio ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		
		// Click su 'Zio' (con stella) -> Disattiva
		// Click on Zio ImageSwitcher
		solo.clickInList(1, 0);
		
		// Nuovo Elemento
		// Enter the text: 'Marco08'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Marco08");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Nuovo Elemento
		// Enter the text: 'Aggiornare lista'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Aggiornare lista");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// ATTIVA -> DISATTIVA -> ATTIVA (mediante 2 click)
		// Click on Attivare scheda ImageSwitcher
		solo.clickInList(5, 0);
		// Click on Attivare scheda ImageSwitcher
		solo.clickInList(5, 0);
		
		
		// Set default small timeout to 16310 milliseconds
		Timeout.setSmallTimeout(16310);
		
		// Click -> Disattiva 'Aggiornare Lista'
		// Click on Aggiornare lista ImageSwitcher
		solo.clickInList(1, 0);
		
		// ADD STAR su 'Aggiornare Lista' (elemento disattivo)
		// Long click Aggiornare lista ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		
		
		// ADD con EDIT TEXT vuoto
		// Click on Empty Text View
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		
		// ORDINA LISTA
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// Reinserisci elemento disattivo ('Fare compere') tramite EDIT TEXT
		// Enter the text: 'Fare compere'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Fare compere");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Reinserisci elemento disattivo ('Fare compere') tramite CLICK
		// Click on Zio ImageSwitcher
		solo.clickInList(5, 0);

		// DELETE inattivi (pi di uno)
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		
		// DELETE inattivi (nessuno)
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		
		// Back su elenco liste
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
        // Accedi a Alista
		// Click on Alista (0/0)
		solo.clickInList(1, 0);
		
		// Apri MENU' (Settings) da Lista -> Utilizzato per verificare se vi siano differenti Menu'
		// in corrispondenza dell'elenco delle liste e dell'elenco degli elementi
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		
		
		// Item Sorting: NONE, List Sorting: NONE
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on None
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1));
		solo.clickOnView(solo.getView(android.R.id.text1));
		
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on None
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1));
		solo.clickOnView(solo.getView(android.R.id.text1));
		
		
		// Delete all inactive -> Click (attiva)
		// Click on Confirm Delete All Inactive  LinearLayout
		solo.clickInList(3, 0);
		
		
		// BACKUP and RESTORE
		// Click on Backup Now  LinearLayout
		solo.clickInList(4, 0);
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// Nuovo Elemento
		// Enter the text: 'correre'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "correre");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		
		// Click su 'correre' (senza stella) -> disattiva
		// Click on correre ImageSwitcher
		solo.clickInList(1, 0);

		// Nuovo Elemento
		// Enter the text: 'cena'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "cena");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Nuovo Elemento
		// Enter the text: 'appuntamento'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "appuntamento");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Click su 'appuntamento' (senza stella) -> disattiva
		// Click on appuntamento ImageSwitcher
		solo.clickInList(1, 0);
		
		// ADD STAR su 'appuntamento'
		// Long click appuntamento ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		
		
		// EDIT su 'appuntamento' -> MODIFICA e CANCEL
		// Long click appuntamento ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on appuntamento
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'app'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "app");
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		
		// EDIT su 'cena' -> STRINGA VUOTA
		// Long click cena ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: 'cena'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "");
		// Click on cena
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		// EDIT su 'correre' -> inserisci 'passeggiata', OK
		// Long click correre ImageSwitcher
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: 'correre'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "correre");
		// Click on correre
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'passeggiata'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "passeggiata");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		// MOVE 'cena' TO BLISTA -> CANCEL
		// Long click cena ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// DELETE 'cena' -> YES
		// Long click cena ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
	
		// DELETE 'passeggiata'
		// Long click passeggiata ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		
		
		// CLICK su 'appuntamento' -> attiva
		// Click on appuntamento ImageSwitcher
		solo.clickInList(1, 0);
		
		// DELETE 'appuntamento' -> NO
		// Long click appuntamento ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(3000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on No
		solo.sleep(3000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		// CLICK su 'appuntamento' -> disattiva
		// Click on appuntamento ImageSwitcher
		solo.clickInList(1, 0); 
		
		
		// SORT NOW
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// DELETE ALL INACTIVE -> YES
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// SORT NOW
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// RITORNA AD ELENCO LISTE
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// EDIT su 'Alista' -> STRINGA VUOTA -> OK (nessuna modifica apportata)
		// Long click Alista (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Alista
		solo.sleep(3000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Click on OK
		solo.sleep(5000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// EDIT su 'Alista' -> MODIFICA e OK (mod ordinamento)
		// Long click Alista (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(5000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: 'Alista'
		solo.sleep(5000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "Alista");
		// Click on Alista
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		// Enter the text: 'AlistaMod'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "Clista");
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// DELETE su 'AlistaMOD' -> YES
		// Long click AlistaMod (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		// EDIT 'Blista' -> CANCEL
		// Long click Blista (4/4)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Enter the text: 'Blista'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "Blista");
		// Click on Cancel
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// DELETE 'Blista' -> NO
		// Long click Blista (4/4)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on No
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		
		// NUOVA LISTA
		// Enter the text: '3'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "3");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		
		// Accedi alla lista '3'
		// Click on 3 (0/0)
		solo.clickInList(1, 0);
		
		
		// APRI MENU' (Setting) da lista
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		
		// ITEM_SORTING: Starred First, LIST_SORTING: ALPHABETICAL
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Starred First
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 1));
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Alphabetical
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 1));
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		
		// RITORNA su lista '3'
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		// NUOVO ELEMENTO
		// Enter the text: 'Frutta'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Frutta");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// NUOVO ELEMENTO
		// Enter the text: 'Verdura'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Verdura");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// NUOVO ELEMENTO
		// Enter the text: 'Piante'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Piante");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// NUOVO ELEMENTO
		// Enter the text: 'Gioielli'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "Gioielli");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// SORT NOW
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// ADD STAR su 'Gioelli'
		// Long click Gioielli ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		
		// CLICK su 'Gioielli' -> disattiva
		// Click on Gioielli ImageSwitcher
		solo.clickInList(2, 0);
		
		// CLICK su 'Piante' -> disattiva
		// Click on Piante ImageSwitcher
		solo.clickInList(3, 0);
		
		// SORT NOW
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// SPOSTA 'Verdura' (attivo, no STAR) su 'Blista'
		// Long click Verdura ImageSwitcher
		solo.clickLongInList(4, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Click on Blista
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1));
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// SPOSTA 'Piante' (disattivo, no STAR) su 'Blista'
		// Long click Piante ImageSwitcher
		solo.clickLongInList(3, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Click on OK
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// BACK to elenco liste
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		// NUOVA LISTA
		// Enter the text: '4as'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "4as");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
			
		// NUOva LISTA
		// Enter the text: 'z5'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "z5");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		
		// DELETE LISTA (con un elemento attivo su due)
		// Long click 3 (1/2)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		// DELETE LISTA VUOTA
		// Long click 4as (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		// DELETE LISTA (utilizzata solo per valutare la metodologia di ordinamento delle liste)
		// Long click z5 (0/0)
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.sleep(2000); solo.waitForDialogToClose(5000);
		
		
		// Accedi a 'Blista'
		// Click on Blista (5/6)
		solo.clickInList(1, 0);
		
		// APRI MENU' (Settings)
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		
		//ITEM_SORTING: ACTIVE FIRST
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Active First
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.text1, 2));
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		
		// BACK TO 'Blista'
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// SORT NOW
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// RIMUOVI LA STELLA a tutti gli elementi della lista
		// Long click Attivare scheda ImageSwitcher
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Remove Star 
		solo.clickInList(3, 0);
		// Long click Zio ImageSwitcher
		solo.clickLongInList(2, 0);
		// Wait for dialog
		solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on Remove Star 
		solo.clickInList(3, 0);
		
		
		// DISATTIVA TUTTI GLI ELEMENTI tranne 'ZIO'
		// Click on Attivare scheda ImageSwitcher
		solo.clickInList(1, 0);
		// Click on Fare compere ImageSwitcher
		solo.clickInList(3, 0);
		// Click on Marco08 ImageSwitcher
		solo.clickInList(4, 0);
		// Click on Verdura ImageSwitcher
		solo.clickInList(5, 0);
		
		// ORDER NOW -> per la metodologia di ITEM_SORTING utilizzata
		// l'elemento 'Zio' diviene il primo della lista
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// CLICK su 'Zio' -> disattiva
		// Click on Zio ImageSwitcher
		solo.clickInList(1, 0);
		
		// ORDER NOW -> essendo tutti gli elementi disattivi ed avendo settato ITEM_SORTING su ACTIVE FIRST
		//              gli elementi verrano semplicemente ordinati alfabeticamente (zio diviene l'ultimo elem della lista)
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		// DELETE ALL INACTIVE (tutti)
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Click on Yes
		solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// NUOVO ELEMENTO
		// Enter the text: 'as'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "as");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// NUOVO ELEMENTO
		// Enter the text: 'q'
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "q");
		// Click on Add
		solo.sleep(2000); solo.waitForView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// CLICK su 'q' -> disattiva
		// Click on q ImageSwitcher
		solo.clickInList(1, 0);
		
		// ACCEDI AL MENU'
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		
		
		// CLICK su RESTORE (vedi nota a seguire)
		// Click on Restore  LinearLayout
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
	

		// Il Dispositivo (su AVM) non permette il salvataggio di un file di restore
		// di conseguenza non  possibile, mediante tale blocco, realizzare un'operazione di Restore.
		// Non si potr quindi provvedere alla copertura, in termini di LOC e blocchi, 
		// dellla componente del codice relativa alla visualizzazione del Dialog "Restore"

		// Long click SimplyDo_20141215_56163
		//solo.clickLongInList(1, 0);
		// Click on SimplyDo_20141215_56163
		//solo.clickInList(1, 0);
		// Wait for dialog
		//solo.sleep(2000); solo.waitForDialogToOpen(5000);
		// Click on No
		//solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button2));
		//solo.clickOnView(solo.getView(android.R.id.button2));
		// Wait for dialog to close
		//solo.sleep(2000); solo.waitForDialogToClose(5000);
		// Click on SimplyDo_20141215_56163
		//solo.clickInList(1, 0);
		// Click on Yes
		//solo.sleep(2000); solo.waitForView(solo.getView(android.R.id.button1));
		//solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		//solo.sleep(2000); solo.waitForDialogToClose(5000);
		

		// BACK TO LISTA -> BACK TO ELENCO LISTE
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		// Press menu back key
		solo.sleep(5000);
		solo.goBack();
		solo.sleep(5000);
		
		
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		//assertTrue("kdk.android.simplydo.SimplyDoActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class));
		
		// Click on Alista (0/0)
		//solo.clickInList(1, 0);
		
		
	}
}
