package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;

import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTest1 extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
  	private Solo solo;
  	
  	public SimplyDoActivityTest1() {
		super(SimplyDoActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);

		// White box
		/* XXX TEST SAVE INSTANCE */
		// Set activity orientation to landscape
		solo.setActivityOrientation(Solo.LANDSCAPE);
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Set activity orientation to portrait
		solo.setActivityOrientation(Solo.PORTRAIT);
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		
		/* XXX TEST INSERIMENTO ITEM */
		// Set default small timeout to 13054 milliseconds
		Timeout.setSmallTimeout(13054);
		// Click on list2 (0/0)
		solo.clickInList(1, 0);
		// Click on Empty Text View
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Enter the text: 'item3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item3");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Enter the text: 'item2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item2");
		// Press Enter key
		solo.sendKey(Solo.ENTER);
		// Enter the text: 'item1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "item1");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		/* XXX TEST TRANSIZIONE ACTIVE - INACTIVE DI UN ITEM */
		// Click on item3
		solo.clickOnText("item3");
		// Click on item3
		solo.clickOnText("item3");
		// Click on item3
		solo.clickOnText("item3");
//		solo.clickInList(3, 0);
		
		/* XXX TEST STELLA SU ITEM */
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Add Star 
		solo.clickInList(3, 0);
		
		/* XXX TEST CAMBIO ORDINAMENTO */
		// item1 active, item2 starred, item3 inactive
		// nessun ordinamento
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on None
		solo.clickOnText("None");
		// Press menu back key
		solo.goBack();
		// ordinamento active first
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Active First
		solo.clickOnView(solo.getView(android.R.id.text1, 2));
		// Press menu back key
		solo.goBack();
		// ordinamento starred first
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Item Sorting
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Starred First
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();

		// White box
		/* XXX TEST SORT NOW */
		// Click on action bar item
		solo.clickOnActionBarItem(0x6b);
		
		/* XXX TEST DELETE ALL INACTIVE */
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click on action bar item
		solo.clickOnActionBarItem(0x64);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		/* XXX TEST SPOSTAMENTO ITEM IN ALTRA LISTA */
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Cancel
		solo.clickOnText("Cancel");
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Move To 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on list1
		solo.clickOnText("list5");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));

		// White box
		/* XXX TEST MODIFICA ITEM */
		// Long click item1
		solo.clickLongOnText("item1");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on item1
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		// Enter the text: 'item2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText), "item2");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Long click item2
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Press Enter key
		solo.sendKey(Solo.ENTER);

		// White box
		/* XXX TEST CANCELLAZIONE ITEM */
		// Long click item2 
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Long click item2 
		solo.clickLongOnText("item2");
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		
		// White box
		/* XXX TEST RESTORE DALLA VISTA ITEM */
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Restore
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click on SimplyDo_20151218_37431
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Press menu back key
		solo.goBack();

		// White box
		/* XXX TEST SAVE INSTANCE */
		// Set activity orientation to landscape
		solo.setActivityOrientation(Solo.LANDSCAPE);
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Set activity orientation to portrait
		solo.setActivityOrientation(Solo.PORTRAIT);
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);

		// White box
		/* XXX TEST ON BACK PRESSED */
		// Click on list2 (0/0)
		solo.clickInList(1, 0);
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
	}
}
