package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;

import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
  	private Solo solo;
  	
  	public SimplyDoActivityTest() {
		super(SimplyDoActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		
		/* XXX TEST INSERIMENTO LISTA */
		// Enter the text: 'list1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "list1");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'liist3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "liist3");
		// Press Enter key
		solo.sendKey(Solo.ENTER);

		// White box
		/* XXX TEST SAVE INSTANCE */
		// Set activity orientation to landscape
		solo.setActivityOrientation(Solo.LANDSCAPE);
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Set activity orientation to portrait
		solo.setActivityOrientation(Solo.PORTRAIT);
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);

		// White box
		/* XXX TEST MODIFICA LISTA */
		// Long click liist3 (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Enter the text: 'list3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditListLabelEditText), "list3");
		// Press Enter key
		solo.sendKey(Solo.ENTER);
		// Long click list3 (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Long click list3 (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Edit 
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		/* XXX TEST CAMBIO ORDINAMENTO */
		// Nessun ordinamento
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on List Sorting
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Press menu back key
		solo.goBack();
		
		// Enter the text: 'list5'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "list5");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Enter the text: 'list2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "list2");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Ordinamento alfabetico
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical
		solo.clickOnText("Alphabetical");
//		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		// Press menu back key
		solo.goBack();
		
		/* XXX TEST BACKUP */
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Click on Backup Now
		solo.clickInList(4, 0);
		// Press menu back key
		solo.goBack();
		
		/* XXX TEST CANCELLAZIONE LISTA*/
		// Long click list1 (0/0)
		solo.clickLongInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on No
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Long click list1 (0/0)
		solo.clickLongInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Long click list2 (0/0)
		solo.clickLongInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Delete 
		solo.clickInList(2, 0);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		
		/* XXX TEST RESTORE DALLA VISTA LISTE */
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on Restore
		solo.clickInList(5, 0);
		// Wait for activity: 'kdk.android.simplydo.RestoreActivity'
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!", solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click on SimplyDo_20151218_37431
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		// Press menu back key
		solo.goBack();
	}
}
