/* Ulteriore test per coprire righe di codice rigurdanti:
 *  - l'ordinameno della lista e degli elementi a NONE;
 *  - rimozione di elementi inattivi (dal menu) senza conferma di eliminazione
 * */

package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;

import com.robotium.solo.*;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import android.test.ActivityInstrumentationTestCase2;


public class SimplyDoActivityTest1 extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
  	private Solo solo;
  	
  	public SimplyDoActivityTest1() {
		super(SimplyDoActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		
		//Precondizione: Gli oggetti inattivi possono essere eliminati senza conferma.
		Context appContext = getInstrumentation().getTargetContext();
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = prefs.edit();
		editor.putBoolean("confirmDeleteInactive", false);
		editor.commit();
		
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		// Sleep for 41946 milliseconds
		solo.sleep(1000);//solo.sleep(41946);
		// Click on action bar item
		solo.clickOnActionBarItem(0x6a);
		// Click on Settings
		solo.clickOnView(solo.getView(android.R.id.title));
		// Wait for activity: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!", solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Sleep for 12998 milliseconds
		solo.sleep(1000);//solo.sleep(12998);
		// Click on Item Sorting  LinearLayout
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Sleep for 3733 milliseconds
		solo.sleep(1000);//solo.sleep(3733);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Sleep for 6146 milliseconds
		solo.sleep(1000);//solo.sleep(6146);
		// Click on List Sorting  LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Sleep for 3328 milliseconds
		solo.sleep(1000);//solo.sleep(3328);
		// Click on None
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Sleep for 3726 milliseconds
		solo.sleep(1000);//solo.sleep(3726);
		// Press menu back key
		solo.goBack();
		// Sleep for 24405 milliseconds
		solo.sleep(1000);//solo.sleep(24405);
		// Enter the text: 'Lista B'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Lista B");
		// Sleep for 1644 milliseconds
		solo.sleep(1000);//solo.sleep(1644);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Sleep for 10853 milliseconds
		solo.sleep(1000);//solo.sleep(10853);
		// Enter the text: 'Lista A'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Lista A");
		// Sleep for 2593 milliseconds
		solo.sleep(1000);//solo.sleep(2593);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Sleep for 14781 milliseconds
		solo.sleep(1000);//solo.sleep(14781);
		// Enter the text: 'Lista C'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText), "Lista C");
		// Sleep for 2869 milliseconds
		solo.sleep(1000);//solo.sleep(2869);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		// Sleep for 12215 milliseconds
		solo.sleep(1000);//solo.sleep(12215);
		// Click on Lista C (0/0)
		solo.clickInList(1, 0);
		// Sleep for 10563 milliseconds
		solo.sleep(1000);//solo.sleep(10563);
		// Enter the text: 'c2'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "c2");
		// Sleep for 1056 milliseconds
		solo.sleep(1000);//solo.sleep(1056);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Sleep for 3602 milliseconds
		solo.sleep(1000);//solo.sleep(3602);
		// Enter the text: 'c1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "c1");
		// Sleep for 2292 milliseconds
		solo.sleep(1000);//solo.sleep(2292);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Sleep for 4520 milliseconds
		solo.sleep(1000);//solo.sleep(4520);
		// Enter the text: 'c3'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText), "c3");
		// Sleep for 1507 milliseconds
		solo.sleep(1000);//solo.sleep(1507);
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Sleep for 5265 milliseconds
		solo.sleep(1000);//solo.sleep(5265);
		solo.clickInList(1, 0);
		// Click on c1 ImageSwitcher
		solo.clickInList(2, 0);
		// Sleep for 12138 milliseconds
		
		//Menu Delete Inactive
		solo.clickOnActionBarItem(0x64);
		
		// Press menu back key
		solo.goBack();
	}
}
