package info.bpace.munchlife.test;

import info.bpace.munchlife.MunchLifeActivity;

import com.robotium.solo.*;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import android.test.ActivityInstrumentationTestCase2;


public class MunchLifeActivityTest2 extends ActivityInstrumentationTestCase2<MunchLifeActivity> {
  	private Solo solo;
  	
  	public MunchLifeActivityTest2() {
		super(MunchLifeActivity.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		Context appContext = getInstrumentation().getTargetContext();
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = prefs.edit();
		editor.putString("maxlevelPref", "0");
		editor.putBoolean("sleepPref", true);
		editor.commit();
		
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'info.bpace.munchlife.MunchLifeActivity'
		solo.waitForActivity(info.bpace.munchlife.MunchLifeActivity.class, 10000);
	}
}
