package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import net.mandaria.tippytipper.widgets.NumberPicker;
import net.mandaria.tippytipper.widgets.NumberPickerButton;

import com.robotium.solo.*;

import android.content.Context;
import android.test.ActivityInstrumentationTestCase2;
import android.util.AttributeSet;
import android.util.EventLog.Event;
import android.view.KeyEvent;
import android.view.MotionEvent;

public class TippyTipperTestWB extends ActivityInstrumentationTestCase2<TippyTipper> {
	private Solo solo;

	public TippyTipperTestWB() {
		super(TippyTipper.class);
	}

	public void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());

	}

	@Override
	public void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();
	}

	public void testRun() {
		getActivity();
		NumberPicker np = new NumberPicker(this.getActivity());
		np.setEnabled(false);
		np.setSpeed(10);
		// Prova i click lunghi sui pulsanti DEL e CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		solo.clickLongOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete), 2000);
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		solo.clickLongOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear), 2000);

		// Click lunghi sui pulsanti di incremento e decremento
		// Click su Settings dalla action bar
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!",
				solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		solo.clickInList(7, 0);
		solo.clickInList(8, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		solo.clickLongOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1), 2000);
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		solo.clickLongOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1), 2000);
	}
}