package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

import com.robotium.solo.*;


import android.test.ActivityInstrumentationTestCase2;
import android.view.KeyEvent;

public class TippyTipperTestLinks extends ActivityInstrumentationTestCase2<TippyTipper> {
	private Solo solo;

	public TippyTipperTestLinks() {
		super(TippyTipper.class);
	}

	public void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
	}

	@Override
	public void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();
	}

	public void testRun() throws IOException {
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);
		// Set default small timeout to 11648 milliseconds
		Timeout.setSmallTimeout(11648);
		solo.sendKey(KeyEvent.KEYCODE_MENU);
		solo.sendKey(KeyEvent.KEYCODE_ENTER);
		solo.goBack();
		solo.sendKey(KeyEvent.KEYCODE_MENU);
		solo.sendKey(KeyEvent.KEYCODE_DPAD_RIGHT);
		solo.sendKey(KeyEvent.KEYCODE_ENTER);
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!",
				solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		URL u;

		u = new URL("http://www.bryandenny.com");

		HttpURLConnection huc = (HttpURLConnection) u.openConnection();
		try {
			huc.setRequestMethod("GET");
		} catch (ProtocolException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		assertEquals(huc.getResponseCode(), HttpURLConnection.HTTP_OK);

		u = new URL("https://code.google.com/archive/p/tippytipper/");

		huc = (HttpURLConnection) u.openConnection();
		try {
			huc.setRequestMethod("GET");
		} catch (ProtocolException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		assertEquals(huc.getResponseCode(), HttpURLConnection.HTTP_OK);
		u = new URL("https://twitter.com/mandlar");

		huc = (HttpURLConnection) u.openConnection();
		try {
			huc.setRequestMethod("GET");
		} catch (ProtocolException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		assertEquals(huc.getResponseCode(), HttpURLConnection.HTTP_OK);

		solo.goBack();
		solo.sendKey(KeyEvent.KEYCODE_HOME);
	}
}