package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import com.robotium.solo.*;

import android.test.ActivityInstrumentationTestCase2;


public class TippyTipperTest extends ActivityInstrumentationTestCase2<TippyTipper> {
  	private Solo solo;
  	public TippyTipperTest() {
		super(TippyTipper.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);
		Timeout.setSmallTimeout(11648);
		// Test di tutti i pulsanti numerici
		// Click su bottone numero 1
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Importo: '$0.01'
		assertEquals("$0.01", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 2
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Importo: '$0.12'
		assertEquals("$0.12", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 3
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Importo: '$1.23'
		assertEquals("$1.23", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 4
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_four));
		// Importo: '$12.34'
		assertEquals("$12.34", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 5
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Importo: '$123.45'
		assertEquals("$123.45", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 6
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		// Importo: '$1,234.56'
		assertEquals("$1,234.56", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 7
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_seven));
		// Importo: '$12,345.67'
		assertEquals("$12,345.67", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 8
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_eight));
		// Importo: '$123,456.78'
		assertEquals("$123,456.78", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 9
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_nine));
		// Importo: '$1,234,567.89'
		assertEquals("$1,234,567.89", ((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount)).getText().toString());
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$12,345,678.90'
		// Click su pulsante DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Importo: '$1,234,567.89'
		// Click su DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Importo: '$123,456.78'
		// Click su CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Importo: '$0.00'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$0.00'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$0.00'
		// Click su bottone numero 1
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Importo: '$0.01'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$0.10'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Inserisce il testo: '$1.00'
		// Click su DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Importo: '$0.10'
		// Click su DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Importo: '$0.01'
		// Click su DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Importo: '$0.00'
		// Click su bottone numero 1
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Importo: '$0.01'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$0.10'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$1.00'
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Importo: '$10.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$stringa testo 1");
		// Click su bottone numero 0
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Inserisce il testo: '$100.00'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$stringa testo 2");
		
		
		// Effettua il calcolo
		// Click su 'Calculate!'
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Variazione della percentuale di mancia con valori predefiniti
		// Click su 11%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click su 16%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click su 21%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Variazione percentuale con SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 18);
		// Click su Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click su Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		
		// Il click su Split Bill apre una nuova finestra
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Rimuove paganti fino a raggiungere il limite minimo
		// Click bottone per rimuovere persona
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		solo.clickLongOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person), 1000);
		// Preme menu back key
		solo.goBack();
		// Preme menu back key
		solo.goBack();
		
		// Click su Settings dalla action bar
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click su Settings
		
		// Click su 'Default Tip Percentage Percentage to tip by default'
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Imposta la percentuale di default con la SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 17);
		// Click su OK
		// Fa lo stesso ma annulla l'operazione
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click su 'Default Tip Percentage Percentage to tip by default'
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Cancel'
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Modifica prima percentuale preimpostata
		// Click su 'First Tip Percentage Custom value for first tip percentage preset'
		solo.clickInList(3, 0);
		solo.waitForDialogToOpen(5000);
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 13);
		// Click su OK
		// Inizia la stessa operazione ma annulla
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.clickInList(3, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Modifica seconda e terza percentuale di preset
		// Click su 'Second Tip Percentage Custom value for second tip percentage preset' 
		solo.clickInList(4, 0);
		solo.waitForDialogToOpen(5000);
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 17);
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click su 'Second Tip Percentage Custom value for second tip percentage preset'
		solo.clickInList(4, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click su 'Third Tip Percentage Custom value for third tip percentage preset'
		solo.clickInList(5, 0);
		solo.waitForDialogToOpen(5000);
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 22);
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click su 'Third Tip Percentage Custom value for third tip percentage preset'
		solo.clickInList(5, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// Abilita l'esclusione della tassa dalla mancia
		// Click su Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickInList(7, 0);
		// Imposta la tassa da escludere dalla mancia
		solo.clickInList(8, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement, 1));
		// Imposta: '999'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "999");
		// Imposta: 'testo'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "testo");
		// Imposta: '998'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "998");
		// Clicca sul pulsante di incremento
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Inserisce valore limite: '999'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "999");
		// Clicca sul pulsante di incremento per verificare limite superiore
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Inserisce il testo: '000'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "000");
		// Clicca sul pulsante di incremento
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment, 1));
		// Imposta: '001'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "001");
		// Clicca sul pulsante di decremento
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Imposta: '2'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Imposta: '001'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "001");
		// Imposta: '1'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "1");
		// Clicca sul pulsante di decremento per verificare limite inferiore
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Imposta valore limite: '0' dopo aver provato altri valori alfanumerici
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "7777");
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "A10");
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Click su OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// Prova di annullamento operazione
		// Click su 'Tax Rate to Exclude The tax rate to exclude when calculating tip'
		solo.clickInList(8, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// Interagisce con l'interfaccia per il settaggio della tassa alla ricerca di eccezioni
		// Click su Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickInList(8, 0);
		solo.waitForDialogToOpen(5000);
		// Impostazione con timepicker_input
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		// Inserisce: '999'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "999");
		// Preme bottone next
		solo.pressSoftKeyboardNextButton();
		Timeout.setSmallTimeout(15315);
		// Clicca sul valore 001
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		// Inserisce testo: '999'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "999");
		// Inserisce valore a 5 cifre: '00199'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input, 1), "00199");
		// Preme bottone next
		solo.pressSoftKeyboardNextButton();
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "999");
		// Click su OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		
		// Prova i vari tipi di arrotondamento
		// Click su 'Round Type Choose to round by tip or total LinearLayout
		solo.clickInList(10, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Round Tip
		solo.clickOnView(solo.getView(android.R.id.text1));
		
		// Click su Round Type Choose to round by tip or total LinearLayout
		solo.clickInList(10, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Cancel
		solo.clickOnView(solo.getView(android.R.id.button2));
		
		// Scroll to Default Number People The number of people to split bill by LinearLayout
		android.widget.ListView listView0 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView0, 3);
		// Click su Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		solo.waitForDialogToOpen(5000);
		// Clicca sul pulsante di decremento
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '8'
		// Click su net.mandaria.tippytipper.R$id.timepicker_input
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		// Inserisce il testo: '0'
		// Preme bottone next
		solo.pressSoftKeyboardNextButton();
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '7'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '6'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '5'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '4'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '3'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '2'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '20'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "20");
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '19'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "19");
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.decrement));
		// Inserisce il testo: '18'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Inserisce il testo: '19'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Inserisce il testo: '20'
		// Click su ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Inserisce il testo: '2'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Click su net.mandaria.tippytipper.R$id.timepicker_input
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		// Inserisce il testo: '0'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "0");
		// Inserisce il testo: '2'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "2");
		// Click su OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		
		// Cambia il numero di persone di default con cui dividere il conto
		// Click su Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		solo.waitForDialogToOpen(5000);
		// Click su Cancel
		
		solo.clickOnView(solo.getView(android.R.id.button2));
		// Click su Enable Error Logging Application reports anonymous error/event information 
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		// Preme 'menu back key'
		solo.goBack();
		
		// Torna alla main activity e riesegue il calcolo sopo i settaggi
		// Click su Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click su 13%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click su 17%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click su 22%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click su Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click su Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 0);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 40);
		// Click su Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click su Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click su Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click su net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click su net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click su net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Preme menu back key
		solo.goBack();
		// Click su action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		
		// Riapre Settings
		solo.goBack();
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click su 'Enable Exclude Tax Rate Excludes tax rate from tip when enabled'
		solo.clickInList(7, 0);
		// Scroll fino a Round Type Choose to round by tip or total
		android.widget.ListView listView1 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView1, 3);
		
		// Click su Round Type Choose to round by tip or total LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Round Type"));
		solo.waitForDialogToOpen(5000);
		// Click su 'Round Total'
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		
		// Click su 'Enable Error Logging Application reports anonymous error/event information'
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		// Prova scroll Scroll to 492527
		android.widget.ListView listView2 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView2, 0);
		
		// Torna indietro e riprova le operazioni di base
		solo.goBack();
		// Click su Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click su Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Preme menu back key
		solo.goBack();
	}
}
