package kdk.android.simplydo.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import com.robotium.solo.Solo;
import com.robotium.solo.Timeout;

import android.os.Bundle;
import android.os.Environment;
import android.test.ActivityInstrumentationTestCase2;
import android.util.Log;
import kdk.android.simplydo.CachingDataViewer;
import kdk.android.simplydo.DataManager;
import kdk.android.simplydo.ItemDesc;
import kdk.android.simplydo.L;
import kdk.android.simplydo.ListDesc;
import kdk.android.simplydo.ListListSorter;
import kdk.android.simplydo.RestoreActivity;
import kdk.android.simplydo.SettingsActivity;
import kdk.android.simplydo.SimplyDoActivity;

public class SimplyDoWBTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
	private Solo solo;

	public SimplyDoWBTest() {
		super(SimplyDoActivity.class);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());
	}

	protected void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();

	}

	public void testRun0() {
		getActivity();
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		Timeout.setSmallTimeout(14193);
		// Spostamento azione e annullamento operazione
		solo.clickInList(1, 0);
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(4, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.text1, 0));
		solo.clickOnView(solo.getView(android.R.id.button2));
		solo.waitForDialogToClose(5000);

	}

	// Modifica di un'azione e annullamento operazione
	public void testRun1() {
		getActivity();
		solo.clickInList(1, 0);
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click on 'Edit'
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.clickOnView(solo.getView(android.R.id.button2));
	}

	// Conferma modifica con key Enter
	public void testRun2() {
		getActivity();
		solo.clickInList(1, 0);
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.EditItemLabelEditText));
		solo.sendKey(Solo.ENTER);
	}

	public void testRun3() {
		getActivity();
		// Invocazione del metodo add della classe ListDesc
		Method method;
		ListDesc ld = new ListDesc();
		List<ListDesc> list = new ArrayList<ListDesc>();
		list.add(ld);
		// Invocazione del metodo createItem della classe DataManager
		DataManager dm = new DataManager(this.getActivity());
		dm.createItem(-1, "prova");
		// Invocazione del metodo sort e setSortingMode di ListListSorter
		ListListSorter lls = new ListListSorter();
		lls.sort(list);
		lls.setSortingMode("ciao");
		// Riflessione per testing del metodo itemIdBarrier e flushTaskNoLock di
		// CachingDataViewer
		CachingDataViewer cdv = new CachingDataViewer(null);
		cdv.fetchList(1);
		cdv.createItem("prova");
		cdv.deleteInactive();
		try {
			method = cdv.getClass().getDeclaredMethod("itemIdBarrier", ItemDesc.class);
			method.setAccessible(true);
			method.invoke(cdv, -1);
			method = cdv.getClass().getDeclaredMethod("flushTasksNoLock");
			method.setAccessible(true);
			method.invoke(cdv);
		} catch (SecurityException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchMethodException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Riflessione per testing del metodo sort di ListListSorter
		try {
			method = lls.getClass().getDeclaredMethod("sort", List.class);
			method.invoke(lls.getClass(), "null");
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	// Riflessione per il testing del metodo setId di ListDesc
	public void testRun4() {
		L l = new L();
		ListDesc ld = new ListDesc();
		Method method;

		try {
			method = ld.getClass().getDeclaredMethod("setId", int.class);
			method.setAccessible(true);
			method.invoke(ld, 1);
		} catch (SecurityException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchMethodException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Riflessione per il testing del metodo doRestore di RestoreActivity
		try {
			RestoreActivity c = new RestoreActivity();
			method = c.getClass().getDeclaredMethod("doRestore");
			method.setAccessible(true);
			// c.doRestore();
			method.invoke(c);
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}