package kdk.android.simplydo.test;

import kdk.android.simplydo.SimplyDoActivity;
import com.robotium.solo.*;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.test.ActivityInstrumentationTestCase2;

public class SimplyDoSettingsTest extends ActivityInstrumentationTestCase2<SimplyDoActivity> {
	private Solo solo;

	public SimplyDoSettingsTest() {
		super(SimplyDoActivity.class);
	}

	public void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
	}

	@Override
	public void tearDown() throws Exception {
		solo.finishOpenedActivities();
		super.tearDown();
	}

	public void testRun() {
		// Wait for activity: 'kdk.android.simplydo.SimplyDoActivity'
		solo.waitForActivity(kdk.android.simplydo.SimplyDoActivity.class, 2000);
		Timeout.setSmallTimeout(14193);

		// Aggiunge un elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// dal nome: 'a lista per settings'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"a lista per settings");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		//Aggiunge un secondo elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// dal nome: 'b lista per settings'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"b lista per settings");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		
		// Aggiunta di un terzo elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// Enter the text: 'c lista per settings'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"c lista per settings");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));
		
		// Test apertura e chiusura 'Settings'
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Annulla con back key
		solo.goBack();

		// Test per l'ordinamento
		solo.clickOnActionBarItem(0x6a);
		// Attende: 'kdk.android.simplydo.SettingsActivity'
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Clicca voce per l'ordinamento
		solo.clickInList(2, 0);
		// Attende dialog di ordinamento
		solo.waitForDialogToOpen(5000);
		// Click su 'Annulla'
		solo.clickOnView(solo.getView(android.R.id.text1, 0));
		solo.goBack();
		
		// Test apertura action bar con apertura settings
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		solo.clickInList(2, 0);
		solo.waitForDialogToOpen(5000);
		// Click on Alphabetical
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		solo.goBack();

		// Backup e restore delle sole liste senza item
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click su Backup Now
		solo.clickInList(4, 0);
		solo.goBack();
		
		// Aggiunge una quarta lista dopo il salvataggio del backup
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		// dal nome: 'd lista per settings dopo backup'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddListEditText),
				"d lista per settings dopo backup");
		// Click on Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddListButton));

		// Test 'Restore' dopo modifica
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click su Restore
		solo.clickInList(5, 0);
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click sull'ultimo file di backup
		solo.clickInList(1, 0);
		// Attende dialog di conferma
		solo.waitForDialogToOpen(5000);
		// Click su Yes
		solo.clickOnView(solo.getView(android.R.id.button1));
		solo.waitForDialogToClose(5000);
		solo.goBack();

		// Testa Settings per item
		// Click su 'lista 1'
		solo.clickInList(1, 0);
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Aggiunge: 'azione attiva' all'elenco
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione attiva");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Aggiunge: 'azione attiva starred' all'elenco
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione attiva starred");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Marca con stella
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		
		// Aggiunge 'azione inattiva' all'elenco
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione inattiva");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		
		// Aggiunge 'azione inattiva starred'
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione inattiva starred");
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));
		// Caratterizza le azioni
		solo.clickLongInList(3, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Add Star
		solo.clickInList(3, 0);
		// Disattiva
		solo.clickInList(1, 0);
		//Disattiva
		solo.clickInList(2, 0);
		solo.clickLongInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Add Star
		solo.clickInList(3, 0);

		// Test apertura action bar con apertura settings di ordinamento item e
		// annullamento
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));

		// Ordinamento item 'None'
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su Alphabetical
		solo.clickOnView(solo.getView(android.R.id.text1, 0));
		solo.goBack();

		// Ordinamento item 'Starred first'
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.text1, 1));
		solo.goBack();

		// Ordinamento item 'Active first'
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		solo.clickInList(1, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		solo.clickOnView(solo.getView(android.R.id.text1, 2));

		// Backup e restore delle azioni dopo aggiunta item
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click on 'Backup Now'
		solo.clickInList(4, 0);
		// due chiamate di backup consecutive
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		solo.clickInList(4, 0);
		solo.goBack();
		
		// Aggiunge una nuova azione
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// dal nome: 'azione prima dopo backup e prima del restore'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"azione prima dopo backup e prima del restore");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		// Restore dopo modifica
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		// Click su 'Restore'
		solo.clickInList(5, 0);
		assertTrue("kdk.android.simplydo.RestoreActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.RestoreActivity.class));
		// Click sul file di backup
		solo.clickInList(1, 0);
		solo.waitForDialogToOpen(5000);
		// Click su 'Yes'
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Wait for dialog to close
		solo.waitForDialogToClose(5000);
		solo.goBack();
		solo.clickInList(1, 0);

		// Eliminazione item inattivi senza conferma
		solo.clickOnActionBarItem(0x6a);
		assertTrue("kdk.android.simplydo.SettingsActivity is not found!",
				solo.waitForActivity(kdk.android.simplydo.SettingsActivity.class));
		solo.clickInList(3, 0);
		solo.goBack();
		solo.clickOnActionBarItem(0x64);

		// Aggiunta azione e backup
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		// Enter the text: 'lista 1'
		solo.clearEditText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText));
		solo.enterText((android.widget.EditText) solo.getView(kdk.android.simplydo.R.id.AddItemEditText),
				"nuova azione");
		// Click su Add
		solo.clickOnView(solo.getView(kdk.android.simplydo.R.id.AddItemButton));

		Activity currentActivity = solo.getCurrentActivity();

		// Chiusura activity
		solo.finishOpenedActivities();
		PackageManager packageManager = currentActivity.getPackageManager();
		// e prova il ripristino
		currentActivity.startActivity(packageManager.getLaunchIntentForPackage("kdk.android.simplydo"));
	}
}
